/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - Spherical Shape")
@Description(value={"Forms a 'spherical shaped' vector using yaw and pitch to manipulate the current point."})
@Examples(value={"loop 360 times:", "\tset {_v} to spherical vector radius 1, yaw loop-value, pitch loop-value", "set {_v} to spherical vector radius 1, yaw 45, pitch 90"})
@Since(value="2.2-dev28")
public class ExprVectorSpherical
extends SimpleExpression<Vector> {
    private Expression<Number> radius;
    private Expression<Number> yaw;
    private Expression<Number> pitch;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.radius = exprs[0];
        this.yaw = exprs[1];
        this.pitch = exprs[2];
        return true;
    }

    protected Vector[] get(Event event) {
        Number radius = this.radius.getSingle(event);
        Number yaw = this.yaw.getSingle(event);
        Number pitch = this.pitch.getSingle(event);
        if (radius == null || yaw == null || pitch == null) {
            return null;
        }
        return CollectionUtils.array(VectorMath.fromSphericalCoordinates(radius.doubleValue(), VectorMath.fromSkriptYaw(yaw.floatValue()), pitch.floatValue() + 90.0f));
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public Class<? extends Vector> getReturnType() {
        return Vector.class;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "spherical vector with radius " + this.radius.toString(event, debug) + ", yaw " + this.yaw.toString(event, debug) + " and pitch" + this.pitch.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprVectorSpherical.class, Vector.class, ExpressionType.SIMPLE, "[new] spherical vector [(from|with)] [radius] %number%, [yaw] %number%(,| and) [pitch] %number%");
    }
}

