/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Vectors - XYZ Component")
@Description(value={"Gets or changes the x, y or z component of a vector."})
@Examples(value={"set {_v} to vector 1, 2, 3", "send \"%x of {_v}%, %y of {_v}%, %z of {_v}%\"", "add 1 to x of {_v}", "add 2 to y of {_v}", "add 3 to z of {_v}", "send \"%x of {_v}%, %y of {_v}%, %z of {_v}%\"", "set x component of {_v::*} to 1", "set y component of {_v::*} to 2", "set z component of {_v::*} to 3", "send \"%x component of {_v::*}%, %y component of {_v::*}%, %z component of {_v::*}%\""})
@Since(value="2.2-dev28")
public class ExprVectorXYZ
extends SimplePropertyExpression<Vector, Number> {
    private static final Character[] axes;
    private int axis;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        super.init(exprs, matchedPattern, isDelayed, parseResult);
        this.axis = parseResult.mark;
        return true;
    }

    @Override
    public Number convert(Vector vector) {
        return this.axis == 0 ? vector.getX() : (this.axis == 1 ? vector.getY() : vector.getZ());
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if ((mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) && Changer.ChangerUtils.acceptsChange(this.getExpr(), Changer.ChangeMode.SET, Vector.class)) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        assert (delta != null);
        Object[] vectors = (Vector[])this.getExpr().getArray(event);
        double deltaValue = ((Number)delta[0]).doubleValue();
        switch (mode) {
            case REMOVE: {
                deltaValue = -deltaValue;
            }
            case ADD: {
                for (Vector vector : vectors) {
                    if (this.axis == 0) {
                        vector.setX(vector.getX() + deltaValue);
                        continue;
                    }
                    if (this.axis == 1) {
                        vector.setY(vector.getY() + deltaValue);
                        continue;
                    }
                    vector.setZ(vector.getZ() + deltaValue);
                }
                break;
            }
            case SET: {
                for (Vector vector : vectors) {
                    if (this.axis == 0) {
                        vector.setX(deltaValue);
                        continue;
                    }
                    if (this.axis == 1) {
                        vector.setY(deltaValue);
                        continue;
                    }
                    vector.setZ(deltaValue);
                }
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        this.getExpr().change(event, vectors, Changer.ChangeMode.SET);
    }

    @Override
    public Class<Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return axes[this.axis] + " component";
    }

    static {
        ExprVectorXYZ.register(ExprVectorXYZ.class, Number.class, "[vector] (0\u00a6x|1\u00a6y|2\u00a6z) [component[s]]", "vectors");
        axes = new Character[]{Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    }
}

