/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import ch.njol.util.VectorMath;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

@Name(value="Yaw / Pitch")
@Description(value={"The yaw or pitch of a location or vector."})
@Examples(value={"log \"%player%: %location of player%, %player's yaw%, %player's pitch%\" to \"playerlocs.log\"", "set {_yaw} to yaw of player", "set {_p} to pitch of target entity"})
@Since(value="2.0, 2.2-dev28 (vector yaw/pitch)")
public class ExprYawPitch
extends SimplePropertyExpression<Object, Number> {
    private boolean usesYaw;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.usesYaw = parseResult.mark == 0;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    @Override
    public Number convert(Object object) {
        if (object instanceof Location) {
            Location l = (Location)object;
            return Float.valueOf(this.usesYaw ? this.convertToPositive(l.getYaw()) : l.getPitch());
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (this.usesYaw) {
                return Float.valueOf(VectorMath.skriptYaw(VectorMath.getYaw(vector)));
            }
            return Float.valueOf(VectorMath.skriptPitch(VectorMath.getPitch(vector)));
        }
        return null;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return CollectionUtils.array(Number.class);
        }
        return null;
    }

    @Override
    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null) {
            return;
        }
        float value = ((Number)delta[0]).floatValue();
        for (Object single : this.getExpr().getArray(e)) {
            if (single instanceof Location) {
                this.changeLocation((Location)single, value, mode);
                continue;
            }
            if (!(single instanceof Vector)) continue;
            this.changeVector((Vector)single, value, mode);
        }
    }

    private void changeLocation(Location l, float value, Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                if (this.usesYaw) {
                    l.setYaw(this.convertToPositive(value));
                    break;
                }
                l.setPitch(value);
                break;
            }
            case ADD: {
                if (this.usesYaw) {
                    l.setYaw(this.convertToPositive(l.getYaw()) + value);
                    break;
                }
                l.setPitch(l.getPitch() + value);
                break;
            }
            case REMOVE: {
                if (this.usesYaw) {
                    l.setYaw(this.convertToPositive(l.getYaw()) - value);
                    break;
                }
                l.setPitch(l.getPitch() - value);
                break;
            }
        }
    }

    private void changeVector(Vector vector, float n, Changer.ChangeMode mode) {
        float yaw = VectorMath.getYaw(vector);
        float pitch = VectorMath.getPitch(vector);
        switch (mode) {
            case REMOVE: {
                n = -n;
            }
            case ADD: {
                if (this.usesYaw) {
                    yaw += n;
                } else {
                    pitch -= n;
                }
                Vector newVector = VectorMath.fromYawAndPitch(yaw, pitch).multiply(vector.length());
                VectorMath.copyVector(vector, newVector);
                break;
            }
            case SET: {
                if (this.usesYaw) {
                    yaw = VectorMath.fromSkriptYaw(n);
                } else {
                    pitch = VectorMath.fromSkriptPitch(n);
                }
                Vector newVector = VectorMath.fromYawAndPitch(yaw, pitch).multiply(vector.length());
                VectorMath.copyVector(vector, newVector);
            }
        }
    }

    public float convertToPositive(float f) {
        if (f != 0.0f && f * -1.0f == Math.abs(f)) {
            return 360.0f + f;
        }
        return f;
    }

    @Override
    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    @Override
    protected String getPropertyName() {
        return this.usesYaw ? "yaw" : "pitch";
    }

    static {
        ExprYawPitch.register(ExprYawPitch.class, Number.class, "(0\u00a6yaw|1\u00a6pitch)", "locations/vectors");
    }
}

