/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SectionSkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.SyntaxElement;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.structure.Structure;

public abstract class Section
extends TriggerSection
implements SyntaxElement {
    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        SectionContext sectionContext = this.getParser().getData(SectionContext.class);
        return this.init(expressions, matchedPattern, isDelayed, parseResult, sectionContext.sectionNode, sectionContext.triggerItems);
    }

    public abstract boolean init(Expression<?>[] var1, int var2, Kleenean var3, SkriptParser.ParseResult var4, SectionNode var5, List<TriggerItem> var6);

    protected void loadCode(SectionNode sectionNode) {
        List<TriggerSection> currentSections = this.getParser().getCurrentSections();
        currentSections.add(this);
        try {
            this.setTriggerItems(ScriptLoader.loadItems(sectionNode));
        }
        finally {
            currentSections.remove(currentSections.size() - 1);
        }
    }

    @SafeVarargs
    protected final Trigger loadCode(SectionNode sectionNode, String name, Class<? extends Event> ... events) {
        return this.loadCode(sectionNode, name, (Runnable)null, events);
    }

    @SafeVarargs
    protected final Trigger loadCode(SectionNode sectionNode, String name, @Nullable Runnable afterLoading, Class<? extends Event> ... events) {
        ParserInstance parser = this.getParser();
        String previousName = parser.getCurrentEventName();
        Class<? extends Event>[] previousEvents = parser.getCurrentEvents();
        Structure previousStructure = parser.getCurrentStructure();
        List<TriggerSection> previousSections = parser.getCurrentSections();
        Kleenean previousDelay = parser.getHasDelayBefore();
        parser.setCurrentEvent(name, events);
        SectionSkriptEvent skriptEvent = new SectionSkriptEvent(name, this);
        parser.setCurrentStructure(skriptEvent);
        parser.setCurrentSections(new ArrayList<TriggerSection>());
        parser.setHasDelayBefore(Kleenean.FALSE);
        ArrayList<TriggerItem> triggerItems = ScriptLoader.loadItems(sectionNode);
        if (afterLoading != null) {
            afterLoading.run();
        }
        parser.setCurrentEvent(previousName, previousEvents);
        parser.setCurrentStructure(previousStructure);
        parser.setCurrentSections(previousSections);
        parser.setHasDelayBefore(previousDelay);
        return new Trigger(parser.getCurrentScript(), name, skriptEvent, triggerItems);
    }

    protected void loadOptionalCode(SectionNode sectionNode) {
        Kleenean hadDelayBefore = this.getParser().getHasDelayBefore();
        this.loadCode(sectionNode);
        if (hadDelayBefore.isTrue()) {
            return;
        }
        if (!this.getParser().getHasDelayBefore().isFalse()) {
            this.getParser().setHasDelayBefore(Kleenean.UNKNOWN);
        }
    }

    public static @Nullable Section parse(String expr, @Nullable String defaultError, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        SectionContext sectionContext = ParserInstance.get().getData(SectionContext.class);
        return sectionContext.modify(sectionNode, triggerItems, () -> SkriptParser.parse(expr, Skript.getSections().iterator(), defaultError));
    }

    static {
        ParserInstance.registerData(SectionContext.class, SectionContext::new);
    }

    protected static class SectionContext
    extends ParserInstance.Data {
        protected SectionNode sectionNode;
        protected List<TriggerItem> triggerItems;

        public SectionContext(ParserInstance parserInstance) {
            super(parserInstance);
        }

        protected <T> T modify(SectionNode sectionNode, List<TriggerItem> triggerItems, Supplier<T> supplier) {
            SectionNode prevSectionNode = this.sectionNode;
            List<TriggerItem> prevTriggerItems = this.triggerItems;
            this.sectionNode = sectionNode;
            this.triggerItems = triggerItems;
            T result = supplier.get();
            this.sectionNode = prevSectionNode;
            this.triggerItems = prevTriggerItems;
            return result;
        }
    }
}

