/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.lang.SyntaxElement;
import java.util.Arrays;

public class SyntaxElementInfo<E extends SyntaxElement> {
    public final Class<E> elementClass;
    public final String[] patterns;
    public final String originClassPath;

    public SyntaxElementInfo(String[] patterns, Class<E> elementClass, String originClassPath) throws IllegalArgumentException {
        this.patterns = patterns;
        this.elementClass = elementClass;
        this.originClassPath = originClassPath;
        try {
            elementClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error(elementClass + " does not have a public nullary constructor", e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Skript cannot run properly because a security manager is blocking it!");
        }
    }

    public Class<E> getElementClass() {
        return this.elementClass;
    }

    public String[] getPatterns() {
        return Arrays.copyOf(this.patterns, this.patterns.length);
    }

    public String getOriginClassPath() {
        return this.originClassPath;
    }
}

