/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptConfig;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.expressions.ExprColoured;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionList;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.parser.ParserInstance;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.BlockingLogHandler;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.structures.StructVariables;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.chat.ChatMessages;
import ch.njol.skript.util.chat.MessageComponent;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.SingleItemIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.script.Script;

public class VariableString
implements Expression<String> {
    private final @Nullable Script script;
    private final String orig;
    private final @Nullable Object[] strings;
    private @Nullable Object[] stringsUnformatted;
    private final boolean isSimple;
    private final @Nullable String simple;
    private final @Nullable String simpleUnformatted;
    private final StringMode mode;
    private final MessageComponent[] components;

    private VariableString(String input) {
        this.isSimple = true;
        this.simpleUnformatted = input.replace("%%", "%");
        this.orig = this.simple = Utils.replaceChatStyles(this.simpleUnformatted);
        this.strings = null;
        this.mode = StringMode.MESSAGE;
        ParserInstance parser = this.getParser();
        this.script = parser.isActive() ? parser.getCurrentScript() : null;
        this.components = new MessageComponent[]{ChatMessages.plainText(this.simpleUnformatted)};
    }

    private VariableString(String original, Object[] strings, StringMode mode) {
        this.orig = original;
        this.strings = new Object[strings.length];
        this.stringsUnformatted = new Object[strings.length];
        ParserInstance parser = this.getParser();
        this.script = parser.isActive() ? parser.getCurrentScript() : null;
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            Object object = strings[i];
            if (object instanceof String) {
                this.strings[i] = Utils.replaceChatStyles((String)object);
                components.addAll(ChatMessages.parse((String)object));
            } else {
                this.strings[i] = object;
                components.add(null);
            }
            this.stringsUnformatted[i] = object;
        }
        this.components = components.toArray(new MessageComponent[0]);
        this.mode = mode;
        this.isSimple = false;
        this.simple = null;
        this.simpleUnformatted = null;
    }

    public static @Nullable VariableString newInstance(String input) {
        return VariableString.newInstance(input, StringMode.MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable VariableString newInstance(String original, StringMode mode) {
        if (mode != StringMode.VARIABLE_NAME && !VariableString.isQuotedCorrectly(original, false)) {
            return null;
        }
        int percentCount = StringUtils.count(original, '%');
        if (percentCount % 2 != 0) {
            Skript.error("The percent sign is used for expressions (e.g. %player%). To insert a '%' type it twice: %%.");
            return null;
        }
        if (mode != StringMode.VARIABLE_NAME) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean expression = false;
            for (int i = 0; i < original.length(); ++i) {
                char c = original.charAt(i);
                stringBuilder.append(c);
                if (c == '%') {
                    boolean bl = expression = !expression;
                }
                if (expression || c != '\"') continue;
                ++i;
            }
            original = stringBuilder.toString();
        }
        ArrayList<Object> strings = new ArrayList<Object>(percentCount / 2 + 2);
        int exprStart = original.indexOf(37);
        if (exprStart != -1) {
            if (exprStart != 0) {
                strings.add(original.substring(0, exprStart));
            }
            while (exprStart != original.length()) {
                String literalString;
                int variableStart;
                int exprEnd = original.indexOf(37, exprStart + 1);
                int variableEnd = exprStart;
                while (exprEnd != -1 && (variableStart = original.indexOf(123, variableEnd + 1)) != -1 && variableStart < exprEnd) {
                    variableEnd = VariableString.nextVariableBracket(original, variableStart + 1);
                    if (variableEnd == -1) {
                        Skript.error("Missing closing bracket '}' to end variable");
                        return null;
                    }
                    exprEnd = original.indexOf(37, variableEnd + 1);
                }
                if (exprEnd == -1) {
                    assert (false);
                    return null;
                }
                if (exprStart + 1 == exprEnd) {
                    if (strings.size() > 0 && strings.get(strings.size() - 1) instanceof String) {
                        strings.set(strings.size() - 1, strings.get(strings.size() - 1) + "%");
                    } else {
                        strings.add("%");
                    }
                } else {
                    RetainingLogHandler log = SkriptLogger.startRetainingLog();
                    try {
                        Expression expr = new SkriptParser(original.substring(exprStart + 1, exprEnd), 1, ParseContext.DEFAULT).parseExpression(Object.class);
                        if (expr == null) {
                            log.printErrors("Can't understand this expression: " + original.substring(exprStart + 1, exprEnd));
                            VariableString variableString = null;
                            return variableString;
                        }
                        if (!SkriptConfig.usePlayerUUIDsInVariableNames.value().booleanValue() && OfflinePlayer.class.isAssignableFrom(expr.getReturnType())) {
                            Skript.warning("In the future, players in variable names will use the player's UUID instead of their name. For information on how to make sure your scripts won't be impacted by this change, see https://github.com/SkriptLang/Skript/discussions/6270.");
                        }
                        strings.add(expr);
                        log.printLog();
                    }
                    finally {
                        log.stop();
                    }
                }
                exprStart = original.indexOf(37, exprEnd + 1);
                if (exprStart == -1) {
                    exprStart = original.length();
                }
                if ((literalString = original.substring(exprEnd + 1, exprStart)).isEmpty()) continue;
                if (strings.size() > 0 && strings.get(strings.size() - 1) instanceof String) {
                    strings.set(strings.size() - 1, strings.get(strings.size() - 1) + literalString);
                    continue;
                }
                strings.add(literalString);
            }
        } else {
            strings.add(original);
        }
        if (strings.size() == 1 && strings.get(0) instanceof String) {
            return new VariableString(original);
        }
        if (strings.size() == 1 && strings.get(0) instanceof Expression && ((Expression)strings.get(0)).getReturnType() == String.class && ((Expression)strings.get(0)).isSingle() && mode == StringMode.MESSAGE) {
            String expr = ((Expression)strings.get(0)).toString(null, false);
            Skript.warning(expr + " is already a text, so you should not put it in one (e.g. " + expr + " instead of \"%" + expr.replace("\"", "\"\"") + "%\")");
        }
        return new VariableString(original, strings.toArray(), mode);
    }

    public static String quote(String string) {
        StringBuilder fixed = new StringBuilder();
        boolean inExpression = false;
        for (char character : string.toCharArray()) {
            if (character == '%') {
                boolean bl = inExpression = !inExpression;
            }
            if (!inExpression && character == '\"') {
                fixed.append('\"');
            }
            fixed.append(character);
        }
        return fixed.toString();
    }

    public static boolean isQuotedCorrectly(String string, boolean withQuotes) {
        if (!(!withQuotes || string.startsWith("\"") && string.endsWith("\"") && string.length() >= 2)) {
            return false;
        }
        boolean quote = false;
        boolean percentage = false;
        if (withQuotes) {
            string = string.substring(1, string.length() - 1);
        }
        for (char character : string.toCharArray()) {
            if (percentage) {
                if (character != '%') continue;
                percentage = false;
                continue;
            }
            if (quote && character != '\"') {
                return false;
            }
            if (character == '\"') {
                quote = !quote;
                continue;
            }
            if (character != '%') continue;
            percentage = true;
        }
        return !quote;
    }

    public static String unquote(String string, boolean surroundingQuotes) {
        assert (VariableString.isQuotedCorrectly(string, surroundingQuotes));
        if (surroundingQuotes) {
            return string.substring(1, string.length() - 1).replace("\"\"", "\"");
        }
        return string.replace("\"\"", "\"");
    }

    public static int nextVariableBracket(String string, int start) {
        int variableDepth = 0;
        for (int index = start; index < string.length(); ++index) {
            if (string.charAt(index) == '}') {
                if (variableDepth == 0) {
                    return index;
                }
                --variableDepth;
                continue;
            }
            if (string.charAt(index) != '{') continue;
            ++variableDepth;
        }
        return -1;
    }

    public static VariableString[] makeStrings(String[] args) {
        VariableString[] strings = new VariableString[args.length];
        int j = 0;
        for (String arg : args) {
            VariableString variableString = VariableString.newInstance(arg);
            if (variableString == null) continue;
            strings[j++] = variableString;
        }
        if (j != args.length) {
            strings = Arrays.copyOf(strings, j);
        }
        return strings;
    }

    public static @Nullable VariableString[] makeStringsFromQuoted(List<String> args) {
        VariableString[] strings = new VariableString[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            assert (args.get(i).startsWith("\"") && args.get(i).endsWith("\""));
            VariableString variableString = VariableString.newInstance(args.get(i).substring(1, args.get(i).length() - 1));
            if (variableString == null) {
                return null;
            }
            strings[i] = variableString;
        }
        return strings;
    }

    public String toUnformattedString(Event event) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return this.simpleUnformatted;
        }
        Object[] strings = this.stringsUnformatted;
        assert (strings != null);
        StringBuilder builder = new StringBuilder();
        for (Object string : strings) {
            if (string instanceof Expression) {
                builder.append(Classes.toString((Object[])((Expression)string).getArray(event), true, this.mode));
                continue;
            }
            builder.append(string);
        }
        return builder.toString();
    }

    public List<MessageComponent> getMessageComponents(Event event) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return ChatMessages.parse(this.simpleUnformatted);
        }
        Object[] strings = this.stringsUnformatted;
        assert (strings != null);
        ArrayList<MessageComponent> message = new ArrayList<MessageComponent>(this.components.length);
        int stringPart = -1;
        MessageComponent previous = null;
        for (MessageComponent component : this.components) {
            if (component == null) {
                ++stringPart;
                if (previous != null) {
                    ++stringPart;
                }
                Object string = strings[stringPart];
                previous = null;
                String text = null;
                if (string instanceof ExprColoured && ((ExprColoured)string).isUnsafeFormat()) {
                    String unformatted = Classes.toString((Object[])((ExprColoured)string).getArray(event), true, this.mode);
                    if (unformatted == null) continue;
                    message.addAll(ChatMessages.parse(unformatted));
                    continue;
                }
                if (string instanceof Expression) {
                    text = Classes.toString((Object[])((Expression)string).getArray(event), true, this.mode);
                }
                assert (text != null);
                List<MessageComponent> components = ChatMessages.fromParsedString(text);
                if (!message.isEmpty()) {
                    int startSize = message.size();
                    for (int i = 0; i < components.size(); ++i) {
                        MessageComponent plain = components.get(i);
                        ChatMessages.copyStyles((MessageComponent)message.get(startSize + i - 1), plain);
                        message.add(plain);
                    }
                    continue;
                }
                message.addAll(components);
                continue;
            }
            MessageComponent componentCopy = component.copy();
            if (!message.isEmpty()) {
                ChatMessages.copyStyles((MessageComponent)message.get(message.size() - 1), componentCopy);
            }
            message.add(componentCopy);
            previous = componentCopy;
        }
        return message;
    }

    public List<MessageComponent> getMessageComponentsUnsafe(Event event) {
        if (this.isSimple) {
            assert (this.simpleUnformatted != null);
            return ChatMessages.parse(this.simpleUnformatted);
        }
        return ChatMessages.parse(this.toUnformattedString(event));
    }

    public String toChatString(Event event) {
        return ChatMessages.toJson(this.getMessageComponents(event));
    }

    private static @Nullable ChatColor getLastColor(CharSequence sequence) {
        for (int i = sequence.length() - 2; i >= 0; --i) {
            ChatColor color;
            if (sequence.charAt(i) != '\u00a7' || (color = ChatColor.getByChar((char)sequence.charAt(i + 1))) == null || !color.isColor() && color != ChatColor.RESET) continue;
            return color;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString(null, false);
    }

    public String toString(@Nullable Event event) {
        StructVariables.DefaultVariables data;
        if (this.isSimple) {
            assert (this.simple != null);
            return this.simple;
        }
        if (event == null) {
            throw new IllegalArgumentException("Event may not be null in non-simple VariableStrings!");
        }
        Object[] string = this.strings;
        assert (string != null);
        StringBuilder builder = new StringBuilder();
        ArrayList types = new ArrayList();
        for (Object object : string) {
            if (object instanceof Expression) {
                Object[] objects = ((Expression)object).getArray(event);
                if (objects != null && objects.length > 0) {
                    types.add(objects[0].getClass());
                }
                builder.append(Classes.toString(objects, true, this.mode));
                continue;
            }
            builder.append(object);
        }
        String complete = builder.toString();
        if (this.script != null && this.mode == StringMode.VARIABLE_NAME && !types.isEmpty() && (data = this.script.getData(StructVariables.DefaultVariables.class)) != null) {
            data.add(complete, types.toArray(new Class[0]));
        }
        return complete;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.isSimple) {
            assert (this.simple != null);
            return '\"' + this.simple + '\"';
        }
        Object[] string = this.strings;
        assert (string != null);
        StringBuilder builder = new StringBuilder("\"");
        for (Object object : string) {
            if (object instanceof Expression) {
                builder.append("%").append(((Expression)object).toString(event, debug)).append("%");
                continue;
            }
            builder.append(object);
        }
        builder.append('\"');
        return builder.toString();
    }

    @NotNull
    public List<String> getDefaultVariableNames(String variableName, Event event) {
        if (this.script == null || this.mode != StringMode.VARIABLE_NAME) {
            return Lists.newArrayList();
        }
        if (this.isSimple) {
            assert (this.simple != null);
            return Lists.newArrayList((Object[])new String[]{this.simple, "object"});
        }
        StructVariables.DefaultVariables data = this.script.getData(StructVariables.DefaultVariables.class);
        assert (data != null) : "default variables not present in current script";
        Class<?>[] savedHints = data.get(variableName);
        if (savedHints == null || savedHints.length == 0) {
            return Lists.newArrayList();
        }
        ArrayList typeHints = Lists.newArrayList((Object[])new StringBuilder[]{new StringBuilder()});
        int hintIndex = 0;
        assert (this.strings != null);
        for (Object object : this.strings) {
            if (!(object instanceof Expression)) {
                typeHints.forEach(builder -> builder.append(object));
                continue;
            }
            StringBuilder[] current = typeHints.toArray(new StringBuilder[0]);
            for (ClassInfo<?> classInfo : Classes.getAllSuperClassInfos(savedHints[hintIndex])) {
                for (StringBuilder builder2 : current) {
                    String hint = builder2.toString() + "<" + classInfo.getCodeName() + ">";
                    typeHints.add(new StringBuilder(hint));
                    typeHints.remove(builder2);
                }
            }
            ++hintIndex;
        }
        return typeHints.stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public StringMode getMode() {
        return this.mode;
    }

    public VariableString setMode(StringMode mode) {
        if (this.mode == mode || this.isSimple) {
            return this;
        }
        try (BlockingLogHandler ignored = new BlockingLogHandler().start();){
            VariableString variableString = VariableString.newInstance(this.orig, mode);
            if (variableString == null) {
                assert (false) : this + "; " + (Object)((Object)mode);
                VariableString variableString2 = this;
                return variableString2;
            }
            VariableString variableString3 = variableString;
            return variableString3;
        }
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSingle(Event event) {
        return this.toString(event);
    }

    public String[] getArray(Event event) {
        return new String[]{this.toString(event)};
    }

    public String[] getAll(Event event) {
        return new String[]{this.toString(event)};
    }

    @Override
    public boolean isSingle() {
        return true;
    }

    @Override
    public boolean check(Event event, Checker<? super String> checker, boolean negated) {
        return SimpleExpression.check(this.getAll(event), checker, negated, false);
    }

    @Override
    public boolean check(Event event, Checker<? super String> checker) {
        return SimpleExpression.check(this.getAll(event), checker, false, false);
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, String.class)) {
            return this;
        }
        return ConvertedExpression.newInstance(this, to);
    }

    @Override
    public Class<? extends String> getReturnType() {
        return String.class;
    }

    @Override
    public @Nullable Class<?>[] acceptChange(Changer.ChangeMode mode) {
        return null;
    }

    @Override
    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAnd() {
        return true;
    }

    @Override
    public boolean setTime(int time) {
        return false;
    }

    @Override
    public int getTime() {
        return 0;
    }

    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public Iterator<? extends String> iterator(Event event) {
        return new SingleItemIterator<String>(this.toString(event));
    }

    @Override
    public boolean isLoopOf(String input) {
        return false;
    }

    @Override
    public Expression<?> getSource() {
        return this;
    }

    public static <T> Expression<T> setStringMode(Expression<T> expression, StringMode mode) {
        if (expression instanceof ExpressionList) {
            Expression<T>[] expressions = ((ExpressionList)expression).getExpressions();
            for (int i = 0; i < expressions.length; ++i) {
                Expression expr = expressions[i];
                assert (expr != null);
                expressions[i] = VariableString.setStringMode(expr, mode);
            }
        } else if (expression instanceof VariableString) {
            return ((VariableString)expression).setMode(mode);
        }
        return expression;
    }

    @Override
    public Expression<String> simplify() {
        return this;
    }
}

