/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.function.FunctionReference;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.converter.Converters;

public class ExprFunctionCall<T>
extends SimpleExpression<T> {
    private final FunctionReference<?> function;
    private final Class<? extends T>[] returnTypes;
    private final Class<T> returnType;

    public ExprFunctionCall(FunctionReference<T> function) {
        this(function, function.returnTypes);
    }

    public ExprFunctionCall(FunctionReference<?> function, Class<? extends T>[] expectedReturnTypes) {
        this.function = function;
        Class<?> functionReturnType = function.getReturnType();
        assert (functionReturnType != null);
        if (CollectionUtils.containsSuperclass(expectedReturnTypes, functionReturnType)) {
            this.returnTypes = new Class[]{functionReturnType};
            this.returnType = functionReturnType;
        } else {
            this.returnTypes = expectedReturnTypes;
            this.returnType = Utils.getSuperType(expectedReturnTypes);
        }
    }

    @Override
    protected @Nullable T[] get(Event e) {
        Object[] returnValue = this.function.execute(e);
        this.function.resetReturnValue();
        return Converters.convert(returnValue, this.returnTypes, this.returnType);
    }

    @Override
    public <R> @Nullable Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        if (CollectionUtils.containsSuperclass(to, this.getReturnType())) {
            return this;
        }
        assert (this.function.getReturnType() != null);
        if (Converters.converterExists(this.function.getReturnType(), to)) {
            return new ExprFunctionCall<R>(this.function, to);
        }
        return null;
    }

    @Override
    public boolean isSingle() {
        return this.function.isSingle();
    }

    @Override
    public Class<? extends T> getReturnType() {
        return this.returnType;
    }

    @Override
    public String toString(@Nullable Event e, boolean debug) {
        return this.function.toString(e, debug);
    }

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        assert (false);
        return false;
    }
}

