/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.function;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.skript.util.Utils;
import ch.njol.util.NonNullPair;
import ch.njol.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public final class Parameter<T> {
    public static final Pattern PARAM_PATTERN = Pattern.compile("\\s*(.+?)\\s*:(?=[^:]*$)\\s*(.+?)(?:\\s*=\\s*(.+))?\\s*");
    final String name;
    final ClassInfo<T> type;
    final @Nullable Expression<? extends T> def;
    final boolean single;

    public Parameter(String name, ClassInfo<T> type, boolean single, @Nullable Expression<? extends T> def) {
        this.name = name != null ? name.toLowerCase(Locale.ENGLISH) : null;
        this.type = type;
        this.def = def;
        this.single = single;
    }

    public ClassInfo<T> getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> @Nullable Parameter<T> newInstance(String name, ClassInfo<T> type, boolean single, @Nullable String def) {
        if (!Variable.isValidVariableName(name, true, false)) {
            Skript.error("A parameter's name must be a valid variable name.");
            return null;
        }
        Expression d = null;
        if (def != null) {
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                d = new SkriptParser(def, 3, ParseContext.DEFAULT).parseExpression(type.getC());
                if (d == null || LiteralUtils.hasUnparsedLiteral(d)) {
                    log.printErrors("Can't understand this expression: " + def);
                    Parameter<T> parameter = null;
                    return parameter;
                }
                log.printLog();
            }
            finally {
                log.stop();
            }
        }
        return new Parameter<T>(name, type, single, d);
    }

    public static @Nullable List<Parameter<?>> parse(String args) {
        ArrayList params = new ArrayList();
        int j = 0;
        int i = 0;
        while (i <= args.length()) {
            if (i == -1) {
                Skript.error("Invalid text/variables/parentheses in the arguments of this function");
                return null;
            }
            if (i == args.length() || args.charAt(i) == ',') {
                String arg = args.substring(j, i);
                if (args.isEmpty()) break;
                Matcher n = PARAM_PATTERN.matcher(arg);
                if (!n.matches()) {
                    Skript.error("The " + StringUtils.fancyOrderNumber(params.size() + 1) + " argument's definition is invalid. It should look like 'name: type' or 'name: type = default value'.");
                    return null;
                }
                String paramName = "" + n.group(1);
                for (Parameter parameter : params) {
                    if (!parameter.name.toLowerCase(Locale.ENGLISH).equals(paramName.toLowerCase(Locale.ENGLISH))) continue;
                    Skript.error("Each argument's name must be unique, but the name '" + paramName + "' occurs at least twice.");
                    return null;
                }
                ClassInfo<?> c = Classes.getClassInfoFromUserInput("" + n.group(2));
                NonNullPair<String, Boolean> nonNullPair = Utils.getEnglishPlural("" + n.group(2));
                if (c == null) {
                    c = Classes.getClassInfoFromUserInput(nonNullPair.getFirst());
                }
                if (c == null) {
                    Skript.error("Cannot recognise the type '" + n.group(2) + "'");
                    return null;
                }
                String rParamName = paramName.endsWith("*") ? paramName.substring(0, paramName.length() - 3) + (nonNullPair.getSecond() == false ? "::1" : "") : paramName;
                Parameter<?> p = Parameter.newInstance(rParamName, c, nonNullPair.getSecond() == false, n.group(3));
                if (p == null) {
                    return null;
                }
                params.add(p);
                j = i + 1;
            }
            if (i == args.length()) break;
            i = SkriptParser.next(args, i, ParseContext.DEFAULT);
        }
        return params;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable Expression<? extends T> getDefaultExpression() {
        return this.def;
    }

    public boolean isSingleValue() {
        return this.single;
    }

    public String toString() {
        return this.name + ": " + Utils.toEnglishPlural(this.type.getCodeName(), !this.single) + (this.def != null ? " = " + this.def.toString(null, true) : "");
    }
}

