/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.lang.parser;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.log.HandlerList;
import ch.njol.skript.structures.StructOptions;
import ch.njol.util.Kleenean;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.skriptlang.skript.lang.script.Script;
import org.skriptlang.skript.lang.script.ScriptEvent;
import org.skriptlang.skript.lang.structure.Structure;

public final class ParserInstance {
    private static final ThreadLocal<ParserInstance> PARSER_INSTANCES = ThreadLocal.withInitial(ParserInstance::new);
    private boolean isActive = false;
    private @Nullable Script currentScript = null;
    private @Nullable Structure currentStructure = null;
    private @Nullable String currentEventName;
    private Class<? extends Event> @Nullable [] currentEvents = null;
    private List<TriggerSection> currentSections = new ArrayList<TriggerSection>();
    private Kleenean hasDelayBefore = Kleenean.FALSE;
    private final HandlerList handlers = new HandlerList();
    private @Nullable Node node;
    private String indentation = "";
    private static final Map<Class<? extends Data>, Function<ParserInstance, ? extends Data>> dataRegister = new HashMap<Class<? extends Data>, Function<ParserInstance, ? extends Data>>();
    private final Map<Class<? extends Data>, Data> dataMap = new HashMap<Class<? extends Data>, Data>();

    public static ParserInstance get() {
        return PARSER_INSTANCES.get();
    }

    public void setInactive() {
        this.isActive = false;
        this.setCurrentScript((Script)null);
        this.setCurrentStructure(null);
        this.deleteCurrentEvent();
        this.getCurrentSections().clear();
        this.setNode(null);
    }

    public void setActive(Script script) {
        this.isActive = true;
        this.setCurrentScript(script);
        this.setNode(null);
    }

    public boolean isActive() {
        return this.isActive;
    }

    private void setCurrentScript(@Nullable Script currentScript) {
        if (currentScript == this.currentScript) {
            return;
        }
        Script previous = this.currentScript;
        this.currentScript = currentScript;
        this.getDataInstances().forEach(data -> data.onCurrentScriptChange(currentScript != null ? currentScript.getConfig() : null));
        if (previous != null) {
            previous.getEvents(ScriptEvent.ScriptInactiveEvent.class).forEach(eventHandler -> eventHandler.onInactive(currentScript));
        }
        if (currentScript != null) {
            currentScript.getEvents(ScriptEvent.ScriptActiveEvent.class).forEach(eventHandler -> eventHandler.onActive(previous));
        }
    }

    public Script getCurrentScript() {
        if (this.currentScript == null) {
            throw new SkriptAPIException("This ParserInstance is not currently parsing/loading something!");
        }
        return this.currentScript;
    }

    public void setCurrentStructure(@Nullable Structure structure) {
        this.currentStructure = structure;
    }

    public @Nullable Structure getCurrentStructure() {
        return this.currentStructure;
    }

    public boolean isCurrentStructure(Class<? extends Structure> structureClass) {
        return structureClass.isInstance(this.currentStructure);
    }

    @SafeVarargs
    public final boolean isCurrentStructure(Class<? extends Structure> ... structureClasses) {
        for (Class<? extends Structure> structureClass : structureClasses) {
            if (!this.isCurrentStructure(structureClass)) continue;
            return true;
        }
        return false;
    }

    public void setCurrentEventName(@Nullable String currentEventName) {
        this.currentEventName = currentEventName;
    }

    public @Nullable String getCurrentEventName() {
        return this.currentEventName;
    }

    public void setCurrentEvents(Class<? extends Event> @Nullable [] currentEvents) {
        this.currentEvents = currentEvents;
        this.getDataInstances().forEach(data -> data.onCurrentEventsChange(currentEvents));
    }

    @SafeVarargs
    public final void setCurrentEvent(String name, Class<? extends Event> ... events) {
        this.currentEventName = name;
        this.setCurrentEvents(events);
        this.setHasDelayBefore(Kleenean.FALSE);
    }

    public void deleteCurrentEvent() {
        this.currentEventName = null;
        this.setCurrentEvents(null);
        this.setHasDelayBefore(Kleenean.FALSE);
    }

    public Class<? extends Event> @Nullable [] getCurrentEvents() {
        return this.currentEvents;
    }

    public boolean isCurrentEvent(Class<? extends Event> event) {
        for (Class<? extends Event> currentEvent : this.currentEvents) {
            if (!event.isAssignableFrom(currentEvent)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isCurrentEvent(Class<? extends Event> ... events) {
        for (Class<? extends Event> event : events) {
            if (!this.isCurrentEvent(event)) continue;
            return true;
        }
        return false;
    }

    public void setCurrentSections(List<TriggerSection> currentSections) {
        this.currentSections = currentSections;
    }

    public List<TriggerSection> getCurrentSections() {
        return this.currentSections;
    }

    public <T extends TriggerSection> @Nullable T getCurrentSection(Class<T> sectionClass) {
        int i = this.currentSections.size();
        while (i-- > 0) {
            TriggerSection triggerSection = this.currentSections.get(i);
            if (!sectionClass.isInstance(triggerSection)) continue;
            return (T)triggerSection;
        }
        return null;
    }

    @NotNull
    public <T extends TriggerSection> List<T> getCurrentSections(Class<T> sectionClass) {
        ArrayList<TriggerSection> list = new ArrayList<TriggerSection>();
        for (TriggerSection triggerSection : this.currentSections) {
            if (!sectionClass.isInstance(triggerSection)) continue;
            list.add(triggerSection);
        }
        return list;
    }

    public boolean isCurrentSection(Class<? extends TriggerSection> sectionClass) {
        for (TriggerSection triggerSection : this.currentSections) {
            if (!sectionClass.isInstance(triggerSection)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isCurrentSection(Class<? extends TriggerSection> ... sectionClasses) {
        for (Class<? extends TriggerSection> sectionClass : sectionClasses) {
            if (!this.isCurrentSection(sectionClass)) continue;
            return true;
        }
        return false;
    }

    public void setHasDelayBefore(Kleenean hasDelayBefore) {
        this.hasDelayBefore = hasDelayBefore;
    }

    public Kleenean getHasDelayBefore() {
        return this.hasDelayBefore;
    }

    public HandlerList getHandlers() {
        return this.handlers;
    }

    public void setNode(@Nullable Node node) {
        this.node = node == null || node.getParent() == null ? null : node;
    }

    public @Nullable Node getNode() {
        return this.node;
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation;
    }

    public String getIndentation() {
        return this.indentation;
    }

    public static <T extends Data> void registerData(Class<T> dataClass, Function<ParserInstance, T> dataFunction) {
        dataRegister.put(dataClass, dataFunction);
    }

    public static boolean isRegistered(Class<? extends Data> dataClass) {
        return dataRegister.containsKey(dataClass);
    }

    public <T extends Data> T getData(Class<T> dataClass) {
        if (this.dataMap.containsKey(dataClass)) {
            return (T)this.dataMap.get(dataClass);
        }
        if (dataRegister.containsKey(dataClass)) {
            Data data = dataRegister.get(dataClass).apply(this);
            this.dataMap.put(dataClass, data);
            return (T)data;
        }
        assert (false);
        return null;
    }

    private List<? extends Data> getDataInstances() {
        ArrayList<Data> dataList = new ArrayList<Data>();
        for (Class<? extends Data> dataClass : dataRegister.keySet()) {
            Data data = this.getData(dataClass);
            if (data == null) continue;
            dataList.add(data);
        }
        return dataList;
    }

    @Deprecated
    public HashMap<String, String> getCurrentOptions() {
        if (!this.isActive()) {
            return new HashMap<String, String>(0);
        }
        StructOptions.OptionsData data = this.getCurrentScript().getData(StructOptions.OptionsData.class);
        if (data == null) {
            return new HashMap<String, String>(0);
        }
        return new HashMap<String, String>(data.getOptions());
    }

    @Deprecated
    public @Nullable SkriptEvent getCurrentSkriptEvent() {
        Structure structure = this.getCurrentStructure();
        if (structure instanceof SkriptEvent) {
            return (SkriptEvent)structure;
        }
        return null;
    }

    @Deprecated
    public void setCurrentSkriptEvent(@Nullable SkriptEvent currentSkriptEvent) {
        this.setCurrentStructure(currentSkriptEvent);
    }

    @Deprecated
    public void deleteCurrentSkriptEvent() {
        this.setCurrentStructure(null);
    }

    @Deprecated
    public void setCurrentScript(@Nullable Config currentScript) {
        if (currentScript == null) {
            return;
        }
        File file = currentScript.getFile();
        if (file == null) {
            return;
        }
        Script script = ScriptLoader.getScript(file);
        if (script != null) {
            this.setActive(script);
        }
    }

    public static abstract class Data {
        private final ParserInstance parserInstance;

        public Data(ParserInstance parserInstance) {
            this.parserInstance = parserInstance;
        }

        protected final ParserInstance getParser() {
            return this.parserInstance;
        }

        @Deprecated
        public void onCurrentScriptChange(@Nullable Config currentScript) {
        }

        public void onCurrentEventsChange(Class<? extends Event> @Nullable [] currentEvents) {
        }
    }
}

