/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.registrations;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Getter;
import ch.njol.util.Kleenean;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.converter.Converter;
import org.skriptlang.skript.lang.converter.Converters;

public class EventValues {
    private static final List<EventValueInfo<?, ?>> defaultEventValues = new ArrayList(30);
    private static final List<EventValueInfo<?, ?>> futureEventValues = new ArrayList();
    private static final List<EventValueInfo<?, ?>> pastEventValues = new ArrayList();
    public static final int TIME_PAST = -1;
    public static final int TIME_NOW = 0;
    public static final int TIME_FUTURE = 1;

    private EventValues() {
    }

    public static List<EventValueInfo<?, ?>> getEventValuesListForTime(int time) {
        return ImmutableList.copyOf(EventValues.getEventValuesList(time));
    }

    private static List<EventValueInfo<?, ?>> getEventValuesList(int time) {
        if (time == -1) {
            return pastEventValues;
        }
        if (time == 0) {
            return defaultEventValues;
        }
        if (time == 1) {
            return futureEventValues;
        }
        throw new IllegalArgumentException("time must be -1, 0, or 1");
    }

    public static <T, E extends Event> void registerEventValue(Class<E> event, Class<T> type, Getter<T, E> getter, int time) {
        EventValues.registerEventValue(event, type, getter, time, null, null);
    }

    @SafeVarargs
    public static <T, E extends Event> void registerEventValue(Class<E> event, Class<T> type, Getter<T, E> getter, int time, @Nullable String excludeErrorMessage, Class<? extends E> ... excludes) {
        Skript.checkAcceptRegistrations();
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (int i = 0; i < eventValues.size(); ++i) {
            EventValueInfo<?, ?> info = eventValues.get(i);
            if (info.event.equals(event) && info.c.equals(type)) {
                return;
            }
            if (!(!info.event.equals(event) ? info.event.isAssignableFrom(event) : info.c.isAssignableFrom(type))) continue;
            eventValues.add(i, new EventValueInfo<E, T>(event, type, getter, excludeErrorMessage, excludes));
            return;
        }
        eventValues.add(new EventValueInfo<E, T>(event, type, getter, excludeErrorMessage, excludes));
    }

    public static <T, E extends Event> @Nullable T getEventValue(E e, Class<T> c, int time) {
        Getter<T, ?> getter = EventValues.getEventValueGetter(e.getClass(), c, time);
        if (getter == null) {
            return null;
        }
        return getter.get(e);
    }

    public static <T, E extends Event> @Nullable Getter<? extends T, ? super E> getExactEventValueGetter(Class<E> event, Class<T> c, int time) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        for (EventValueInfo<?, ?> eventValueInfo : eventValues) {
            if (!c.equals(eventValueInfo.c)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, event)) {
                return null;
            }
            if (!eventValueInfo.event.isAssignableFrom(event)) continue;
            return eventValueInfo.getter;
        }
        return null;
    }

    public static <T, E extends Event> Kleenean hasMultipleGetters(Class<E> event, Class<T> type, int time) {
        List<Getter<T, E>> getters = EventValues.getEventValueGetters(event, type, time, true, false);
        if (getters == null) {
            return Kleenean.UNKNOWN;
        }
        return Kleenean.get(getters.size() > 1);
    }

    public static <T, E extends Event> @Nullable Getter<? extends T, ? super E> getEventValueGetter(Class<E> event, Class<T> type, int time) {
        return EventValues.getEventValueGetter(event, type, time, true);
    }

    private static <T, E extends Event> @Nullable Getter<? extends T, ? super E> getEventValueGetter(Class<E> event, Class<T> type, int time, boolean allowDefault) {
        List<Getter<T, E>> list = EventValues.getEventValueGetters(event, type, time, allowDefault);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static <T, E extends Event> @Nullable List<Getter<? extends T, ? super E>> getEventValueGetters(Class<E> event, Class<T> type, int time, boolean allowDefault) {
        return EventValues.getEventValueGetters(event, type, time, allowDefault, true);
    }

    private static <T, E extends Event> @Nullable List<Getter<? extends T, ? super E>> getEventValueGetters(Class<E> event, final Class<T> type, int time, boolean allowDefault, boolean allowConverting) {
        List<EventValueInfo<?, ?>> eventValues = EventValues.getEventValuesList(time);
        ArrayList list = new ArrayList();
        Getter<T, E> exact = EventValues.getExactEventValueGetter(event, type, time);
        if (exact != null) {
            list.add(exact);
            return list;
        }
        for (final EventValueInfo<?, ?> eventValueInfo : eventValues) {
            if (!type.isAssignableFrom(eventValueInfo.c)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, event)) {
                return null;
            }
            if (eventValueInfo.event.isAssignableFrom(event)) {
                list.add(eventValueInfo.getter);
                continue;
            }
            if (!event.isAssignableFrom(eventValueInfo.event)) continue;
            list.add(new Getter<T, E>(){

                @Override
                public @Nullable T get(E event) {
                    if (!eventValueInfo.event.isInstance(event)) {
                        return null;
                    }
                    return eventValueInfo.getter.get(event);
                }
            });
        }
        if (!list.isEmpty()) {
            return list;
        }
        if (!allowConverting) {
            return null;
        }
        for (final EventValueInfo<?, ?> eventValueInfo : eventValues) {
            boolean checkInstanceOf;
            if (!eventValueInfo.c.isAssignableFrom(type)) continue;
            boolean bl = checkInstanceOf = !eventValueInfo.event.isAssignableFrom(event);
            if (checkInstanceOf && !event.isAssignableFrom(eventValueInfo.event)) continue;
            if (!EventValues.checkExcludes(eventValueInfo, event)) {
                return null;
            }
            list.add(new Getter<T, E>(){

                @Override
                public @Nullable T get(E event) {
                    if (checkInstanceOf && !eventValueInfo.event.isInstance(event)) {
                        return null;
                    }
                    Object object = eventValueInfo.getter.get(event);
                    if (type.isInstance(object)) {
                        return object;
                    }
                    return null;
                }
            });
        }
        if (!list.isEmpty()) {
            return list;
        }
        for (final EventValueInfo<?, ?> eventValueInfo : eventValues) {
            Getter<T, ?> getter;
            if (!event.equals(eventValueInfo.event) || (getter = EventValues.getConvertedGetter(eventValueInfo, type, false)) == null) continue;
            if (!EventValues.checkExcludes(eventValueInfo, event)) {
                return null;
            }
            list.add(getter);
        }
        if (!list.isEmpty()) {
            return list;
        }
        for (final EventValueInfo<?, ?> eventValueInfo : eventValues) {
            Getter<T, ?> getter;
            if (!event.isAssignableFrom(eventValueInfo.event) || (getter = EventValues.getConvertedGetter(eventValueInfo, type, true)) == null) continue;
            if (!EventValues.checkExcludes(eventValueInfo, event)) {
                return null;
            }
            list.add(getter);
        }
        if (!list.isEmpty()) {
            return list;
        }
        if (allowDefault && time != 0) {
            return EventValues.getEventValueGetters(event, type, 0, false);
        }
        return null;
    }

    private static boolean checkExcludes(EventValueInfo<?, ?> info, Class<? extends Event> event) {
        if (info.excludes == null) {
            return true;
        }
        for (Class clazz : info.excludes) {
            if (!clazz.isAssignableFrom(event)) continue;
            Skript.error(info.excludeErrorMessage);
            return false;
        }
        return true;
    }

    private static <E extends Event, F, T> @Nullable Getter<? extends T, ? super E> getConvertedGetter(final EventValueInfo<E, F> info, Class<T> to, final boolean checkInstanceOf) {
        final Converter converter = Converters.getConverter(info.c, to);
        if (converter == null) {
            return null;
        }
        return new Getter<T, E>(){

            @Override
            public @Nullable T get(E e) {
                if (checkInstanceOf && !info.event.isInstance(e)) {
                    return null;
                }
                Object f = info.getter.get(e);
                if (f == null) {
                    return null;
                }
                return converter.convert(f);
            }
        };
    }

    public static boolean doesExactEventValueHaveTimeStates(Class<? extends Event> event, Class<?> c) {
        return EventValues.getExactEventValueGetter(event, c, -1) != null || EventValues.getExactEventValueGetter(event, c, 1) != null;
    }

    public static boolean doesEventValueHaveTimeStates(Class<? extends Event> event, Class<?> c) {
        return EventValues.getEventValueGetter(event, c, -1, false) != null || EventValues.getEventValueGetter(event, c, 1, false) != null;
    }

    private static final class EventValueInfo<E extends Event, T> {
        public final Class<E> event;
        public final Class<T> c;
        public final Getter<T, E> getter;
        public final @Nullable Class<? extends E>[] excludes;
        public final @Nullable String excludeErrorMessage;

        public EventValueInfo(Class<E> event, Class<T> c, Getter<T, E> getter, @Nullable String excludeErrorMessage, @Nullable Class<? extends E>[] excludes) {
            assert (event != null);
            assert (c != null);
            assert (getter != null);
            this.event = event;
            this.c = c;
            this.getter = getter;
            this.excludes = excludes;
            this.excludeErrorMessage = excludeErrorMessage;
        }

        public Class<E> getEventClass() {
            return this.event;
        }

        public Class<T> getValueClass() {
            return this.c;
        }

        public @Nullable Class<? extends E>[] getExcludes() {
            if (this.excludes != null) {
                return Arrays.copyOf(this.excludes, this.excludes.length);
            }
            return new Class[0];
        }

        public @Nullable String getExcludeErrorMessage() {
            return this.excludeErrorMessage;
        }
    }
}

