/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.util.ContainerExpression;
import ch.njol.skript.util.Container;
import ch.njol.skript.util.LiteralUtils;
import ch.njol.util.Kleenean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Loop")
@Description(value={"Loop sections repeat their code with multiple values.", "", "A loop will loop through all elements of the given expression, e.g. all players, worlds, items, etc. The conditions & effects inside the loop will be executed for every of those elements, which can be accessed with \u2018loop-<what>\u2019, e.g. <code>send \"hello\" to loop-player</code>. When a condition inside a loop is not fulfilled the loop will start over with the next element of the loop. You can however use <code>stop loop</code> to exit the loop completely and resume code execution after the end of the loop.", "", "<b>Loopable Values</b>", "All <a href=\"/expressions.html\">expressions</a> that represent more than one value, e.g. \u2018all players\u2019, \u2018worlds\u2019, etc., as well as list variables, can be looped. You can also use a list of expressions, e.g. <code>loop the victim and the attacker</code>, to execute the same code for only a few values.", "", "<b>List Variables</b>", "When looping list variables, you can also use <code>loop-index</code> in addition to <code>loop-value</code> inside the loop. <code>loop-value</code> is the value of the currently looped variable, and <code>loop-index</code> is the last part of the variable's name (the part where the list variable has its asterisk *)."})
@Examples(value={"loop all players:", "\tsend \"Hello %loop-player%!\" to loop-player", "", "loop items in player's inventory:", "\tif loop-item is dirt:", "\t\tset loop-item to air", "", "loop 10 times:", "\tsend title \"%11 - loop-value%\" and subtitle \"seconds left until the game begins\" to player for 1 second # 10, 9, 8 etc.", "\twait 1 second", "", "loop {Coins::*}:", "\tset {Coins::%loop-index%} to loop-value + 5 # Same as \"add 5 to {Coins::%loop-index%}\" where loop-index is the uuid of the player and loop-value is the actually coins value such as 200"})
@Since(value="1.0")
public class SecLoop
extends LoopSection {
    private Expression<?> expr;
    private final transient Map<Event, Object> current = new WeakHashMap<Event, Object>();
    private final transient Map<Event, Iterator<?>> currentIter = new WeakHashMap();
    private @Nullable TriggerItem actualNext;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        this.expr = LiteralUtils.defendExpression(exprs[0]);
        if (!LiteralUtils.canInitSafely(this.expr)) {
            Skript.error("Can't understand this loop: '" + parseResult.expr.substring(5) + "'");
            return false;
        }
        if (Container.class.isAssignableFrom(this.expr.getReturnType())) {
            Container.ContainerType type = this.expr.getReturnType().getAnnotation(Container.ContainerType.class);
            if (type == null) {
                throw new SkriptAPIException(this.expr.getReturnType().getName() + " implements Container but is missing the required @ContainerType annotation");
            }
            this.expr = new ContainerExpression(this.expr, type.value());
        }
        if (this.expr.isSingle()) {
            Skript.error("Can't loop '" + this.expr + "' because it's only a single value");
            return false;
        }
        this.loadOptionalCode(sectionNode);
        super.setNext(this);
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event event) {
        Iterator<?> iter = this.currentIter.get(event);
        if (iter == null) {
            Iterator<Object> iterator = iter = this.expr instanceof Variable ? ((Variable)this.expr).variablesIterator(event) : this.expr.iterator(event);
            if (iter != null) {
                if (iter.hasNext()) {
                    this.currentIter.put(event, iter);
                } else {
                    iter = null;
                }
            }
        }
        if (iter == null || !iter.hasNext()) {
            this.exit(event);
            this.debug(event, false);
            return this.actualNext;
        }
        this.current.put(event, iter.next());
        this.currentLoopCounter.put(event, this.currentLoopCounter.getOrDefault(event, 0L) + 1L);
        return this.walk(event, true);
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "loop " + this.expr.toString(event, debug);
    }

    public @Nullable Object getCurrent(Event event) {
        return this.current.get(event);
    }

    public Expression<?> getLoopedExpression() {
        return this.expr;
    }

    @Override
    public SecLoop setNext(@Nullable TriggerItem next) {
        this.actualNext = next;
        return this;
    }

    @Override
    public @Nullable TriggerItem getActualNext() {
        return this.actualNext;
    }

    @Override
    public void exit(Event event) {
        this.current.remove(event);
        this.currentIter.remove(event);
        super.exit(event);
    }

    static {
        Skript.registerSection(SecLoop.class, "loop %objects%");
    }
}

