/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.LoopSection;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.List;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="While Loop")
@Description(value={"While Loop sections are loops that will just keep repeating as long as a condition is met."})
@Examples(value={"while size of all players < 5:", "\tsend \"More players are needed to begin the adventure\" to all players", "\twait 5 seconds", "", "set {_counter} to 1", "do while {_counter} > 1: # false but will increase {_counter} by 1 then get out", "\tadd 1 to {_counter}", "", "# Be careful when using while loops with conditions that are almost ", "# always true for a long time without using 'wait %timespan%' inside it, ", "# otherwise it will probably hang and crash your server.", "while player is online:", "\tgive player 1 dirt", "\twait 1 second # without using a delay effect the server will crash"})
@Since(value="2.0, 2.6 (do while)")
public class SecWhile
extends LoopSection {
    private Condition condition;
    private @Nullable TriggerItem actualNext;
    private boolean doWhile;
    private boolean ranDoWhile = false;

    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        String expr = parseResult.regexes.get(0).group();
        this.condition = Condition.parse(expr, "Can't understand this condition: " + expr);
        if (this.condition == null) {
            return false;
        }
        this.doWhile = parseResult.hasTag("do");
        this.loadOptionalCode(sectionNode);
        super.setNext(this);
        return true;
    }

    @Override
    protected @Nullable TriggerItem walk(Event event) {
        if (this.doWhile && !this.ranDoWhile || this.condition.check(event)) {
            this.ranDoWhile = true;
            this.currentLoopCounter.put(event, this.currentLoopCounter.getOrDefault(event, 0L) + 1L);
            return this.walk(event, true);
        }
        this.exit(event);
        this.debug(event, false);
        return this.actualNext;
    }

    @Override
    public SecWhile setNext(@Nullable TriggerItem next) {
        this.actualNext = next;
        return this;
    }

    @Override
    public @Nullable TriggerItem getActualNext() {
        return this.actualNext;
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return (this.doWhile ? "do " : "") + "while " + this.condition.toString(event, debug);
    }

    @Override
    public void exit(Event event) {
        this.ranDoWhile = false;
        super.exit(event);
    }

    static {
        Skript.registerSection(SecWhile.class, "[(:do)] while <.+>");
    }
}

