/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.test.platform;

import ch.njol.skript.test.utils.TestResults;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jdt.annotation.Nullable;

public class Environment {
    private static final Gson gson = new Gson();
    private final String name;
    private final List<Resource> resources;
    private final @Nullable List<Resource> downloads;
    private final @Nullable List<PaperResource> paperDownloads;
    private final String skriptTarget;
    private final String[] commandLine;

    public Environment(String name, List<Resource> resources, @Nullable List<Resource> downloads, @Nullable List<PaperResource> paperDownloads, String skriptTarget, String ... commandLine) {
        this.name = name;
        this.resources = resources;
        this.downloads = downloads;
        this.paperDownloads = paperDownloads;
        this.skriptTarget = skriptTarget;
        this.commandLine = commandLine;
    }

    public String getName() {
        return this.name;
    }

    public void initialize(Path dataRoot, Path runnerRoot, boolean remake) throws IOException {
        Path env = runnerRoot.resolve(this.name);
        boolean onlyCopySkript = Files.exists(env, new LinkOption[0]) && !remake;
        Path skript = env.resolve(this.skriptTarget);
        Files.createDirectories(skript.getParent(), new FileAttribute[0]);
        try {
            Files.copy(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toPath(), skript, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (onlyCopySkript) {
            return;
        }
        for (Resource resource : this.resources) {
            Path source = dataRoot.resolve(resource.getSource());
            Path target = env.resolve(resource.getTarget());
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        ArrayList<Resource> downloads = new ArrayList<Resource>();
        if (this.downloads != null) {
            downloads.addAll(this.downloads);
        }
        if (this.paperDownloads != null) {
            downloads.addAll(this.paperDownloads);
        }
        for (Resource resource : downloads) {
            assert (resource != null);
            String source = resource.getSource();
            URL url = new URL(source);
            Path target = env.resolve(resource.getTarget());
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            InputStream is = url.openStream();
            try {
                Files.copy(is, target, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    public @Nullable TestResults runTests(Path runnerRoot, Path testsRoot, boolean devMode, boolean genDocs, boolean jUnit, boolean debug, String verbosity, long timeout, Set<String> jvmArgs) throws IOException, InterruptedException {
        int code;
        Path env = runnerRoot.resolve(this.name);
        Path resultsPath = env.resolve("test_results.json");
        Files.deleteIfExists(resultsPath);
        ArrayList<String> args = new ArrayList<String>();
        args.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        args.add("-ea");
        args.add("-Dskript.testing.enabled=true");
        args.add("-Dskript.testing.dir=" + testsRoot);
        args.add("-Dskript.testing.devMode=" + devMode);
        args.add("-Dskript.testing.genDocs=" + genDocs);
        args.add("-Dskript.testing.junit=" + jUnit);
        if (!verbosity.equalsIgnoreCase("null")) {
            args.add("-Dskript.testing.verbosity=" + verbosity);
        }
        if (genDocs) {
            args.add("-Dskript.forceregisterhooks=true");
        }
        args.add("-Dskript.testing.results=test_results.json");
        args.add("-Ddisable.watchdog=true");
        if (debug) {
            args.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=8000");
        }
        args.addAll(jvmArgs);
        args.addAll(Arrays.asList(this.commandLine));
        final Process process = new ProcessBuilder(args).directory(env.toFile()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).redirectInput(ProcessBuilder.Redirect.INHERIT).start();
        Runtime.getRuntime().addShutdownHook(new Thread(process::destroy));
        if (!devMode && timeout > 0L) {
            new Timer("runner watchdog", true).schedule(new TimerTask(){

                @Override
                public void run() {
                    if (process.isAlive()) {
                        System.err.println("Test environment is taking too long, failing...");
                        System.exit(1);
                    }
                }
            }, timeout);
        }
        if ((code = process.waitFor()) != 0) {
            throw new IOException("environment returned with code " + code);
        }
        if (!Files.exists(resultsPath, new LinkOption[0])) {
            return null;
        }
        TestResults results = (TestResults)new Gson().fromJson(new String(Files.readAllBytes(resultsPath)), TestResults.class);
        assert (results != null);
        return results;
    }

    public static class Resource {
        private final String source;
        private final String target;

        public Resource(String url, String target) {
            this.source = url;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class PaperResource
    extends Resource {
        private final String version;
        private transient @Nullable String source;

        public PaperResource(String version, String target) {
            super(null, target);
            this.version = version;
        }

        @Override
        public String getSource() {
            try {
                this.generateSource();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (this.source == null) {
                throw new IllegalStateException();
            }
            return this.source;
        }

        private void generateSource() throws IOException {
            JsonObject jsonObject;
            if (this.source != null) {
                return;
            }
            String stringUrl = "https://api.papermc.io/v2/projects/paper/versions/" + this.version;
            URL url = new URL(stringUrl);
            try (InputStream is = url.openStream();){
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            }
            JsonArray jsonArray = jsonObject.get("builds").getAsJsonArray();
            int latestBuild = -1;
            for (JsonElement jsonElement : jsonArray) {
                int build = jsonElement.getAsInt();
                if (build <= latestBuild) continue;
                latestBuild = build;
            }
            if (latestBuild == -1) {
                throw new IllegalStateException("No builds for this version");
            }
            this.source = "https://api.papermc.io/v2/projects/paper/versions/" + this.version + "/builds/" + latestBuild + "/downloads/paper-" + this.version + "-" + latestBuild + ".jar";
        }
    }
}

