/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.test.runner;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.NoDoc;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.log.ParseLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.test.runner.SkriptJUnitTest;
import ch.njol.skript.test.runner.TestMode;
import ch.njol.skript.test.runner.TestTracker;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.script.Script;

@Name(value="Assert")
@Description(value={"Assert that condition is true. Test fails when it is not."})
@NoDoc
public class EffAssert
extends Effect {
    private @Nullable Condition condition;
    private Script script;
    private Expression<String> errorMsg;
    private boolean shouldFail;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        String conditionString = parseResult.regexes.get(0).group();
        this.errorMsg = exprs[0];
        this.shouldFail = parseResult.mark != 0;
        this.script = this.getParser().getCurrentScript();
        ParseLogHandler logHandler = SkriptLogger.startParseLogHandler();
        try {
            this.condition = Condition.parse(conditionString, "Can't understand this condition: " + conditionString);
            if (this.shouldFail) {
                boolean bl = true;
                return bl;
            }
            if (this.condition == null) {
                logHandler.printError();
            } else {
                logHandler.printLog();
            }
        }
        finally {
            logHandler.stop();
        }
        return this.condition != null;
    }

    @Override
    protected void execute(Event event) {
    }

    @Override
    public @Nullable TriggerItem walk(Event event) {
        if (this.shouldFail && this.condition == null) {
            return this.getNext();
        }
        if (this.condition.check(event) == this.shouldFail) {
            String message = this.errorMsg.getSingle(event);
            if (!$assertionsDisabled && message == null) {
                throw new AssertionError();
            }
            if (SkriptJUnitTest.getCurrentJUnitTest() != null) {
                TestTracker.junitTestFailed(SkriptJUnitTest.getCurrentJUnitTest(), message);
            } else {
                TestTracker.testFailed(message, this.script);
            }
            return null;
        }
        return this.getNext();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        if (this.condition == null) {
            return "assertion";
        }
        return "assert " + this.condition.toString(event, debug);
    }

    static {
        boolean bl = $assertionsDisabled = !EffAssert.class.desiredAssertionStatus();
        if (TestMode.ENABLED) {
            Skript.registerEffect(EffAssert.class, "assert <.+> [(1\u00a6to fail)] with %string%");
        }
    }
}

