/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.util.Color;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Math2;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.DyeColor;
import org.eclipse.jdt.annotation.Nullable;

public class ColorRGB
implements Color {
    private static final Pattern RGB_PATTERN = Pattern.compile("(?>rgb|RGB) (\\d+), (\\d+), (\\d+)");
    private org.bukkit.Color bukkit;
    private @Nullable DyeColor dye;

    public ColorRGB(int red, int green, int blue) {
        this.bukkit = org.bukkit.Color.fromRGB((int)Math2.fit(0, red, 255), (int)Math2.fit(0, green, 255), (int)Math2.fit(0, blue, 255));
        this.dye = DyeColor.getByColor((org.bukkit.Color)this.bukkit);
    }

    @Override
    public org.bukkit.Color asBukkitColor() {
        return this.bukkit;
    }

    @Override
    public @Nullable DyeColor asDyeColor() {
        return this.dye;
    }

    @Override
    public String getName() {
        return "rgb " + this.bukkit.getRed() + ", " + this.bukkit.getGreen() + ", " + this.bukkit.getBlue();
    }

    public static @Nullable ColorRGB fromString(String string) {
        Matcher matcher = RGB_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return new ColorRGB(NumberUtils.toInt((String)matcher.group(1)), NumberUtils.toInt((String)matcher.group(2)), NumberUtils.toInt((String)matcher.group(3)));
    }

    @Override
    public Fields serialize() throws NotSerializableException {
        return new Fields(this, Variables.yggdrasil);
    }

    @Override
    public void deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
        org.bukkit.Color b = fields.getObject("bukkit", org.bukkit.Color.class);
        DyeColor d = fields.getObject("dye", DyeColor.class);
        if (b == null) {
            return;
        }
        this.dye = d == null ? DyeColor.getByColor((org.bukkit.Color)b) : d;
        this.bukkit = b;
    }
}

