/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.skriptlang.skript.lang.converter.Converter;

public abstract class FileUtils {
    private static boolean RUNNINGJAVA6 = true;
    private static final SimpleDateFormat backupFormat;

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBackupSuffix() {
        SimpleDateFormat simpleDateFormat = backupFormat;
        synchronized (simpleDateFormat) {
            return "" + backupFormat.format(System.currentTimeMillis());
        }
    }

    public static File backup(File f) throws IOException {
        File backupFolder;
        String ext;
        String name = f.getName();
        int c = name.lastIndexOf(46);
        String string = ext = c == -1 ? null : name.substring(c + 1);
        if (c != -1) {
            name = name.substring(0, c);
        }
        if (!(backupFolder = new File(f.getParentFile(), "backups" + File.separator)).exists() && !backupFolder.mkdirs()) {
            throw new IOException("Cannot create backups folder");
        }
        File backup = new File(backupFolder, name + "_" + FileUtils.getBackupSuffix() + (ext == null ? "" : "." + ext));
        if (backup.exists()) {
            throw new IOException("Backup file " + backup.getName() + " does already exist");
        }
        FileUtils.copy(f, backup);
        return backup;
    }

    public static File move(File from, File to, boolean replace) throws IOException {
        if (!replace && to.exists()) {
            throw new IOException("Can't rename " + from.getName() + " to " + to.getName() + ": The target file already exists");
        }
        if (!RUNNINGJAVA6) {
            if (replace) {
                Files.move(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            } else {
                Files.move(from.toPath(), to.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
        } else {
            File moveTo = null;
            if (replace && to.exists()) {
                moveTo = new File(to.getAbsolutePath() + ".old0");
                int i = 0;
                while (moveTo.exists() && i < 1000) {
                    moveTo = new File(to.getAbsolutePath() + ".old" + ++i);
                }
                if (i == 999 || !to.renameTo(moveTo)) {
                    throw new IOException("Can't rename " + from.getName() + " to " + to.getName() + ": Cannot temporarily rename the target file");
                }
            }
            if (!from.renameTo(to)) {
                if (moveTo != null) {
                    moveTo.renameTo(to);
                }
                throw new IOException("Can't rename " + from.getName() + " to " + to.getName());
            }
            if (moveTo != null) {
                moveTo.delete();
            }
        }
        return to;
    }

    public static void copy(File from, File to) throws IOException {
        if (!RUNNINGJAVA6) {
            Files.copy(from.toPath(), to.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
        } else {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int bytesRead;
                in = new FileInputStream(from);
                out = new FileOutputStream(to);
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            catch (Exception e) {
                throw new IOException("Can't copy " + from.getName() + " to " + to.getName() + ": " + e.getLocalizedMessage(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static Collection<File> renameAll(File directory, Converter<String, String> renamer) throws IOException {
        ArrayList<File> changed = new ArrayList<File>();
        for (File f : directory.listFiles()) {
            String newName;
            if (f.isDirectory()) {
                changed.addAll(FileUtils.renameAll(f, renamer));
                continue;
            }
            String name = f.getName();
            if (name == null || (newName = renamer.convert(name)) == null) continue;
            File newFile = new File(f.getParent(), newName);
            FileUtils.move(f, newFile, false);
            changed.add(newFile);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(InputStream in, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream out = null;){
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = new byte[16384];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
            }
        }
    }

    static {
        try {
            new File(".").toPath();
            RUNNINGJAVA6 = false;
        }
        catch (NoSuchMethodError e) {
            RUNNINGJAVA6 = true;
        }
        catch (Exception e) {
            RUNNINGJAVA6 = false;
        }
        backupFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    }
}

