/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.util.PotionDataUtils;
import ch.njol.skript.util.Timespan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.eclipse.jdt.annotation.Nullable;

public abstract class PotionEffectUtils {
    private static final boolean HAS_SUSPICIOUS_META = Skript.classExists("org.bukkit.inventory.meta.SuspiciousStewMeta");
    static final Map<String, PotionEffectType> types = new HashMap<String, PotionEffectType>();
    static final String[] names = new String[PotionEffectUtils.getMaxPotionId() + 1];

    private PotionEffectUtils() {
    }

    private static int getMaxPotionId() {
        int i = 0;
        for (PotionEffectType t : PotionEffectType.values()) {
            if (t == null || t.getId() <= i) continue;
            i = t.getId();
        }
        return i;
    }

    public static @Nullable PotionEffectType parseType(String s) {
        return types.get(s.toLowerCase(Locale.ENGLISH));
    }

    public static @Nullable PotionEffectType parseByEffectType(PotionEffectType t) {
        for (PotionEffectType value : types.values()) {
            if (!t.equals(value)) continue;
            return value;
        }
        return null;
    }

    public static String toString(PotionEffectType t) {
        return names[t.getId()];
    }

    public static String toString(PotionEffectType t, int flags) {
        return names[t.getId()];
    }

    public static String toString(PotionEffect potionEffect) {
        StringBuilder builder = new StringBuilder();
        if (potionEffect.isAmbient()) {
            builder.append("ambient ");
        }
        builder.append("potion effect of ");
        builder.append(PotionEffectUtils.toString(potionEffect.getType()));
        builder.append(" of tier ").append(potionEffect.getAmplifier() + 1);
        if (!potionEffect.hasParticles()) {
            builder.append(" without particles");
        }
        builder.append(" for ").append(potionEffect.getDuration() == -1 ? "infinity" : Timespan.fromTicks(Math.abs(potionEffect.getDuration())));
        if (!potionEffect.hasIcon()) {
            builder.append(" without icon");
        }
        return builder.toString();
    }

    public static String[] getNames() {
        return names;
    }

    public static short guessData(ThrownPotion p) {
        if (p.getEffects().size() == 1) {
            PotionEffect e = (PotionEffect)p.getEffects().iterator().next();
            PotionType type = PotionType.getByEffect((PotionEffectType)e.getType());
            assert (type != null);
            Potion d = new Potion(type).splash();
            return d.toDamageValue();
        }
        return 0;
    }

    public static @Nullable PotionType checkPotionType(String name) {
        switch (name) {
            case "uncraftable": 
            case "empty": {
                return PotionType.UNCRAFTABLE;
            }
            case "mundane": {
                return PotionType.MUNDANE;
            }
            case "thick": {
                return PotionType.THICK;
            }
            case "night vision": 
            case "darkvision": {
                return PotionType.NIGHT_VISION;
            }
            case "invisibility": {
                return PotionType.INVISIBILITY;
            }
            case "leaping": 
            case "jump boost": {
                return PotionType.JUMP;
            }
            case "fire resistance": 
            case "fire immunity": {
                return PotionType.FIRE_RESISTANCE;
            }
            case "swiftness": 
            case "speed": {
                return PotionType.SPEED;
            }
            case "slowness": {
                return PotionType.SLOWNESS;
            }
            case "water breathing": {
                return PotionType.WATER_BREATHING;
            }
            case "instant health": 
            case "healing": 
            case "health": {
                return PotionType.INSTANT_HEAL;
            }
            case "instant damage": 
            case "harming": 
            case "damage": {
                return PotionType.INSTANT_DAMAGE;
            }
            case "poison": {
                return PotionType.POISON;
            }
            case "regeneration": 
            case "regen": {
                return PotionType.REGEN;
            }
            case "strength": {
                return PotionType.STRENGTH;
            }
            case "weakness": {
                return PotionType.WEAKNESS;
            }
            case "luck": {
                return PotionType.LUCK;
            }
        }
        return null;
    }

    public static @Nullable PotionType effectToType(PotionEffectType effect) {
        return PotionType.getByEffect((PotionEffectType)effect);
    }

    public static String getPotionName(@Nullable PotionEffectType effect, boolean extended, boolean strong) {
        if (effect == null) {
            return "bottle of water";
        }
        String s = "";
        if (extended) {
            s = s + "extended";
        } else if (strong) {
            s = s + "strong";
        }
        s = s + " potion of ";
        s = s + PotionEffectUtils.toString(effect);
        return s;
    }

    public static void clearAllEffects(LivingEntity entity) {
        entity.getActivePotionEffects().forEach(potionEffect -> entity.removePotionEffect(potionEffect.getType()));
    }

    public static void addEffects(LivingEntity entity, Object[] effects) {
        for (Object object : effects) {
            PotionEffect effect;
            if (object instanceof PotionEffect) {
                effect = (PotionEffect)object;
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effect = new PotionEffect((PotionEffectType)object, 300, 0, false);
            }
            entity.addPotionEffect(effect);
        }
    }

    public static void removeEffects(LivingEntity entity, Object[] effects) {
        for (Object object : effects) {
            PotionEffectType effectType;
            if (object instanceof PotionEffect) {
                effectType = ((PotionEffect)object).getType();
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effectType = (PotionEffectType)object;
            }
            entity.removePotionEffect(effectType);
        }
    }

    public static void clearAllEffects(ItemType itemType) {
        ItemMeta meta = itemType.getItemMeta();
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).clearCustomEffects();
        } else if (HAS_SUSPICIOUS_META && meta instanceof SuspiciousStewMeta) {
            ((SuspiciousStewMeta)meta).clearCustomEffects();
        }
        itemType.setItemMeta(meta);
    }

    public static void addEffects(ItemType itemType, Object[] effects) {
        ItemMeta meta = itemType.getItemMeta();
        for (Object object : effects) {
            PotionEffect effect;
            if (object instanceof PotionEffect) {
                effect = (PotionEffect)object;
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effect = new PotionEffect((PotionEffectType)object, 300, 0, false);
            }
            if (meta instanceof PotionMeta) {
                ((PotionMeta)meta).addCustomEffect(effect, false);
                continue;
            }
            if (!HAS_SUSPICIOUS_META || !(meta instanceof SuspiciousStewMeta)) continue;
            ((SuspiciousStewMeta)meta).addCustomEffect(effect, false);
        }
        itemType.setItemMeta(meta);
    }

    public static void removeEffects(ItemType itemType, Object[] effects) {
        ItemMeta meta = itemType.getItemMeta();
        for (Object object : effects) {
            PotionEffectType effectType;
            if (object instanceof PotionEffect) {
                effectType = ((PotionEffect)object).getType();
            } else {
                if (!(object instanceof PotionEffectType)) continue;
                effectType = (PotionEffectType)object;
            }
            if (meta instanceof PotionMeta) {
                ((PotionMeta)meta).removeCustomEffect(effectType);
                continue;
            }
            if (!HAS_SUSPICIOUS_META || !(meta instanceof SuspiciousStewMeta)) continue;
            ((SuspiciousStewMeta)meta).removeCustomEffect(effectType);
        }
        itemType.setItemMeta(meta);
    }

    public static List<PotionEffect> getEffects(ItemType itemType) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        ItemMeta meta = itemType.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            effects.addAll(potionMeta.getCustomEffects());
            effects.addAll(PotionDataUtils.getPotionEffects(potionMeta.getBasePotionData()));
        } else if (HAS_SUSPICIOUS_META && meta instanceof SuspiciousStewMeta) {
            effects.addAll(((SuspiciousStewMeta)meta).getCustomEffects());
        }
        return effects;
    }

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                types.clear();
                for (PotionEffectType t : PotionEffectType.values()) {
                    if (t == null) continue;
                    String[] ls = Language.getList("potions." + t.getName());
                    PotionEffectUtils.names[t.getId()] = ls[0];
                    for (String l : ls) {
                        types.put(l.toLowerCase(Locale.ENGLISH), t);
                    }
                }
            }
        });
    }
}

