/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util;

import ch.njol.skript.Skript;
import ch.njol.skript.localization.Language;
import ch.njol.skript.localization.LanguageChangeListener;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Callback;
import ch.njol.util.Checker;
import ch.njol.util.NonNullPair;
import ch.njol.util.Pair;
import ch.njol.util.StringUtils;
import ch.njol.util.coll.CollectionUtils;
import ch.njol.util.coll.iterator.EnumerationIterable;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.eclipse.jdt.annotation.Nullable;

public abstract class Utils {
    public static final Random random = new Random();
    private static final String[][] plurals = new String[][]{{"fe", "ves"}, {"axe", "axes"}, {"x", "xes"}, {"ay", "ays"}, {"ey", "eys"}, {"iy", "iys"}, {"oy", "oys"}, {"uy", "uys"}, {"kie", "kies"}, {"zombie", "zombies"}, {"y", "ies"}, {"h", "hes"}, {"man", "men"}, {"us", "i"}, {"hoe", "hoes"}, {"toe", "toes"}, {"o", "oes"}, {"alias", "aliases"}, {"gas", "gases"}, {"child", "children"}, {"sheep", "sheep"}, {"", "s"}};
    static final ChatColor[] styles = new ChatColor[]{ChatColor.BOLD, ChatColor.ITALIC, ChatColor.STRIKETHROUGH, ChatColor.UNDERLINE, ChatColor.MAGIC, ChatColor.RESET};
    static final Map<String, String> chat = new HashMap<String, String>();
    static final Map<String, String> englishChat = new HashMap<String, String>();
    public static final boolean HEX_SUPPORTED = Skript.isRunningMinecraft(1, 16);
    public static final boolean COPY_SUPPORTED = Skript.isRunningMinecraft(1, 15);
    private static final Pattern stylePattern;
    private static final Pattern HEX_PATTERN;

    private Utils() {
    }

    public static String join(Object[] objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(Classes.toString(objects[i]));
        }
        return "" + b.toString();
    }

    public static String join(Iterable<?> objects) {
        assert (objects != null);
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (!first) {
                b.append(", ");
            } else {
                first = false;
            }
            b.append(Classes.toString(o));
        }
        return "" + b.toString();
    }

    public static <T> boolean isEither(@Nullable T compared, T ... types) {
        return CollectionUtils.contains(types, compared);
    }

    public static Pair<String, Integer> getAmount(String s) {
        if (s.matches("\\d+ of .+")) {
            return new Pair<String, Integer>(s.split(" ", 3)[2], Utils.parseInt("" + s.split(" ", 2)[0]));
        }
        if (s.matches("\\d+ .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], Utils.parseInt("" + s.split(" ", 2)[0]));
        }
        if (s.matches("an? .+")) {
            return new Pair<String, Integer>(s.split(" ", 2)[1], 1);
        }
        return new Pair<String, Integer>(s, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?>[] getClasses(Plugin plugin, String basePackage, String ... subPackages) throws IOException {
        assert (subPackages != null);
        JarFile jar = new JarFile(Utils.getFile(plugin));
        for (int i = 0; i < subPackages.length; ++i) {
            subPackages[i] = subPackages[i].replace('.', '/') + "/";
        }
        basePackage = basePackage.replace('.', '/') + "/";
        ArrayList classes = new ArrayList();
        try {
            ArrayList<String> classNames = new ArrayList<String>();
            for (JarEntry e : new EnumerationIterable<JarEntry>(jar.entries())) {
                if (!e.getName().startsWith(basePackage) || !e.getName().endsWith(".class") || e.getName().endsWith("package-info.class")) continue;
                boolean load = subPackages.length == 0;
                for (String sub : subPackages) {
                    if (!e.getName().startsWith(sub, basePackage.length())) continue;
                    load = true;
                    break;
                }
                if (!load) continue;
                classNames.add(e.getName().replace('/', '.').substring(0, e.getName().length() - ".class".length()));
            }
            classNames.sort(String::compareToIgnoreCase);
            for (String c : classNames) {
                try {
                    classes.add(Class.forName(c, true, plugin.getClass().getClassLoader()));
                }
                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                    Skript.exception(ex, "Cannot load class " + c);
                }
                catch (ExceptionInInitializerError err) {
                    Skript.exception(err.getCause(), "class " + c + " generated an exception while loading");
                }
            }
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static @Nullable File getFile(Plugin plugin) {
        try {
            Method getFile = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFile.setAccessible(true);
            return (File)getFile.invoke((Object)plugin, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            Skript.outdatedError(e);
        }
        catch (IllegalArgumentException e) {
            Skript.outdatedError(e);
        }
        catch (IllegalAccessException e) {
            assert (false);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return null;
    }

    public static NonNullPair<String, Boolean> getEnglishPlural(String s) {
        assert (s != null);
        if (s.isEmpty()) {
            return new NonNullPair<String, Boolean>("", Boolean.FALSE);
        }
        for (String[] p : plurals) {
            if (s.endsWith(p[1])) {
                return new NonNullPair<String, Boolean>(s.substring(0, s.length() - p[1].length()) + p[0], Boolean.TRUE);
            }
            if (!s.endsWith(p[1].toUpperCase(Locale.ENGLISH))) continue;
            return new NonNullPair<String, Boolean>(s.substring(0, s.length() - p[1].length()) + p[0].toUpperCase(Locale.ENGLISH), Boolean.TRUE);
        }
        return new NonNullPair<String, Boolean>(s, Boolean.FALSE);
    }

    public static String toEnglishPlural(String s) {
        assert (s != null && s.length() != 0);
        for (String[] p : plurals) {
            if (!s.endsWith(p[0])) continue;
            return s.substring(0, s.length() - p[0].length()) + p[1];
        }
        assert (false);
        return s + "s";
    }

    public static String toEnglishPlural(String s, boolean p) {
        if (p) {
            return Utils.toEnglishPlural(s);
        }
        return s;
    }

    public static String a(String s) {
        return Utils.a(s, false);
    }

    public static String A(String s) {
        return Utils.a(s, true);
    }

    public static String a(String s, boolean capA) {
        assert (s != null && s.length() != 0);
        if ("aeiouAEIOU".indexOf(s.charAt(0)) != -1) {
            if (capA) {
                return "An " + s;
            }
            return "an " + s;
        }
        if (capA) {
            return "A " + s;
        }
        return "a " + s;
    }

    public static double getBlockHeight(int type, byte data) {
        switch (type) {
            case 26: {
                return 0.5625;
            }
            case 44: 
            case 126: {
                return (data & 8) == 0 ? 0.5 : 1.0;
            }
            case 78: {
                return data == 0 ? 1.0 : (double)(data % 8) * 2.0 / 16.0;
            }
            case 85: 
            case 107: 
            case 113: 
            case 139: {
                return 1.5;
            }
            case 88: {
                return 0.875;
            }
            case 92: {
                return 0.4375;
            }
            case 93: 
            case 94: 
            case 149: 
            case 150: {
                return 0.125;
            }
            case 96: {
                return (data & 4) == 0 ? ((data & 8) == 0 ? 0.1875 : 1.0) : 0.0;
            }
            case 116: {
                return 0.75;
            }
            case 117: {
                return 0.875;
            }
            case 118: {
                return 0.3125;
            }
            case 120: {
                return (data & 4) == 0 ? 0.8125 : 1.0;
            }
            case 127: {
                return 0.75;
            }
            case 140: {
                return 0.375;
            }
            case 144: {
                return 0.5;
            }
            case 151: {
                return 0.375;
            }
            case 154: {
                return 0.625;
            }
        }
        return 1.0;
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(String channel, String ... data) {
        return Utils.sendPluginMessage(channel, (ByteArrayDataInput r) -> true, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(Player player, String channel, String ... data) {
        return Utils.sendPluginMessage(player, channel, (ByteArrayDataInput r) -> true, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(String channel, Predicate<ByteArrayDataInput> messageVerifier, String ... data) throws IllegalStateException {
        Player firstPlayer = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (firstPlayer == null) {
            throw new IllegalStateException("There are no players online");
        }
        return Utils.sendPluginMessage(firstPlayer, channel, messageVerifier, data);
    }

    public static CompletableFuture<ByteArrayDataInput> sendPluginMessage(Player player, String channel, Predicate<ByteArrayDataInput> messageVerifier, String ... data) {
        CompletableFuture<ByteArrayDataInput> completableFuture = new CompletableFuture<ByteArrayDataInput>();
        Skript skript = Skript.getInstance();
        Messenger messenger = Bukkit.getMessenger();
        messenger.registerOutgoingPluginChannel((Plugin)skript, channel);
        PluginMessageListener listener = (sendingChannel, sendingPlayer, message) -> {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
            if (channel.equals(sendingChannel) && sendingPlayer == player && !completableFuture.isDone() && !completableFuture.isCancelled() && messageVerifier.test(input)) {
                completableFuture.complete(input);
            }
        };
        messenger.registerIncomingPluginChannel((Plugin)skript, channel, listener);
        completableFuture.whenComplete((r, ex) -> messenger.unregisterIncomingPluginChannel((Plugin)skript, channel, listener));
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)skript, () -> {
            if (!completableFuture.isDone()) {
                completableFuture.cancel(true);
            }
        }, 1200L);
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        Stream.of(data).forEach(arg_0 -> ((ByteArrayDataOutput)out).writeUTF(arg_0));
        player.sendPluginMessage((Plugin)Skript.getInstance(), channel, out.toByteArray());
        return completableFuture;
    }

    public static @Nullable String getChatStyle(String s) {
        SkriptColor color = SkriptColor.fromName(s);
        if (color != null) {
            return color.getFormattedChat();
        }
        return chat.get(s);
    }

    public static String replaceChatStyles(String message) {
        if (message.isEmpty()) {
            return message;
        }
        String m = StringUtils.replaceAll((CharSequence)Matcher.quoteReplacement("" + message.replace("<<none>>", "")), stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                ChatColor chatColor;
                SkriptColor color = SkriptColor.fromName("" + m.group(1));
                if (color != null) {
                    return color.getFormattedChat();
                }
                String tag = m.group(1).toLowerCase(Locale.ENGLISH);
                String f = chat.get(tag);
                if (f != null) {
                    return f;
                }
                if (HEX_SUPPORTED && tag.startsWith("#") && (chatColor = Utils.parseHexColor(tag)) != null) {
                    return chatColor.toString();
                }
                return "" + m.group();
            }
        });
        assert (m != null);
        if (!message.equals(m)) {
            m = m.replace("\\$", "$").replace("\\\\", "\\");
        }
        m = ChatColor.translateAlternateColorCodes((char)'&', (String)("" + m));
        return "" + m;
    }

    public static String replaceEnglishChatStyles(String message) {
        if (message.isEmpty()) {
            return message;
        }
        String m = StringUtils.replaceAll((CharSequence)Matcher.quoteReplacement(message), stylePattern, new Callback<String, Matcher>(){

            @Override
            public String run(Matcher m) {
                ChatColor chatColor;
                SkriptColor color = SkriptColor.fromName("" + m.group(1));
                if (color != null) {
                    return color.getFormattedChat();
                }
                String tag = m.group(1).toLowerCase(Locale.ENGLISH);
                String f = englishChat.get(tag);
                if (f != null) {
                    return f;
                }
                if (HEX_SUPPORTED && tag.startsWith("#") && (chatColor = Utils.parseHexColor(tag)) != null) {
                    return chatColor.toString();
                }
                return "" + m.group();
            }
        });
        assert (m != null);
        if (!message.equals(m)) {
            m = m.replace("\\$", "$").replace("\\\\", "\\");
        }
        m = ChatColor.translateAlternateColorCodes((char)'&', (String)("" + m));
        return "" + m;
    }

    public static @Nullable ChatColor parseHexColor(String hex) {
        if (!HEX_SUPPORTED || !HEX_PATTERN.matcher(hex).matches()) {
            return null;
        }
        hex = hex.replace("#", "");
        try {
            return ChatColor.of((String)('#' + hex.substring(0, 6)));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static int random(int start, int end) {
        if (end <= start) {
            throw new IllegalArgumentException("end (" + end + ") must be > start (" + start + ")");
        }
        return start + random.nextInt(end - start);
    }

    public static Class<?> getSuperType(Class<?> ... cs) {
        assert (cs.length > 0);
        Class<?> r = cs[0];
        assert (r != null);
        block0: for (Class<?> c : cs) {
            assert (c != null && !c.isArray() && !c.isPrimitive()) : c;
            if (c.isAssignableFrom(r)) {
                r = c;
                continue;
            }
            if (r.isAssignableFrom(c)) continue;
            Class<?> s = c;
            while ((s = s.getSuperclass()) != null) {
                if (s == Object.class || !s.isAssignableFrom(r)) continue;
                r = s;
                continue block0;
            }
            for (Class<?> i : c.getInterfaces()) {
                s = Utils.getSuperType(i, r);
                if (s == Object.class) continue;
                r = s;
                continue block0;
            }
            return Object.class;
        }
        return r.equals(Cloneable.class) ? Object.class : r;
    }

    public static int parseInt(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
    }

    public static long parseLong(String s) {
        assert (s.matches("-?\\d+"));
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return s.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
    }

    public static Class<?> classForName(String name) {
        try {
            Class<?> c = Class.forName(name);
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found!");
        }
    }

    public static <T> int findLastIndex(List<T> list, Checker<T> checker) {
        int lastIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            if (!checker.check(list.get(i))) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    public static boolean isInteger(Number ... numbers) {
        for (Number number : numbers) {
            if (!Double.class.isAssignableFrom(number.getClass()) && !Float.class.isAssignableFrom(number.getClass())) continue;
            return false;
        }
        return true;
    }

    static {
        Language.addListener(new LanguageChangeListener(){

            @Override
            public void onLanguageChange() {
                boolean english = englishChat.isEmpty();
                chat.clear();
                for (ChatColor style : styles) {
                    for (String s : Language.getList("chat styles." + style.name())) {
                        chat.put(s.toLowerCase(Locale.ENGLISH), style.toString());
                        if (!english) continue;
                        englishChat.put(s.toLowerCase(Locale.ENGLISH), style.toString());
                    }
                }
            }
        });
        stylePattern = Pattern.compile("<([^<>]+)>");
        HEX_PATTERN = Pattern.compile("(?i)#?[0-9a-f]{6}");
    }
}

