/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.skript.util.slot;

import ch.njol.skript.bukkitutil.PlayerUtils;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.slot.Slot;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.Nullable;

public class CursorSlot
extends Slot {
    private final @Nullable ItemStack eventItemStack;
    private final Player player;

    public CursorSlot(Player player) {
        this(player, null);
    }

    public CursorSlot(Player player, @Nullable ItemStack eventItemStack) {
        this.eventItemStack = eventItemStack;
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public @Nullable ItemStack getItem() {
        if (this.eventItemStack != null) {
            return this.eventItemStack;
        }
        return this.player.getItemOnCursor();
    }

    @Override
    public void setItem(@Nullable ItemStack item) {
        this.player.setItemOnCursor(item);
        PlayerUtils.updateInventory(this.player);
    }

    @Override
    public int getAmount() {
        return this.getItem().getAmount();
    }

    @Override
    public void setAmount(int amount) {
        this.getItem().setAmount(amount);
    }

    public boolean isInventoryClick() {
        return this.eventItemStack != null;
    }

    @Override
    public boolean isSameSlot(Slot slot) {
        if (!(slot instanceof CursorSlot)) {
            return false;
        }
        CursorSlot cursor = (CursorSlot)slot;
        return cursor.getPlayer().equals(this.player) && cursor.isInventoryClick() == this.isInventoryClick();
    }

    @Override
    public String toString(@Nullable Event event, boolean debug) {
        return "cursor slot of " + Classes.toString(this.player);
    }
}

