/*
 * Decompiled with CFR 0.152.
 */
package ch.njol.util.coll.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.Nullable;

public class CombinedIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterable<T>> iterators;
    private boolean removable;
    private @Nullable Iterator<T> current = null;
    private @Nullable Iterator<T> last = null;

    public CombinedIterator(Iterator<? extends Iterable<T>> iterators) {
        this(iterators, true);
    }

    public CombinedIterator(Iterator<? extends Iterable<T>> iterators, boolean removable) {
        this.iterators = iterators;
        this.removable = removable;
    }

    @Override
    public boolean hasNext() {
        while ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
            this.current = this.iterators.next().iterator();
        }
        return this.current != null && this.current.hasNext();
    }

    @Override
    public @Nullable T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator<T> current = this.current;
        assert (current != null);
        this.last = current;
        return current.next();
    }

    @Override
    public void remove() {
        if (!this.removable) {
            throw new UnsupportedOperationException();
        }
        if (this.last == null) {
            throw new IllegalStateException();
        }
        this.last.remove();
    }
}

