/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.arithmetic;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAPIException;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import org.skriptlang.skript.lang.arithmetic.DifferenceInfo;
import org.skriptlang.skript.lang.arithmetic.Operation;
import org.skriptlang.skript.lang.arithmetic.OperationInfo;
import org.skriptlang.skript.lang.arithmetic.Operator;

public final class Arithmetics {
    private static final Map<Operator, List<OperationInfo<?, ?, ?>>> operations = Collections.synchronizedMap(new HashMap());
    private static final Map<Operator, Map<Pair<Class<?>, Class<?>>, OperationInfo<?, ?, ?>>> cachedOperations = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, DifferenceInfo<?, ?>> differences = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, DifferenceInfo<?, ?>> cachedDifferences = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, Supplier<?>> defaultValues = Collections.synchronizedMap(new HashMap());
    private static final Map<Class<?>, Supplier<?>> cachedDefaultValues = Collections.synchronizedMap(new HashMap());

    public static <T> void registerOperation(Operator operator, Class<T> type, Operation<T, T, T> operation) {
        Arithmetics.registerOperation(operator, type, type, type, operation);
    }

    public static <L, R> void registerOperation(Operator operator, Class<L> leftClass, Class<R> rightClass, Operation<L, R, L> operation) {
        Arithmetics.registerOperation(operator, leftClass, rightClass, leftClass, operation);
    }

    public static <L, R> void registerOperation(Operator operator, Class<L> leftClass, Class<R> rightClass, Operation<L, R, L> operation, Operation<R, L, L> commutativeOperation) {
        Arithmetics.registerOperation(operator, leftClass, rightClass, leftClass, operation);
        Arithmetics.registerOperation(operator, rightClass, leftClass, leftClass, commutativeOperation);
    }

    public static <L, R, T> void registerOperation(Operator operator, Class<L> leftClass, Class<R> rightClass, Class<T> returnType, Operation<L, R, T> operation, Operation<R, L, T> commutativeOperation) {
        Arithmetics.registerOperation(operator, leftClass, rightClass, returnType, operation);
        Arithmetics.registerOperation(operator, rightClass, leftClass, returnType, commutativeOperation);
    }

    public static <L, R, T> void registerOperation(Operator operator, Class<L> leftClass, Class<R> rightClass, Class<T> returnType, Operation<L, R, T> operation) {
        Skript.checkAcceptRegistrations();
        if (Arithmetics.exactOperationExists(operator, leftClass, rightClass)) {
            throw new SkriptAPIException("There's already a " + operator.getName() + " operation registered for types '" + leftClass + "' and '" + rightClass + "'");
        }
        Arithmetics.getOperations_i(operator).add(new OperationInfo<L, R, T>(leftClass, rightClass, returnType, operation));
    }

    private static boolean exactOperationExists(Operator operator, Class<?> leftClass, Class<?> rightClass) {
        for (OperationInfo<?, ?, ?> info : Arithmetics.getOperations_i(operator)) {
            if (info.getLeft() != leftClass || info.getRight() != rightClass) continue;
            return true;
        }
        return false;
    }

    public static boolean operationExists(Operator operator, Class<?> leftClass, Class<?> rightClass) {
        return Arithmetics.getOperationInfo(operator, leftClass, rightClass) != null;
    }

    private static List<OperationInfo<?, ?, ?>> getOperations_i(Operator operator) {
        return operations.computeIfAbsent(operator, o -> Collections.synchronizedList(new ArrayList()));
    }

    public static @UnmodifiableView List<OperationInfo<?, ?, ?>> getOperations(Operator operator) {
        Arithmetics.assertIsOperationsDoneLoading();
        return Collections.unmodifiableList(Arithmetics.getOperations_i(operator));
    }

    public static <T> List<OperationInfo<T, ?, ?>> getOperations(Operator operator, Class<T> type) {
        return Arithmetics.getOperations(operator).stream().filter(info -> info.getLeft().isAssignableFrom(type)).collect(Collectors.toList());
    }

    @Nullable
    public static <L, R, T> OperationInfo<L, R, T> getOperationInfo(Operator operator, Class<L> leftClass, Class<R> rightClass, Class<T> returnType) {
        OperationInfo<L, R, ?> info = Arithmetics.getOperationInfo(operator, leftClass, rightClass);
        if (info != null && returnType.isAssignableFrom(info.getReturnType())) {
            return info;
        }
        return null;
    }

    private static Map<Pair<Class<?>, Class<?>>, OperationInfo<?, ?, ?>> getCachedOperations(Operator operator) {
        return cachedOperations.computeIfAbsent(operator, o -> Collections.synchronizedMap(new HashMap()));
    }

    @Nullable
    public static <L, R> OperationInfo<L, R, ?> getOperationInfo(Operator operator, Class<L> leftClass, Class<R> rightClass) {
        Arithmetics.assertIsOperationsDoneLoading();
        return Arithmetics.getCachedOperations(operator).computeIfAbsent(new Pair<Class<L>, Class<R>>(leftClass, rightClass), pair -> Arithmetics.getOperations(operator).stream().filter(info -> info.getLeft().isAssignableFrom(leftClass) && info.getRight().isAssignableFrom(rightClass)).reduce((info, info2) -> {
            if (info2.getLeft() == leftClass && info2.getRight() == rightClass) {
                return info2;
            }
            return info;
        }).orElse(null));
    }

    @Nullable
    public static <L, R, T> Operation<L, R, T> getOperation(Operator operator, Class<L> leftClass, Class<R> rightClass, Class<T> returnType) {
        OperationInfo<L, R, T> info = Arithmetics.getOperationInfo(operator, leftClass, rightClass, returnType);
        return info == null ? null : info.getOperation();
    }

    @Nullable
    public static <L, R> Operation<L, R, ?> getOperation(Operator operator, Class<L> leftClass, Class<R> rightClass) {
        OperationInfo<L, R, ?> info = Arithmetics.getOperationInfo(operator, leftClass, rightClass);
        return info == null ? null : info.getOperation();
    }

    @Nullable
    public static <L, R, T> OperationInfo<L, R, T> lookupOperationInfo(Operator operator, Class<L> leftClass, Class<R> rightClass, Class<T> returnType) {
        OperationInfo<L, R, ?> info = Arithmetics.lookupOperationInfo(operator, leftClass, rightClass);
        return info != null ? info.getConverted(leftClass, rightClass, returnType) : null;
    }

    @Nullable
    public static <L, R> OperationInfo<L, R, ?> lookupOperationInfo(Operator operator, Class<L> leftClass, Class<R> rightClass) {
        OperationInfo<L, R, ?> operationInfo = Arithmetics.getOperationInfo(operator, leftClass, rightClass);
        if (operationInfo != null) {
            return operationInfo;
        }
        return Arithmetics.getCachedOperations(operator).computeIfAbsent(new Pair<Class<L>, Class<R>>(leftClass, rightClass), pair -> {
            for (OperationInfo<?, ?, ?> info : Arithmetics.getOperations(operator)) {
                OperationInfo convertedInfo;
                if (!info.getLeft().isAssignableFrom(leftClass) && !info.getRight().isAssignableFrom(rightClass) || (convertedInfo = info.getConverted(leftClass, rightClass, info.getReturnType())) == null) continue;
                return convertedInfo;
            }
            return null;
        });
    }

    public static <L, R, T> T calculate(Operator operator, L left, R right, Class<T> returnType) {
        Operation<?, ?, T> operation = Arithmetics.getOperation(operator, left.getClass(), right.getClass(), returnType);
        return operation == null ? null : (T)operation.calculate(left, right);
    }

    public static <L, R, T> T calculateUnsafe(Operator operator, L left, R right) {
        Operation<?, ?, ?> operation = Arithmetics.getOperation(operator, left.getClass(), right.getClass());
        return operation == null ? null : (T)operation.calculate(left, right);
    }

    public static <T> void registerDifference(Class<T> type, Operation<T, T, T> operation) {
        Arithmetics.registerDifference(type, type, operation);
    }

    public static <T, R> void registerDifference(Class<T> type, Class<R> returnType, Operation<T, T, R> operation) {
        Skript.checkAcceptRegistrations();
        if (Arithmetics.exactDifferenceExists(type)) {
            throw new IllegalArgumentException("There's already a difference registered for type '" + type + "'");
        }
        differences.put(type, new DifferenceInfo<T, R>(type, returnType, operation));
    }

    private static boolean exactDifferenceExists(Class<?> type) {
        return differences.containsKey(type);
    }

    public static boolean differenceExists(Class<?> type) {
        return Arithmetics.getDifferenceInfo(type) != null;
    }

    public static <T, R> DifferenceInfo<T, R> getDifferenceInfo(Class<T> type, Class<R> returnType) {
        DifferenceInfo<T, ?> info = Arithmetics.getDifferenceInfo(type);
        if (info != null && returnType.isAssignableFrom(info.getReturnType())) {
            return info;
        }
        return null;
    }

    public static <T> DifferenceInfo<T, ?> getDifferenceInfo(Class<T> type) {
        if (Skript.isAcceptRegistrations()) {
            throw new SkriptAPIException("Differences cannot be retrieved until Skript has finished registrations.");
        }
        return cachedDifferences.computeIfAbsent(type, c -> {
            if (differences.containsKey(type)) {
                return differences.get(type);
            }
            for (Map.Entry<Class<?>, DifferenceInfo<?, ?>> entry : differences.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                return entry.getValue();
            }
            return null;
        });
    }

    public static <T, R> Operation<T, T, R> getDifference(Class<T> type, Class<R> returnType) {
        DifferenceInfo<T, R> info = Arithmetics.getDifferenceInfo(type, returnType);
        return info == null ? null : info.getOperation();
    }

    public static <T> Operation<T, T, ?> getDifference(Class<T> type) {
        DifferenceInfo<T, ?> info = Arithmetics.getDifferenceInfo(type);
        return info == null ? null : info.getOperation();
    }

    public static <T, R> R difference(T left, T right, Class<R> returnType) {
        Operation<?, ?, R> operation = Arithmetics.getDifference(left.getClass(), returnType);
        return operation == null ? null : (R)operation.calculate(left, right);
    }

    public static <T, R> R differenceUnsafe(T left, T right) {
        Operation<?, ?, ?> operation = Arithmetics.getDifference(left.getClass());
        return operation == null ? null : (R)operation.calculate(left, right);
    }

    public static <T> void registerDefaultValue(Class<T> type, Supplier<T> supplier) {
        Skript.checkAcceptRegistrations();
        if (defaultValues.containsKey(type)) {
            throw new IllegalArgumentException("There's already a default value registered for type '" + type + "'");
        }
        defaultValues.put(type, supplier);
    }

    public static <R, T extends R> R getDefaultValue(Class<T> type) {
        if (Skript.isAcceptRegistrations()) {
            throw new SkriptAPIException("Default values cannot be retrieved until Skript has finished registrations.");
        }
        Supplier supplier = cachedDefaultValues.computeIfAbsent(type, c -> {
            if (defaultValues.containsKey(type)) {
                return defaultValues.get(type);
            }
            for (Map.Entry<Class<?>, Supplier<?>> entry : defaultValues.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                return entry.getValue();
            }
            return null;
        });
        return supplier == null ? null : (R)supplier.get();
    }

    private static void assertIsOperationsDoneLoading() {
        if (Skript.isAcceptRegistrations()) {
            throw new SkriptAPIException("Operations cannot be retrieved until Skript has finished registrations.");
        }
    }
}

