/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.entry;

import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.parser.ParserInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;

public class EntryContainer {
    private final SectionNode source;
    private final @Nullable EntryValidator entryValidator;
    private final @Nullable Map<String, Node> handledNodes;
    private final List<Node> unhandledNodes;

    EntryContainer(SectionNode source, @Nullable EntryValidator entryValidator, @Nullable Map<String, Node> handledNodes, List<Node> unhandledNodes) {
        this.source = source;
        this.entryValidator = entryValidator;
        this.handledNodes = handledNodes;
        this.unhandledNodes = unhandledNodes;
    }

    public static EntryContainer withoutValidator(SectionNode source) {
        ArrayList<Node> unhandledNodes = new ArrayList<Node>();
        for (Node node : source) {
            unhandledNodes.add(node);
        }
        return new EntryContainer(source, null, null, unhandledNodes);
    }

    public SectionNode getSource() {
        return this.source;
    }

    public List<Node> getUnhandledNodes() {
        return this.unhandledNodes;
    }

    public <E, R extends E> R get(String key, Class<E> expectedType, boolean useDefaultValue) {
        R value = this.getOptional(key, expectedType, useDefaultValue);
        if (value == null) {
            throw new RuntimeException("Null value for asserted non-null value");
        }
        return value;
    }

    public Object get(String key, boolean useDefaultValue) {
        Object parsed = this.getOptional(key, useDefaultValue);
        if (parsed == null) {
            throw new RuntimeException("Null value for asserted non-null value");
        }
        return parsed;
    }

    public <E, R extends E> @Nullable R getOptional(String key, Class<E> expectedType, boolean useDefaultValue) {
        Object parsed = this.getOptional(key, useDefaultValue);
        if (parsed == null) {
            return null;
        }
        if (!expectedType.isInstance(parsed)) {
            throw new RuntimeException("Expected entry with key '" + key + "' to be '" + expectedType + "', but got '" + parsed.getClass() + "'");
        }
        return (R)parsed;
    }

    public @Nullable Object getOptional(String key, boolean useDefaultValue) {
        if (this.entryValidator == null || this.handledNodes == null) {
            return null;
        }
        EntryData<?> entryData = null;
        for (EntryData<?> data : this.entryValidator.getEntryData()) {
            if (!data.getKey().equals(key)) continue;
            entryData = data;
            break;
        }
        if (entryData == null) {
            return null;
        }
        Node node = this.handledNodes.get(key);
        if (node == null) {
            return entryData.getDefaultValue();
        }
        ParserInstance parser = ParserInstance.get();
        Node oldNode = parser.getNode();
        parser.setNode(node);
        Object value = entryData.getValue(node);
        if (value == null && useDefaultValue) {
            value = entryData.getDefaultValue();
        }
        parser.setNode(oldNode);
        return value;
    }
}

