/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.entry.util;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.localization.Message;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.log.ParseLogHandler;
import org.eclipse.jdt.annotation.Nullable;
import org.skriptlang.skript.lang.entry.KeyValueEntryData;

public class ExpressionEntryData<T>
extends KeyValueEntryData<Expression<? extends T>> {
    private static final Message M_IS = new Message("is");
    private final Class<T> returnType;
    private final int flags;

    public ExpressionEntryData(String key, @Nullable Expression<T> defaultValue, boolean optional, Class<T> returnType) {
        this(key, defaultValue, optional, returnType, 3);
    }

    public ExpressionEntryData(String key, @Nullable Expression<T> defaultValue, boolean optional, Class<T> returnType, int flags) {
        super(key, defaultValue, optional);
        this.returnType = returnType;
        this.flags = flags;
    }

    @Override
    protected @Nullable Expression<? extends T> getValue(String value) {
        Expression expression;
        try (ParseLogHandler log = new ParseLogHandler().start();){
            expression = new SkriptParser(value, this.flags, ParseContext.DEFAULT).parseExpression(this.returnType);
            if (expression == null) {
                log.printError("'" + value + "' " + M_IS + " " + SkriptParser.notOfType(this.returnType), ErrorQuality.NOT_AN_EXPRESSION);
            }
        }
        return expression;
    }
}

