/*
 * Decompiled with CFR 0.152.
 */
package org.skriptlang.skript.lang.script;

import ch.njol.skript.config.Config;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.skriptlang.skript.lang.script.ScriptData;
import org.skriptlang.skript.lang.script.ScriptEvent;
import org.skriptlang.skript.lang.script.ScriptWarning;
import org.skriptlang.skript.lang.structure.Structure;

public final class Script {
    private final Config config;
    private final List<Structure> structures;
    private final Set<ScriptWarning> suppressedWarnings = new HashSet<ScriptWarning>(ScriptWarning.values().length);
    private final Map<Class<? extends ScriptData>, ScriptData> scriptData = new ConcurrentHashMap<Class<? extends ScriptData>, ScriptData>(5);
    private final Set<ScriptEvent> eventHandlers = new HashSet<ScriptEvent>(5);

    @ApiStatus.Internal
    public Script(Config config, List<Structure> structures) {
        this.config = config;
        this.structures = structures;
    }

    public Config getConfig() {
        return this.config;
    }

    public @Unmodifiable List<Structure> getStructures() {
        return Collections.unmodifiableList(this.structures);
    }

    public void suppressWarning(ScriptWarning warning) {
        this.suppressedWarnings.add(warning);
    }

    public void allowWarning(ScriptWarning warning) {
        this.suppressedWarnings.remove((Object)warning);
    }

    public boolean suppressesWarning(ScriptWarning warning) {
        return this.suppressedWarnings.contains((Object)warning);
    }

    @ApiStatus.Experimental
    public void addData(ScriptData data) {
        this.scriptData.put(data.getClass(), data);
    }

    @ApiStatus.Experimental
    public void removeData(Class<? extends ScriptData> dataType) {
        this.scriptData.remove(dataType);
    }

    @ApiStatus.Experimental
    public void clearData() {
        this.scriptData.clear();
    }

    @ApiStatus.Experimental
    public <Type extends ScriptData> @Nullable Type getData(Class<Type> dataType) {
        return (Type)this.scriptData.get(dataType);
    }

    @ApiStatus.Experimental
    public <Value extends ScriptData> Value getData(Class<? extends Value> dataType, Supplier<Value> mapper) {
        return (Value)this.scriptData.computeIfAbsent(dataType, clazz -> (ScriptData)mapper.get());
    }

    @ApiStatus.Experimental
    public void registerEvent(ScriptEvent event) {
        this.eventHandlers.add(event);
    }

    @ApiStatus.Experimental
    public <T extends ScriptEvent> void registerEvent(Class<T> eventType, T event) {
        this.eventHandlers.add(event);
    }

    @ApiStatus.Experimental
    public void unregisterEvent(ScriptEvent event) {
        this.eventHandlers.remove(event);
    }

    @ApiStatus.Experimental
    public @Unmodifiable Set<ScriptEvent> getEvents() {
        return Collections.unmodifiableSet(this.eventHandlers);
    }

    @ApiStatus.Experimental
    public <T extends ScriptEvent> @Unmodifiable Set<T> getEvents(Class<T> type) {
        return Collections.unmodifiableSet(this.eventHandlers.stream().filter(event -> type.isAssignableFrom(event.getClass())).collect(Collectors.toSet()));
    }
}

