/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import org.bukkit.event.Event;

@Name(value="Does YAML Path Exist")
@Description(value={"Checks if one or more paths exist in a cached YAML file using said ID.\n  - First input is the path.\n  - Second input is the ID.\n  - If multiple paths are checked at once it will return false on the first one found to not exist."})
@Examples(value={"set skript-yaml value \"test.test\" from \"config\" to \"test\"", "set skript-yaml value \"test2.test2\" from \"config\" to \"test\"", " ", "yaml path \"test.test\" and \"test2.test2\" in \"config\" exists:", "\tbroadcast \"this works\"", "yaml path \"test.test\" and \"boop.boop\" in \"config\" exists:", "\tbroadcast \"this will fail\""})
@Since(value="1.2.1")
public class CondYamlPathExists
extends Condition {
    private Expression<String> path;
    private Expression<String> file;

    public boolean check(final Event event) {
        return this.path.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                if (!SkriptYaml.YAML_STORE.containsKey(CondYamlPathExists.this.file.getSingle(event))) {
                    return false;
                }
                if (CondYamlPathExists.this.path.isSingle()) {
                    return SkriptYaml.YAML_STORE.get(CondYamlPathExists.this.file.getSingle(event)).getAllKeys().contains(CondYamlPathExists.this.path.getSingle(event));
                }
                for (String p : (String[])CondYamlPathExists.this.path.getAll(event)) {
                    boolean check = SkriptYaml.YAML_STORE.get(CondYamlPathExists.this.file.getSingle(event)).getAllKeys().contains(p);
                    if (check) continue;
                    return false;
                }
                return true;
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "yaml path " + this.path.toString(event, debug) + " in " + this.file.toString(event, debug) + (this.isNegated() ? (this.path.isSingle() ? " does" : " do") + " not exist" : "exist");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.path = exprs[0];
        this.file = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondYamlPathExists.class, (String[])new String[]{"[skript-]y[a]ml [(node|path)[s]] %strings% (of|in|from) %string% exists", "[skript-]y[a]ml [(node|path)[s]] %strings% (of|in|from) %string% does(n't| not) exist"});
    }
}

