/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import java.io.File;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.AsyncEffectOld;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.StringUtil;
import org.bukkit.event.Event;

@Name(value="Delete all YAML from one or more directories")
@Description(value={"Syntax 1: Deletes all YAML files from one or more directories and removes them from memory.\nSyntax 2&3: Only deletes any loaded YAML files from one or more directories and removes them from memory.\n  - The input is one or more directories (ie. \"plugins/MyAwesomePlugin/\" and \"plugins/skript-yaml/\")."})
@Examples(value={"delete all yaml from directory \"/plugins/skript-yaml/test\"", " ", "delete all loaded yaml from directory \"/plugins/skript-yaml/test\"", " ", "delete all loaded yaml from directory \"/plugins/skript-yaml/test\" using the filename as the id"})
@Since(value="1.2.1")
public class EffDeleteYamlFromDirectory
extends AsyncEffectOld {
    private Expression<String> directories;
    private int mark;
    private int matchedPattern;
    private SkriptNode skriptNode;

    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.directories.getAll(event)) {
            File[] directoryFilter = SkriptYamlUtils.directoryFilter(StringUtil.checkSeparator(name), this.mark == 1, "Delete", this.skriptNode);
            if (directoryFilter == null) {
                return;
            }
            for (File yamlFile : directoryFilter) {
                String n = null;
                if (this.matchedPattern == 0) {
                    n = StringUtil.checkLastSeparator(name) + yamlFile.getName();
                } else if (this.matchedPattern == 1) {
                    n = StringUtil.stripExtention(yamlFile.getName());
                }
                if (!SkriptYaml.YAML_STORE.containsKey(n)) continue;
                SkriptYaml.YAML_STORE.get(n).getFile().delete();
                SkriptYaml.YAML_STORE.remove(n);
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "delete all" + (this.matchedPattern == 0 ? " loaded " : " ") + "yaml from" + (this.mark == 1 ? " non-relative " : " ") + "director" + (this.directories.isSingle() ? "y " : "ies ") + this.directories.toString(event, b) + (this.matchedPattern == 2 ? " using the filename as the id" : "");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.directories = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        this.skriptNode = new SkriptNode(SkriptLogger.getNode());
        return true;
    }

    static {
        Skript.registerEffect(EffDeleteYamlFromDirectory.class, (String[])new String[]{"delete (all|any) [loaded] [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "delete (all|any) [loaded] [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }
}

