/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="Load all YAML from directory")
@Description(value={"Loads a directory YAML files into memory.\n  - The input is a directory (ie. \"plugins/MyAwesomePlugin/\").\n  - If for example a file in that directory is named test.yml then the output ID would be 'plugins/MyAwesomePlugin/test.yml'\n  - Using the optional filename ID would output `test.yml`"})
@Examples(value={"#This isn't something you would really want to do, or is it?", "load all yaml from directory \"/plugins/skript-yaml/test\"", "loop all of the currently loaded yaml files:", "\tloop yaml nodes \"\" from loop-value-1:", "\t\tloop yaml nodes loop-value-2 from loop-value-1:", "\t\t\tbroadcast yaml value \"%loop-value-2%.%loop-value-3%\" from loop-value-1"})
@Since(value="1.2")
public class EffLoadYamlDirectory
extends Effect {
    private Expression<String> directories;
    private int mark;
    private int matchedPattern;
    private SkriptNode skriptNode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(@Nullable Event event) {
        for (String name : (String[])this.directories.getAll(event)) {
            File[] directoryFilter = SkriptYamlUtils.directoryFilter(StringUtil.checkSeparator(name), this.mark == 1, "Load", this.skriptNode);
            if (directoryFilter == null) {
                return;
            }
            for (File yamlFile : directoryFilter) {
                YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
                try {
                    yaml.load();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.matchedPattern == 1) {
                        SkriptYaml.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                    } else {
                        SkriptYaml.YAML_STORE.put(StringUtil.checkLastSeparator(name) + yamlFile.getName(), yaml);
                    }
                }
            }
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load all yaml from director(y|ies) " + this.directories.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.directories = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        this.skriptNode = new SkriptNode(SkriptLogger.getNode());
        return true;
    }

    static {
        Skript.registerEffect(EffLoadYamlDirectory.class, (String[])new String[]{"[re]load all [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings%", "[re]load all [y[a]ml] from [(1\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }
}

