/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.lang.reflect.Array;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SimpleExpressionFork;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;

@Name(value="YAML list value")
@Description(value={"Gets, sets, removes values from a list from a cached yaml file using an index\n  - Requires index between 1 and the size of the list\n  - Requires the id used/created from the load effect\n  - This expression does not save to file\n  - Using 'without string checks' optional is a tiny bit faster but doesn't check/convert strings for numbers or booleans"})
@Examples(value={"set index 1 in list \"test1.test2\" from \"config\" to \"test3\"", " ", "set {_test} to yaml index 1 in list \"test1.test2\" from \"config\"", "broadcast \"%{_test}%\""})
@Since(value="1.3.3")
public class ExprListValue<T>
extends SimpleExpressionFork<T> {
    private boolean checks = false;
    private Expression<Number> index;
    private Expression<String> path;
    private Expression<String> name;
    private SkriptNode skriptNode;
    private final ExprListValue<?> source;
    private final Class<T> superType;

    public ExprListValue() {
        this(null, Object.class);
    }

    private ExprListValue(ExprListValue<?> source, Class<? extends T> ... types) {
        this.source = source;
        if (source != null) {
            this.index = source.index;
            this.path = source.path;
            this.name = source.name;
            this.checks = source.checks;
            this.skriptNode = source.skriptNode;
        }
        this.superType = Utils.getSuperType((Class[])types);
    }

    @Override
    public <R> Expression<? extends R> getConvertedExpression(Class<R> ... to) {
        return new ExprListValue<R>(this, to);
    }

    @Override
    public Expression<?> getSource() {
        return this.source == null ? this : this.source;
    }

    public Class<? extends T> getReturnType() {
        return this.superType;
    }

    public boolean isSingle() {
        return true;
    }

    public String toString(@Nullable Event event, boolean b) {
        return "index " + this.index.toString(event, b) + " in list " + this.path.toString(event, b) + " from " + this.name.toString(event, b) + (!this.checks ? "" : " without string checks");
    }

    @Override
    @Nullable
    protected T[] get(Event event) {
        String path = (String)this.path.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Object[] objects = this.check(event, (String)this.name.getSingle(event), path, index, false);
        if (objects == null) {
            return null;
        }
        List items = (List)objects[0];
        if (items == null) {
            return null;
        }
        Object o = items.get(index - 1);
        if (o != null) {
            if (!this.checks && String.class.isAssignableFrom(o.getClass())) {
                o = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)o));
            }
            try {
                return SkriptYamlUtils.convertToArray(o, o.getClass());
            }
            catch (ClassCastException e) {
                return (Object[])Array.newInstance(o.getClass(), 0);
            }
        }
        return null;
    }

    @Override
    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String path = (String)this.path.getSingle(event);
        int index = ((Number)this.index.getSingle(event)).intValue();
        Object[] objects = this.check(event, (String)this.name.getSingle(event), path, index, true);
        if (objects == null) {
            return;
        }
        List items = (List)objects[0];
        if (items == null) {
            return;
        }
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            items.remove(index - 1);
        } else if (mode == Changer.ChangeMode.SET) {
            items.set(index - 1, StringUtil.parseString(delta[0], this.checks));
        }
        ((YAMLProcessor)objects[1]).setProperty(path, items);
    }

    public Object[] check(Event event, String name, String path, int index, boolean alsoReturnConfig) {
        List<Object> items;
        Object[] objects;
        if (!SkriptYamlUtils.yamlExists(name, this.skriptNode)) {
            return null;
        }
        if (alsoReturnConfig) {
            Object[] objectArray = new Object[2];
            objects = objectArray;
            YAMLProcessor yAMLProcessor = SkriptYaml.YAML_STORE.get(name);
            objectArray[1] = yAMLProcessor;
            items = yAMLProcessor.getList(path);
        } else {
            objects = new Object[1];
            items = SkriptYaml.YAML_STORE.get(name).getList(path);
        }
        if (items == null) {
            SkriptYaml.warn("The node '" + path + "' in yaml '" + name + "' is not a list " + this.skriptNode.toString());
            return null;
        }
        if (index < 1 || index > items.size()) {
            SkriptYaml.warn("The index of node '" + path + "' in yaml '" + name + "' needs to be between 1 and " + items.size() + " " + this.skriptNode.toString());
            return null;
        }
        objects[0] = items;
        return objects;
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object.class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.index = e[0];
        this.path = e[1];
        this.name = e[2];
        if (parse.expr.toLowerCase().endsWith(" without string checks")) {
            this.checks = true;
        }
        this.skriptNode = new SkriptNode(SkriptLogger.getNode());
        return true;
    }

    static {
        Skript.registerExpression(ExprListValue.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[[skript-]y[a]ml] (index|value) %number% (of|in|from) list %string% (of|in|from) %string% [without string checks]"});
    }
}

