/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.config.Node;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.ConvertedExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Utils;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.iterator.ArrayIterator;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SimpleExpressionFork;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.skript.ExprYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.versions.wrapper.AbstractLoop;
import org.bukkit.event.Event;

@Name(value="Yaml Loop")
@Description(value={"The currently looped value of a yaml expression."})
@Examples(value={"", "loop yaml node keys \"node\" from \"config\":", "\tmessage yaml value loop-node from loop-id", "loop yaml node list \"node\" from \"config\":", "\tmessage yaml value loop-node from loop-id"})
@Since(value="1.3")
public class ExprLoopYaml
extends SimpleExpressionFork<Object> {
    private String name;
    private Expression<Integer> number;
    private AbstractLoop loop;
    ExprYaml.YamlState yamlState;
    LoopState loopState;
    boolean isYamlLoop = false;

    public boolean init(Expression<?>[] vars, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        AbstractLoop loop;
        this.name = parser.expr;
        this.number = vars[0];
        String s = this.name.split("-")[1];
        int i = -1;
        if (this.number != null) {
            i = (Integer)((Literal)this.number).getSingle();
        }
        if ((loop = SkriptYaml.getInstance().getSkriptAdapter().getLoop(i, s)) == null) {
            SkriptYaml.error("There are multiple loops that match loop-" + s + ". Use loop-" + s + "-1/2/3/etc. to specify which loop's value you want. " + this.getNodeMsg());
            return false;
        }
        if (loop != null && loop.getObject() == null) {
            SkriptYaml.error("There's no loop that matches 'loop-" + s + "' " + this.getNodeMsg());
            return false;
        }
        if (loop.getLoopedExpression() instanceof ExprYaml) {
            this.yamlState = ((ExprYaml)loop.getLoopedExpression()).getState();
            if (!this.yamlState.equals((Object)ExprYaml.YamlState.VALUE)) {
                if (parser.mark == 7) {
                    this.loopState = LoopState.INDEX;
                } else if (parser.mark == 1) {
                    this.loopState = LoopState.ID;
                } else if (parser.mark == 2) {
                    this.loopState = LoopState.VALUE;
                } else if (parser.mark == 3) {
                    this.loopState = LoopState.LIST;
                } else if (parser.mark == 4) {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.LIST)) {
                        return this.loopStateListError(s);
                    }
                    this.loopState = LoopState.NODE;
                } else if (parser.mark == 5) {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.LIST)) {
                        return this.loopStateListError(s);
                    }
                    this.loopState = LoopState.NODE_KEY;
                } else if (parser.mark == 6) {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.LIST)) {
                        return this.loopStateListError(s);
                    }
                    this.loopState = LoopState.SUB_NODE_KEYS;
                }
            }
        } else {
            SkriptYaml.error("A 'loop-" + s + "' can only be used in a yaml expression loop ie. 'loop yaml node keys \"node\" from \"config\"' " + this.getNodeMsg());
            return false;
        }
        this.isYamlLoop = true;
        this.loop = loop;
        return true;
    }

    private boolean loopStateListError(String s) {
        SkriptYaml.error("There's no 'loop-" + s + "' in a yaml list " + this.getNodeMsg());
        return false;
    }

    private String getNodeMsg() {
        Node n = SkriptLogger.getNode();
        if (n == null) {
            return "";
        }
        return "[script: " + n.getConfig().getFileName() + ", line: " + n.getLine() + " : '" + n.save().trim() + "']";
    }

    public boolean isSingle() {
        if (this.loopState == LoopState.VALUE && this.yamlState == ExprYaml.YamlState.LIST) {
            return true;
        }
        return this.yamlState == ExprYaml.YamlState.VALUE;
    }

    @Override
    @Nullable
    protected <R> ConvertedExpression<Object, ? extends R> getConvertedExpr(final Class<R> ... to) {
        if (this.isYamlLoop && this.loopState != LoopState.INDEX) {
            Class superType = Utils.getSuperType((Class[])to);
            Converter converter = new Converter<Object, R>(){

                @Nullable
                public R convert(Object o) {
                    return Converters.convert((Object)o, (Class[])to);
                }
            };
            return SkriptYaml.getInstance().getSkriptAdapter().getConvertedExpr(this, superType, converter);
        }
        return super.getConvertedExpr(to);
    }

    public Class<? extends Object> getReturnType() {
        if (this.loopState == LoopState.INDEX) {
            return Number.class;
        }
        if (this.loopState == LoopState.ID || this.loopState == LoopState.NODE_KEY || this.loopState == LoopState.NODE) {
            return String.class;
        }
        return ((ExprYaml)this.loop.getLoopedExpression()).getReturnType(this.yamlState);
    }

    @Override
    @Nullable
    protected Object[] get(Event e) {
        if (this.isYamlLoop) {
            Object current = this.loop.getCurrent(e);
            ExprYaml yamlExpr = (ExprYaml)this.loop.getLoopedExpression();
            if (current == null) {
                return null;
            }
            switch (this.loopState) {
                case INDEX: {
                    return new Number[]{this.getIndex()};
                }
                case ID: {
                    return new String[]{yamlExpr.getId(e)};
                }
                case VALUE: {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.LIST)) {
                        return new Object[]{current};
                    }
                    String n = this.getCurrentNode(current, yamlExpr.getNode(e));
                    if (n == null) {
                        return null;
                    }
                    return yamlExpr.get(e, n, ExprYaml.YamlState.VALUE);
                }
                case LIST: {
                    String n2 = this.getCurrentNode(current, yamlExpr.getNode(e));
                    if (n2 == null) {
                        return null;
                    }
                    return yamlExpr.get(e, n2, ExprYaml.YamlState.LIST);
                }
                case NODE: {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.NODE_KEYS)) {
                        return new String[]{StringUtil.addLastNodeSeperator(yamlExpr.getNode(e)) + current};
                    }
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.NODES)) {
                        return new String[]{current.toString()};
                    }
                }
                case NODE_KEY: {
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.NODE_KEYS)) {
                        return new String[]{current.toString()};
                    }
                    if (this.yamlState.equals((Object)ExprYaml.YamlState.NODES)) {
                        return new String[]{StringUtil.stripBeforeLastNode(current.toString())};
                    }
                }
                case SUB_NODE_KEYS: {
                    String n3 = this.getCurrentNode(current, yamlExpr.getNode(e));
                    if (n3 == null) {
                        return null;
                    }
                    Object[] objects = yamlExpr.get(e, n3);
                    if (objects == null) {
                        return null;
                    }
                    return objects;
                }
            }
        }
        return null;
    }

    private String getCurrentNode(Object current, String node) {
        String key = null;
        if (this.yamlState.equals((Object)ExprYaml.YamlState.NODE_KEYS)) {
            key = StringUtil.addLastNodeSeperator(node) + current;
        } else if (this.yamlState.equals((Object)ExprYaml.YamlState.NODES)) {
            key = current.toString();
        }
        return key;
    }

    public Number getIndex() {
        try {
            Field currentIterField = this.loop.getLoopClass().getDeclaredField("currentIter");
            currentIterField.setAccessible(true);
            Field indexField = ArrayIterator.class.getDeclaredField("index");
            indexField.setAccessible(true);
            Iterator iterator = ((Map)currentIterField.get(this.loop.getObject())).values().iterator();
            if (iterator.hasNext()) {
                Iterator entry = (Iterator)iterator.next();
                return (int)((Integer)indexField.get(entry));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toString(@Nullable Event e, boolean debug) {
        if (e == null) {
            return this.name;
        }
        if (this.isYamlLoop) {
            Object current = this.loop.getCurrent(e);
            T[] objects = ((ExprYaml)this.loop.getLoopedExpression()).get(e);
            if (current == null || objects == null) {
                return Classes.getDebugMessage(null);
            }
            return this.loopState == LoopState.INDEX ? "\"" + this.getIndex() + "\"" : Classes.getDebugMessage((Object)current);
        }
        return Classes.getDebugMessage((Object)this.loop.getCurrent(e));
    }

    static {
        Skript.registerExpression(ExprLoopYaml.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] loop-(1\u00a6id|2\u00a6val|3\u00a6list|4\u00a6node|5\u00a6key|6\u00a6subnodekey[s]|7\u00a6iteration)[-%-*integer%]"});
    }

    public static enum LoopState {
        ID,
        VALUE,
        LIST,
        NODE,
        NODE_KEY,
        SUB_NODE_KEYS,
        INDEX;

    }
}

