/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.SkriptYamlUtils;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.event.Event;

@Name(value="YAML Comments/header")
@Description(value={"Gets, sets, deletes comments or the header of a cached yaml file\n  - Headers don't contain '#' so add it yourself if you want it\n  - Comments can only be at root level ie. 'root' not 'root.something'\n  - Both comment and header expressions can be set to multiple elements\n  - This expression does not save to file\n  - Option to have an extra line or not depending if you use comment or header\n  - Any 'extra lines' are removed when deleting comments/headers"})
@Examples(value={"set the comments of yaml node \"test\" from \"config\" to \"First line\" and \"Second line\"", "delete the comments of yaml node \"test\" from \"config\"", " ", "set {_header::*} to \"First line\" and \"Second line\"", "set the comments at the top of \"config\" to {_header::*}", "delete the comments at the top of \"config\"", " ", "set the header of \"config\" to {_header::*}"})
@Since(value="1.1.0")
public class ExprYamlComments
extends SimpleExpression<Object> {
    private Expression<String> paths;
    private Expression<String> file;
    private int mark;
    private SkriptNode skriptNode;
    private States state;

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return this.state.toString().toLowerCase() + (this.state == States.COMMENT ? " for path\node " + this.paths.toString(event, b) : "") + " from yaml " + this.file.toString(event, b);
    }

    @Nullable
    protected Object[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        if (!SkriptYamlUtils.yamlExists(name, this.skriptNode)) {
            return null;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        String s = null;
        if (this.state == States.COMMENT) {
            String path = (String)this.paths.getSingle(event);
            s = config.getComment(path, this.skriptNode);
        } else if (this.state == States.HEADER) {
            s = config.getHeader(this.skriptNode);
        }
        if (s == null) {
            return null;
        }
        List<String> list = Arrays.asList(s.split("\\r?\\n"));
        return list.toArray(new String[list.size()]);
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.file.getSingle(event);
        String[] paths = null;
        if (!SkriptYamlUtils.yamlExists(name, this.skriptNode)) {
            return;
        }
        YAMLProcessor config = SkriptYaml.YAML_STORE.get(name);
        if (this.state == States.COMMENT) {
            paths = (String[])this.paths.getAll(event);
            if (mode == Changer.ChangeMode.SET) {
                String[] comments = new String[delta.length];
                for (String p : paths) {
                    if (!p.contains(".")) {
                        if (config.getMap().containsKey(p)) {
                            config.setComment(p, this.mark == 1, this.toStringArray(delta, comments));
                            continue;
                        }
                        SkriptYaml.warn("'" + p + "' is not a valid path in '" + name + "' " + this.skriptNode.toString());
                        continue;
                    }
                    SkriptYaml.warn("Comments can only be added to root paths not '" + p + "' in '" + name + "' " + this.skriptNode.toString());
                }
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                for (String p : paths) {
                    if (!config.getMap().containsKey(p)) continue;
                    String n = null;
                    config.setComment(p, false, n);
                }
            }
        } else if (this.state == States.HEADER) {
            if (mode == Changer.ChangeMode.SET) {
                config.setHeader(this.toStringArray(delta, new String[delta.length]));
                config.setExtraHeaderLine(this.mark == 1);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                String n = null;
                config.setHeader(n);
                config.setExtraHeaderLine(false);
            }
        }
    }

    private String[] toStringArray(Object[] input, String[] output) {
        for (int i = 0; i < input.length; ++i) {
            output[i] = (String)input[i];
        }
        return output;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (matchedPattern == 0) {
            this.state = States.COMMENT;
            this.paths = e[0];
            this.file = e[1];
        } else {
            this.state = States.HEADER;
            this.file = e[0];
        }
        this.mark = parse.mark;
        this.skriptNode = new SkriptNode(SkriptLogger.getNode());
        return true;
    }

    static {
        Skript.registerExpression(ExprYamlComments.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] comment[s] (of|from) [y[a]ml] node[s] %strings% (of|in|from) %string% [(1\u00a6with [an] extra line)]", "[the] (comment[s] (at|on) [the] top of |header (of|from)) %string% [(1\u00a6with [an] extra line)]"});
    }

    private static enum States {
        COMMENT,
        HEADER;

    }
}

