/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.skript.functions;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.lang.function.FunctionEvent;
import ch.njol.skript.lang.function.Functions;
import ch.njol.skript.lang.function.JavaFunction;
import ch.njol.skript.lang.function.Parameter;
import ch.njol.skript.registrations.Classes;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;

public class FuncLoadYaml
extends JavaFunction<Boolean> {
    static final ClassInfo<String> stringClass;
    static final ClassInfo<Boolean> booleanClass;

    public FuncLoadYaml() {
        super("loadYaml", new Parameter[]{new Parameter("name", stringClass, true, null), new Parameter("file", stringClass, true, null), new Parameter("isRelative", booleanClass, true, null)}, booleanClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Boolean[] execute(FunctionEvent e, Object[][] params) {
        String name = (String)params[0][0];
        String file = (String)params[1][0];
        Boolean isRelative = (Boolean)params[2][0];
        File yamlFile = null;
        String server = new File("").getAbsoluteFile().getAbsolutePath() + File.separator;
        yamlFile = isRelative != false ? new File(StringUtil.checkRoot(StringUtil.checkSeparator(file))) : new File(server + StringUtil.checkSeparator(file));
        try {
            if (!yamlFile.exists()) {
                String filePath = yamlFile.getPath();
                int index = filePath.lastIndexOf(File.separator);
                File folder = new File(filePath.substring(0, index));
                if (index >= 0 && !folder.exists()) {
                    folder.mkdirs();
                }
                yamlFile.createNewFile();
            }
        }
        catch (IOException error) {
            SkriptYaml.error("[Load Yaml] " + error.getMessage() + " (" + file + ")");
            return new Boolean[]{false};
        }
        YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
        try {
            yaml.load();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            SkriptYaml.YAML_STORE.put(name, yaml);
        }
        return new Boolean[]{true};
    }

    public String toString() {
        return super.toString();
    }

    static {
        Functions.registerFunction((JavaFunction)new FuncLoadYaml()).description(new String[]{"Loads a yaml file."}).examples(new String[]{"loadYaml(\"someId\", \"plugins/someThing/someYamlFile.yml\", false)"}).since("1.3.3");
        stringClass = Classes.getExactClassInfo(String.class);
        booleanClass = Classes.getExactClassInfo(Boolean.class);
    }
}

