/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils;

import ch.njol.skript.registrations.Converters;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.StringUtil;

public class SkriptYamlUtils {
    public static boolean yamlExists(String name, SkriptNode skriptNode) {
        if (SkriptYaml.YAML_STORE.containsKey(name)) {
            return true;
        }
        SkriptYaml.warn("No yaml by the name '" + name + "' has been loaded " + skriptNode.toString());
        return false;
    }

    public static File[] directoryFilter(String name, boolean root, String errorPrefix, SkriptNode skriptNode) {
        File dir = null;
        if (root) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            String server = new File("").getAbsoluteFile().getAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.exists()) {
            SkriptYaml.warn("[" + errorPrefix + " Yaml] " + name + " does not exist! " + skriptNode.toString());
            return null;
        }
        if (!dir.isDirectory()) {
            SkriptYaml.warn("[" + errorPrefix + " Yaml] " + name + " is not a directory! " + skriptNode.toString());
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    public static <T> Class<T> getType(Class<T> c) {
        return (Class)((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public static final <T> T[] convertToArray(Object original, Class<T> to) throws ClassCastException {
        Object[] end = (Object[])Array.newInstance(to, 1);
        Object converted = Converters.convert((Object)original, to);
        if (converted == null) {
            throw new ClassCastException();
        }
        end[0] = converted;
        return end;
    }
}

