/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;

public final class StringUtil {
    private StringUtil() {
    }

    public static String replaceTabs(String text) {
        if (text.contains("\t")) {
            return text.replaceAll("\t", "    ");
        }
        return text;
    }

    public static String checkSeparator(String check) {
        if (check.contains("/")) {
            return check.replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return check;
    }

    public static String checkLastSeparator(String check) {
        if (check.contains("/")) {
            if (!check.endsWith("/")) {
                return check + "/";
            }
        } else if (check.contains("\\")) {
            if (!check.endsWith("\\")) {
                return check + "\\";
            }
        } else if (!check.contains("/") || !check.contains("\\")) {
            return check + Matcher.quoteReplacement(File.separator);
        }
        return check;
    }

    public static String removeFirst(String remove, String from) {
        if (from.startsWith(remove)) {
            return from.replace(remove, "");
        }
        return from;
    }

    public static String stripLastSeparator(String check) {
        int endIndex;
        if ((check.endsWith("/") || check.endsWith("\\")) && check.length() > 0 && (endIndex = check.lastIndexOf(File.separator)) != -1) {
            return check.substring(0, endIndex - 1);
        }
        return check;
    }

    public static String stripAfterLastSeparator(String directory) {
        int endIndex;
        if (directory != null && directory.length() > 0 && (endIndex = directory.lastIndexOf(File.separator)) != -1) {
            return directory.substring(0, endIndex);
        }
        return directory;
    }

    public static String addLastNodeSeperator(String node) {
        if (node.equals("") || node.isEmpty()) {
            return node;
        }
        return node + ".";
    }

    public static String stripBeforeLastNode(String node) {
        int endIndex;
        if (node != null && node.length() > 0 && (endIndex = node.lastIndexOf(".")) != -1) {
            return node.substring(endIndex, node.length());
        }
        return node;
    }

    public static String checkRoot(String check) {
        Path root = Paths.get("", new String[0]).normalize().toAbsolutePath().getRoot();
        if (root != null) {
            for (File r : File.listRoots()) {
                if (!check.toLowerCase().startsWith(r.getPath().toLowerCase())) continue;
                return check;
            }
            return root + check;
        }
        return File.separator + check;
    }

    public static String stripExtention(String strip) {
        int pos = strip.lastIndexOf(".");
        if (pos > 0) {
            return strip.substring(0, pos);
        }
        return strip;
    }

    public static String translateColorCodes(String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '\u00a7' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 38;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static Object parseString(Object delta, boolean parse) {
        if (delta == null) {
            return null;
        }
        if (!parse && String.class.isAssignableFrom(delta.getClass())) {
            String s = StringUtil.translateColorCodes((String)delta);
            if (s.matches("true|false|yes|no|on|off")) {
                return s.matches("true|yes|on");
            }
            if (s.matches("(-)?\\d+")) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else {
                if (s.matches("(-)?\\d+(\\.\\d+)")) {
                    return Double.parseDouble(s);
                }
                return s;
            }
        }
        return delta;
    }

    public static String trimLength(String str, int len) {
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    public static String joinString(String[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex]);
        for (int i = initialIndex + 1; i < str.length; ++i) {
            buffer.append(delimiter).append(str[i]);
        }
        return buffer.toString();
    }

    public static String joinQuotedString(String[] str, String delimiter, int initialIndex, String quote) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(quote);
        buffer.append(str[initialIndex]);
        buffer.append(quote);
        for (int i = initialIndex + 1; i < str.length; ++i) {
            buffer.append(delimiter).append(quote).append(str[i]).append(quote);
        }
        return buffer.toString();
    }

    public static String joinString(String[] str, String delimiter) {
        return StringUtil.joinString(str, delimiter, 0);
    }

    public static String joinString(Object[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(str[initialIndex].toString());
        for (int i = initialIndex + 1; i < str.length; ++i) {
            buffer.append(delimiter).append(str[i]);
        }
        return buffer.toString();
    }

    public static String joinString(int[] str, String delimiter, int initialIndex) {
        if (str.length == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(Integer.toString(str[initialIndex]));
        for (int i = initialIndex + 1; i < str.length; ++i) {
            buffer.append(delimiter).append(Integer.toString(str[i]));
        }
        return buffer.toString();
    }

    public static String joinString(Collection<?> str, String delimiter, int initialIndex) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        for (Object o : str) {
            if (i >= initialIndex) {
                if (i > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(o);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char tj = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == tj ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    public static <T extends Enum<?>> T lookup(Map<String, T> lookup, String name, boolean fuzzy) {
        String testName = name.replaceAll("[ _]", "").toLowerCase();
        Enum type = (Enum)lookup.get(testName);
        if (type != null) {
            return (T)type;
        }
        if (!fuzzy) {
            return null;
        }
        int minDist = -1;
        for (Map.Entry<String, T> entry : lookup.entrySet()) {
            int dist;
            String key = entry.getKey();
            if (key.charAt(0) != testName.charAt(0) || (dist = StringUtil.getLevenshteinDistance(key, testName)) >= minDist && minDist != -1 || dist >= 2) continue;
            minDist = dist;
            type = (Enum)entry.getValue();
        }
        return (T)type;
    }
}

