/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils.yaml;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.skript.ExprYaml;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLNode;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessor;
import org.bukkit.ChatColor;

public class YAMLAPI {
    public static final HashMap<String, YAMLProcessor> YAML_STORE = new HashMap();

    public static void load(String id, String file) {
        YAMLAPI.load(file, id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromDefault(String id, String path, String defaultYamlFile) {
        InputStream stream = null;
        try {
            stream = YAMLAPI.class.getResource(defaultYamlFile + ".yml").openStream();
            Files.copy(stream, Paths.get(path, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        YAMLAPI.load(id, path + File.separator + defaultYamlFile + ".yml", false);
    }

    public static void load(String id, String file, boolean root) {
        String name = StringUtil.checkSeparator(file);
        File yamlFile = null;
        if (root) {
            yamlFile = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            yamlFile = new File(server + File.separator + name);
        }
        YAMLAPI.load(id, yamlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String id, File yamlFile) {
        try {
            if (!yamlFile.exists()) {
                String filePath = yamlFile.getPath();
                int index = filePath.lastIndexOf(File.separator);
                File folder = new File(filePath.substring(0, index));
                if (index >= 0 && !folder.exists()) {
                    folder.mkdirs();
                }
                yamlFile.createNewFile();
            }
        }
        catch (IOException error) {
            SkriptYaml.error("[Load Yaml] " + error.getMessage() + " (" + yamlFile.getName() + ")");
            return;
        }
        YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
        try {
            yaml.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (id.equals("")) {
                YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
            } else {
                YAML_STORE.put(id, yaml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDir(String directory, boolean useFileAsID, boolean root) {
        File[] files;
        String name = StringUtil.checkSeparator(directory);
        File dir = null;
        if (root) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            SkriptYaml.warn("[Load Yaml] " + name + " is not a directory!");
            return;
        }
        for (File yamlFile : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        })) {
            YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
            try {
                yaml.load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (useFileAsID) {
                    YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                } else {
                    YAML_STORE.put(StringUtil.checkLastSeparator(name) + yamlFile.getName(), yaml);
                }
            }
        }
    }

    public static void save(String id) {
        YAMLProcessor yaml = YAMLAPI.get(id);
        yaml.save(true);
    }

    public static String[] loadedYamlNames() {
        if (YAML_STORE.isEmpty()) {
            return null;
        }
        return YAML_STORE.keySet().toArray(new String[YAML_STORE.keySet().size()]);
    }

    public static YAMLProcessor get(String id) {
        if (!YAML_STORE.containsKey(id)) {
            SkriptYaml.warn("No yaml by the name '" + id + "' has been loaded");
            return null;
        }
        return YAML_STORE.get(id);
    }

    public static boolean isLoaded(String id) {
        return YAML_STORE.containsKey(id);
    }

    public static boolean isEmpty(String id) {
        return YAML_STORE.get(id).getAllKeys().isEmpty();
    }

    public static boolean hasValue(String id, String path) {
        return YAML_STORE.get(id).getProperty(path) != null;
    }

    public static Object getValue(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        Object o = config.getProperty(path);
        if (o != null) {
            if (String.class.isAssignableFrom(o.getClass())) {
                o = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)o));
            }
            return o;
        }
        return null;
    }

    public static List<String> getNodes(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        ArrayList<String> keys = new ArrayList<String>();
        if (path.equals("")) {
            Set<String> rootNodes = config.getMap().keySet();
            keys.addAll(rootNodes);
            return keys;
        }
        YAMLNode node = config.getNode(path);
        if (node == null) {
            return null;
        }
        Map<String, Object> nodes = node.getMap();
        for (String key : nodes.keySet()) {
            keys.add(path + "." + key);
        }
        return keys;
    }

    public static List<String> getNodeKeys(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<String> nodesKeys = config.getKeys(path);
        if (nodesKeys == null) {
            return null;
        }
        return nodesKeys;
    }

    public static <T> List<T> getList(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<Object> items = config.getList(path);
        if (items == null) {
            return null;
        }
        return items;
    }

    public static Object getWithState(String id, String path, ExprYaml.YamlState state) {
        YAMLProcessor config = YAMLAPI.get(id);
        if (state == ExprYaml.YamlState.VALUE) {
            Object o = config.getProperty(path);
            if (o != null) {
                if (String.class.isAssignableFrom(o.getClass())) {
                    o = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)o));
                }
                return o;
            }
            return null;
        }
        if (state == ExprYaml.YamlState.NODES) {
            if (path.equals("")) {
                Set<String> rootNodes = config.getMap().keySet();
                return rootNodes;
            }
            YAMLNode node = config.getNode(path);
            if (node == null) {
                return null;
            }
            Map<String, Object> nodes = node.getMap();
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : nodes.keySet()) {
                keys.add(path + "." + key);
            }
            return keys;
        }
        if (state == ExprYaml.YamlState.NODE_KEYS) {
            List<String> nodesKeys = config.getKeys(path);
            if (nodesKeys == null) {
                return null;
            }
            return nodesKeys;
        }
        if (state == ExprYaml.YamlState.LIST) {
            List<Object> items = config.getList(path);
            if (items == null) {
                return null;
            }
            return items;
        }
        return null;
    }

    public static void removeNode(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        config.removeProperty(path);
    }

    public static void setValue(String id, String path, Object delta) {
        YAMLProcessor config = YAMLAPI.get(id);
        config.setProperty(path, delta);
    }

    public static void addNodeKeys(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        config.addNode(path);
    }

    public static void removeNodeKeys(String id, String path) {
        YAMLProcessor config = YAMLAPI.get(id);
        config.setProperty(path, null);
    }

    public static void addToList(String id, String path, Object delta) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<Object> objects = config.getList(path);
        if (delta.getClass().isAssignableFrom(List.class)) {
            if (objects == null) {
                config.setProperty(path, delta);
            } else {
                objects.addAll((List)delta);
                config.setProperty(path, objects);
            }
        } else {
            if (objects == null) {
                objects = new ArrayList<Object>();
            }
            objects.add(delta);
            config.setProperty(path, objects);
        }
    }

    public static void removeFromList(String id, String path, Object delta) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<Object> objects = config.getList(path);
        objects.remove(delta);
    }

    public static void removeFromList(String id, String path, Object[] delta) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<Object> objects = config.getList(path);
        for (Object o : delta) {
            objects.remove(o);
        }
    }

    public static <T> void setList(String id, String path, List<T> delta) {
        YAMLProcessor config = YAMLAPI.get(id);
        List<Object> objects = config.getList(path);
        if (objects == null) {
            config.setProperty(path, delta);
        } else {
            objects.clear();
            objects.addAll(delta);
            config.setProperty(path, objects);
        }
    }

    public static void setWithState(String id, String path, List<Object> delta, ExprYaml.YamlState state, ChangeMode mode) {
        YAMLProcessor config = YAMLAPI.get(id);
        if (mode == ChangeMode.DELETE || mode == ChangeMode.RESET) {
            config.removeProperty(path);
            return;
        }
        if (state == ExprYaml.YamlState.VALUE) {
            if (mode == ChangeMode.SET) {
                config.setProperty(path, delta);
            }
        } else if (state == ExprYaml.YamlState.NODE_KEYS) {
            if (mode == ChangeMode.ADD) {
                config.addNode(path);
            } else if (mode == ChangeMode.REMOVE) {
                config.setProperty(path, null);
            }
        } else if (state == ExprYaml.YamlState.LIST) {
            List<Object> objects = config.getList(path);
            if (mode == ChangeMode.ADD) {
                if (objects == null) {
                    config.setProperty(path, delta);
                } else {
                    objects.addAll(delta);
                    config.setProperty(path, objects);
                }
            } else if (mode == ChangeMode.REMOVE) {
                for (Object o : delta) {
                    objects.remove(o);
                }
            } else if (mode == ChangeMode.SET) {
                if (objects == null) {
                    config.setProperty(path, delta);
                } else {
                    objects.clear();
                    objects.addAll(delta);
                    config.setProperty(path, objects);
                }
            }
        }
    }

    public static enum ChangeMode {
        DELETE,
        RESET,
        SET,
        ADD,
        REMOVE;

    }
}

