/*
 * Decompiled with CFR 0.152.
 */
package me.sashie.skriptyaml.utils.yaml;

import ch.njol.skript.registrations.Classes;
import ch.njol.skript.variables.SerializedVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import me.sashie.skriptyaml.SkriptYaml;
import me.sashie.skriptyaml.debug.SkriptNode;
import me.sashie.skriptyaml.utils.StringUtil;
import me.sashie.skriptyaml.utils.yaml.SkriptClass;
import me.sashie.skriptyaml.utils.yaml.SkriptYamlRepresenter;
import me.sashie.skriptyaml.utils.yaml.YAMLComment;
import me.sashie.skriptyaml.utils.yaml.YAMLFormat;
import me.sashie.skriptyaml.utils.yaml.YAMLNode;
import me.sashie.skriptyaml.utils.yaml.YAMLProcessorException;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class YAMLProcessor
extends YAMLNode {
    public static final String LINE_BREAK = DumperOptions.LineBreak.getPlatformLineBreak().getString();
    public static final char COMMENT_CHAR = '#';
    private static final String COMMENT_PREFIX = "# ";
    private static final String HEADER_PREFIX = "## ";
    protected final Yaml yaml;
    protected final File file;
    protected String id;
    private StringBuilder builder;
    protected String header = null;
    protected boolean extraHeaderLine;
    protected YAMLFormat format;
    private final Map<String, YAMLComment> comments = new HashMap<String, YAMLComment>();

    public YAMLProcessor(File file, boolean writeDefaults, YAMLFormat format) {
        super(new LinkedHashMap<String, Object>(), writeDefaults);
        this.format = format;
        FancyDumperOptions options = new FancyDumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(format.getStyle());
        options.setTimeZone(TimeZone.getDefault());
        options.setSplitLines(false);
        SkriptYamlRepresenter representer = SkriptYaml.getInstance().getRepresenter();
        representer.setDefaultFlowStyle(format.getStyle());
        this.yaml = new Yaml((BaseConstructor)SkriptYaml.getInstance().getConstructor(), (Representer)representer, (DumperOptions)options);
        this.file = file;
    }

    public YAMLProcessor(File file, boolean writeDefaults) {
        this(file, writeDefaults, YAMLFormat.COMPACT);
    }

    public void oldLoad() throws IOException {
        InputStream stream = null;
        try {
            stream = this.getInputStream();
            if (stream == null) {
                throw new IOException("Stream is null!");
            }
            this.read(this.yaml.load((Reader)new UnicodeReader(stream)));
        }
        catch (YAMLProcessorException e) {
            this.root = new LinkedHashMap();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        InputStream stream = null;
        BufferedReader input = null;
        this.builder = new StringBuilder();
        try {
            stream = this.getInputStream();
            if (stream == null) {
                throw new IOException("Stream is null!");
            }
            input = new BufferedReader((Reader)new UnicodeReader(stream));
            ArrayList<String> lines = new ArrayList<String>();
            String line = input.readLine();
            while (line != null) {
                this.buildYaml(line);
                if (line.startsWith(HEADER_PREFIX)) {
                    this.recursiveHeaderSearch(line, lines, input);
                } else if (line.startsWith(COMMENT_PREFIX)) {
                    this.recursiveCommentSearch(line, lines, input);
                }
                line = input.readLine();
            }
            try {
                this.read(this.yaml.load(this.builder.toString()));
            }
            catch (ConstructorException e) {
                SkriptYaml.error("[Load Yaml] Snakeyaml " + e.getProblem() + " in file '" + this.file.getAbsolutePath() + "'");
            }
        }
        catch (YAMLProcessorException e) {
            this.root = new LinkedHashMap();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void buildYaml(String line) {
        this.builder.append(line);
        this.builder.append(LINE_BREAK);
    }

    private void recursiveHeaderSearch(String line, List<String> header, BufferedReader input) {
        if (line != null && line.startsWith(HEADER_PREFIX)) {
            header.add(line.replaceFirst(HEADER_PREFIX, ""));
            try {
                line = input.readLine();
                this.buildYaml(line);
                this.recursiveHeaderSearch(line, header, input);
            }
            catch (IOException iOException) {}
        } else if (!line.startsWith(HEADER_PREFIX)) {
            this.setHeader(header.toArray(new String[header.size()]));
            header.clear();
        }
    }

    private void recursiveCommentSearch(String line, List<String> comment, BufferedReader input) {
        if (line != null && line.startsWith(COMMENT_PREFIX)) {
            comment.add(line.replaceFirst(COMMENT_PREFIX, ""));
            try {
                line = input.readLine();
                this.buildYaml(line);
                this.recursiveCommentSearch(line, comment, input);
            }
            catch (IOException iOException) {}
        } else if (line != null && !line.startsWith(COMMENT_PREFIX) || !line.startsWith(HEADER_PREFIX) || !line.isEmpty() && line.contains(":")) {
            String l = line.split(":")[0];
            if (!l.startsWith(" ")) {
                this.setComment(l, false, comment.toArray(new String[comment.size()]));
            }
            comment.clear();
        } else {
            comment.clear();
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder header = new StringBuilder();
        for (String line : headerLines) {
            if (header.length() > 0) {
                header.append(LINE_BREAK);
            }
            if (line.startsWith("#")) {
                header.append("#");
            } else {
                header.append(HEADER_PREFIX);
            }
            header.append(StringUtil.replaceTabs(line));
        }
        this.setHeader(header.toString());
    }

    public void setHeader(String header) {
        if (header == null) {
            this.header = null;
            return;
        }
        this.header = StringUtil.replaceTabs(header);
    }

    public String getHeader(SkriptNode skriptNode) {
        if (this.header != null) {
            return this.header;
        }
        SkriptYaml.warn("No header found in yaml '" + this.file.getAbsolutePath() + "' " + skriptNode.toString());
        return null;
    }

    public void setExtraHeaderLine(boolean extraHeaderLine) {
        this.extraHeaderLine = extraHeaderLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(boolean extraLines) {
        block30: {
            boolean bl;
            OutputStream stream = null;
            File parent = this.file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try {
                stream = this.getOutputStream();
                if (stream == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                if (this.header != null) {
                    writer.append(this.header);
                    writer.append(LINE_BREAK);
                    if (this.extraHeaderLine) {
                        writer.append(LINE_BREAK);
                    }
                }
                String firstKey = "";
                if (!this.root.keySet().isEmpty()) {
                    firstKey = this.root.keySet().toArray(new String[this.root.size()])[0];
                }
                if (this.comments.isEmpty() || this.format != YAMLFormat.EXTENDED) {
                    if (extraLines && this.header != null) {
                        writer.append(LINE_BREAK);
                    }
                    for (Map.Entry entry : this.root.entrySet()) {
                        if (extraLines && !((String)entry.getKey()).equals(firstKey)) {
                            writer.append(LINE_BREAK);
                        }
                        this.yaml.dump(Collections.singletonMap((String)entry.getKey(), this.serialize(entry.getValue())), (Writer)writer);
                    }
                } else {
                    if (extraLines && this.header != null) {
                        writer.append(LINE_BREAK);
                    }
                    for (Map.Entry entry : this.root.entrySet()) {
                        YAMLComment comment;
                        if (extraLines && !((String)entry.getKey()).equals(firstKey)) {
                            writer.append(LINE_BREAK);
                        }
                        if ((comment = this.comments.get(entry.getKey())) != null) {
                            if (comment.hasExtraLine()) {
                                writer.append(LINE_BREAK);
                            }
                            writer.append(comment.getComment());
                            writer.append(LINE_BREAK);
                        }
                        this.yaml.dump(Collections.singletonMap((String)entry.getKey(), this.serialize(entry.getValue())), (Writer)writer);
                    }
                }
                bl = true;
            }
            catch (IOException iOException) {
                break block30;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return bl;
        }
        return false;
    }

    private Object serialize(Object value) {
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                ((Map)value).replace((String)entry.getKey(), entry.getValue(), this.serialize(entry.getValue()));
            }
            return value;
        }
        if (value instanceof List) {
            for (int i = 0; i < ((List)value).size(); ++i) {
                ((List)value).set(i, this.serialize(((List)value).get(i)));
            }
            return value;
        }
        if (!(SkriptYamlRepresenter.contains(value) || value instanceof ConfigurationSerializable || value instanceof Number || value instanceof Map || value instanceof List)) {
            SerializedVariable.Value val = Classes.serialize((Object)value);
            if (val == null) {
                return null;
            }
            if (val.type.equals("itemstack")) {
                return Classes.deserialize((String)val.type, (byte[])val.data);
            }
            return new SkriptClass(val.type, val.data);
        }
        return value;
    }

    private void recursiveKeySearch(String path, Object o) {
        this.allKeys.add(path);
        for (Map.Entry entry : ((Map)o).entrySet()) {
            this.allKeys.add(path + "." + (String)entry.getKey());
            if (!(entry.getValue() instanceof Map)) continue;
            this.recursiveKeySearch(path + "." + (String)entry.getKey(), entry.getValue());
        }
    }

    private Object rootKeysToString(Object input) {
        if (input instanceof Map) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : ((Map)input).entrySet()) {
                map.put(entry.getKey().toString(), this.rootKeysToString(entry.getValue()));
            }
            return map;
        }
        return input;
    }

    private void read(Object input) throws YAMLProcessorException {
        try {
            if (input == null) {
                this.root = new LinkedHashMap();
            } else {
                this.root = new LinkedHashMap((Map)this.rootKeysToString(input));
                for (String path : this.root.keySet()) {
                    Object o = this.getProperty(path);
                    if (o == null) continue;
                    if (o instanceof Map) {
                        this.recursiveKeySearch(path, o);
                        continue;
                    }
                    this.allKeys.add(path);
                }
            }
        }
        catch (ClassCastException e) {
            throw new YAMLProcessorException("Root document must be a key-value structure");
        }
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getParentPath() {
        return this.file.getParent();
    }

    public String getComment(String key, SkriptNode skriptNode) {
        if (this.comments.containsKey(key)) {
            return this.comments.get(key).getComment();
        }
        SkriptYaml.warn("No comment found at '" + key + "' in yaml " + this.file.getAbsolutePath() + " " + skriptNode.toString());
        return null;
    }

    public void setComment(String key, boolean extraLine, String comment) {
        if (comment != null) {
            this.setComment(key, extraLine, comment.split("\\r?\\n"));
        } else {
            this.comments.remove(key);
        }
    }

    public void setComment(String key, boolean extraLine, String ... comment) {
        if (comment != null && comment.length > 0) {
            for (int i = 0; i < comment.length; ++i) {
                if (comment[i].matches("^# ?")) continue;
                comment[i] = COMMENT_PREFIX + comment[i];
            }
            String s = StringUtil.joinString(comment, LINE_BREAK);
            this.comments.put(key, new YAMLComment(StringUtil.replaceTabs(s), extraLine));
        } else {
            this.comments.remove(key);
        }
    }

    public Map<String, YAMLComment> getComments() {
        return Collections.unmodifiableMap(this.comments);
    }

    public void setComments(Map<String, YAMLComment> comments) {
        this.comments.clear();
        if (comments != null) {
            this.comments.putAll(comments);
        }
    }

    public static YAMLNode getEmptyNode(boolean writeDefaults) {
        return new YAMLNode(new LinkedHashMap<String, Object>(), writeDefaults);
    }

    public void setIndent(int indent) {
        try {
            Field dumperOptions = this.yaml.getClass().getDeclaredField("dumperOptions");
            dumperOptions.setAccessible(true);
            DumperOptions dump = (DumperOptions)dumperOptions.get(this.yaml);
            try {
                dump.setIndent(indent);
            }
            catch (YAMLException ex) {
                SkriptYaml.warn(ex.getMessage());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }

    private class FancyDumperOptions
    extends DumperOptions {
        private FancyDumperOptions() {
        }

        public void setDefaultScalarStyle(DumperOptions.ScalarStyle defaultStyle) {
            super.setDefaultScalarStyle(DumperOptions.ScalarStyle.LITERAL);
        }
    }
}

