/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.GsonService;
import by.gdev.http.download.service.HttpService;
import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonServiceImpl
implements GsonService {
    private static final Logger log = LoggerFactory.getLogger(GsonServiceImpl.class);
    private Gson gson;
    private FileCacheService fileService;
    private HttpService httpService;

    @Override
    public <T> T getObject(String url, Class<T> class1, boolean cache) throws IOException, NoSuchAlgorithmException {
        Path pathFile = this.fileService.getRawObject(url, cache);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(pathFile.toFile()), StandardCharsets.UTF_8);){
            T t = this.gson.fromJson((Reader)read, class1);
            return t;
        }
    }

    @Override
    public <T> T getObjectByUrls(List<String> urls, String urn, Class<T> class1, boolean cache) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        T returnValue = null;
        for (String url : urls) {
            try {
                Path pathFile = this.fileService.getRawObject(url + urn, cache);
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(pathFile.toFile()), StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    returnValue = this.gson.fromJson((Reader)read, class1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (read == null) continue;
                    if (throwable != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    read.close();
                }
            }
            catch (IOException e) {
                log.error("Error = " + e.getMessage());
            }
        }
        return returnValue;
    }

    @Override
    public <T> T getObjectWithoutSaving(String url, Class<T> class1) throws IOException {
        return this.getObjectWithoutSaving(url, class1, null);
    }

    @Override
    public <T> T getObjectWithoutSaving(String url, Type type) throws IOException {
        return this.getObjectWithoutSaving(url, type, null);
    }

    @Override
    public <T> T getObjectWithoutSaving(String url, Class<T> class1, Map<String, String> headers) throws IOException {
        return this.gson.fromJson(this.httpService.getRequestByUrl(url, headers), class1);
    }

    @Override
    public <T> T getObjectWithoutSaving(String url, Type type, Map<String, String> headers) throws IOException {
        return this.gson.fromJson(this.httpService.getRequestByUrl(url, headers), type);
    }

    @Override
    public <T> T getLocalObject(List<String> uris, Class<T> class1) throws IOException, NoSuchAlgorithmException {
        Path pathFile = this.fileService.getRawObject(uris);
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(pathFile.toFile()), StandardCharsets.UTF_8);){
            T t = this.gson.fromJson((Reader)read, class1);
            return t;
        }
    }

    public GsonServiceImpl(Gson gson, FileCacheService fileService, HttpService httpService) {
        this.gson = gson;
        this.fileService = fileService;
        this.httpService = httpService;
    }
}

