/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.launcher.versions.ReleaseType;
import org.tlauncher.tlauncher.configuration.InnerConfiguration;
import org.tlauncher.tlauncher.configuration.enums.ActionOnLaunch;
import org.tlauncher.tlauncher.configuration.enums.BackupSetting;
import org.tlauncher.tlauncher.configuration.enums.ConnectionQuality;
import org.tlauncher.tlauncher.configuration.enums.ConsoleType;
import org.tlauncher.tlauncher.updater.client.Notices;
import org.tlauncher.util.IntegerArray;
import org.tlauncher.util.MinecraftUtil;
import org.tlauncher.util.OS;

class ConfigurationDefaults {
    private static final int version = 3;
    private final Map<String, Object> d = new HashMap<String, Object>();

    ConfigurationDefaults(InnerConfiguration inner) {
        this.d.put("settings.version", 3);
        this.d.put("minecraft.gamedir", MinecraftUtil.getDefaultWorkingDirectory().getAbsolutePath());
        this.d.put("minecraft.size", new IntegerArray(925, 530));
        this.d.put("minecraft.fullscreen", false);
        for (ReleaseType releaseType : ReleaseType.getDefault()) {
            this.d.put("minecraft.versions." + releaseType.name().toLowerCase(), true);
        }
        for (ReleaseType.SubType subType : ReleaseType.SubType.getDefault()) {
            this.d.put("minecraft.versions.sub." + subType.name().toLowerCase(), true);
        }
        for (Iterator<Enum> iterator : Notices.NoticeType.values()) {
            if (!((Notices.NoticeType)((Object)iterator)).isAdvert()) continue;
            this.d.put("gui.notice." + ((Enum)((Object)iterator)).name().toLowerCase(), true);
        }
        this.d.put("minecraft.memory.ram2", OS.Arch.PREFERRED_MEMORY);
        this.d.put("minecraft.onlaunch", (Object)ActionOnLaunch.getDefault());
        this.d.put("gui.console", (Object)ConsoleType.getDefault());
        this.d.put("gui.console.width", 720);
        this.d.put("gui.console.height", 500);
        this.d.put("gui.console.x", 30);
        this.d.put("gui.console.y", 30);
        this.d.put("connection", (Object)ConnectionQuality.getDefault());
        this.d.put("client", UUID.randomUUID());
        this.d.put("gui.statistics.checkbox", false);
        this.d.put("gui.discord.checkbox", true);
        this.d.put("gui.settings.guard.checkbox", true);
        this.d.put("gui.settings.servers.recommendation", true);
        this.d.put("gui.settings.servers.recommendation", true);
        this.d.put(BackupSetting.FREE_PARTITION_SIZE.toString(), inner.getInteger(BackupSetting.FREE_PARTITION_SIZE.toString()));
        this.d.put(BackupSetting.SKIP_USER_BACKUP.toString(), inner.getBoolean(BackupSetting.SKIP_USER_BACKUP.toString()));
        this.d.put(BackupSetting.MAX_TIME_FOR_BACKUP.toString(), inner.getInteger(BackupSetting.MAX_TIME_FOR_BACKUP.toString()));
        this.d.put(BackupSetting.REPEAT_BACKUP.toString(), inner.getInteger(BackupSetting.REPEAT_BACKUP.toString()));
        this.d.put(BackupSetting.MAX_SIZE_FOR_WORLD.toString(), inner.getInteger(BackupSetting.MAX_SIZE_FOR_WORLD.toString()));
    }

    public static int getVersion() {
        return 3;
    }

    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.d);
    }

    public Object get(String key) {
        return this.d.get(key);
    }
}

