/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.minecraft.launcher.assitent;

import com.google.inject.Inject;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.tlauncher.configuration.MinecraftGameLanguageMap;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.MinecraftLauncherAssistantWrapper;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.U;

public class LanguageAssistance
extends MinecraftLauncherAssistantWrapper {
    public static String OPTIONS = "options.txt";
    @Inject
    private MinecraftGameLanguageMap gameLanguageMap;

    @Override
    public void constructProgramArguments(MinecraftLauncher launcher) {
        CompleteVersion v = launcher.getVersion();
        Date date = v.getReleaseTime();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            Date checkDate = format.parse("2016-11-14");
            File gameFolder = launcher.getRunningMinecraftDir();
            File options = new File(gameFolder, OPTIONS);
            if (options.exists()) {
                List<String> lines = Files.readAllLines(options.toPath(), StandardCharsets.UTF_8);
                int index = -1;
                for (int i = 0; i < lines.size(); ++i) {
                    if (!lines.get(i).contains("lang:")) continue;
                    index = i;
                    break;
                }
                if (index != -1 && (date.before(checkDate) || lines.get(index).length() == 7)) {
                    lines.remove(index);
                    lines.add(index, this.getLang(date, checkDate));
                    FileUtil.writeFile(options, String.join((CharSequence)System.lineSeparator(), lines));
                } else if (index == -1) {
                    String lang = this.getLang(date, checkDate);
                    lines.add(lang);
                    FileUtil.writeFile(options, String.join((CharSequence)System.lineSeparator(), lines));
                }
            } else {
                String lang = this.getLang(date, checkDate);
                FileUtil.writeFile(options, lang);
            }
        }
        catch (Throwable e) {
            U.log(e);
        }
    }

    private String getLang(Date date, Date checkDate) {
        String lang = this.gameLanguageMap.getOrDefault(Localizable.get().getSelected().toString(), "en_US");
        if (date.after(checkDate)) {
            lang = lang.toLowerCase(Locale.ROOT);
        }
        return "lang:" + lang;
    }
}

