/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.site.play;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.KeyStore;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import net.minecraft.launcher.Http;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.tlauncher.entity.ServerCommandEntity;
import org.tlauncher.tlauncher.entity.server.SiteServer;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.util.U;

@Singleton
public class SitePlay
implements VersionManagerListener {
    private boolean status = false;
    @Inject
    private TLauncher tLauncher;
    @Inject
    private ModpackManager manager;

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        this.init();
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        this.init();
    }

    private synchronized void init() {
        if (this.status) {
            return;
        }
        this.status = true;
        Thread th = new Thread(new Runnable(){

            @Override
            public void run() {
                String[] ports;
                for (String port : ports = TLauncher.getInnerSettings().getArray("local.ports.client.play")) {
                    try {
                        SSLContext sc = SitePlay.this.createSSLContext();
                        SSLServerSocketFactory ssf = sc.getServerSocketFactory();
                        SSLServerSocket s = (SSLServerSocket)ssf.createServerSocket(Integer.valueOf(port));
                        s.setEnabledCipherSuites(sc.getServerSocketFactory().getSupportedCipherSuites());
                        U.log("run server on ", port);
                        while (true) {
                            try {
                                while (true) {
                                    SSLSocket socket;
                                    ServerCommandEntity res;
                                    if ((res = Http.readRequestInfo(socket = (SSLSocket)s.accept())).getRequestType().equals("OPTIONS")) {
                                        continue;
                                    }
                                    if (res.getUrn().equals("/")) {
                                        SitePlay.this.runGameWithServer(res);
                                        continue;
                                    }
                                    if (!res.getUrn().startsWith("/open/modpack/element")) continue;
                                    CompletableFuture.runAsync(() -> SitePlay.this.manager.openModpackElement(Long.valueOf(res.getQueries().get("id")), GameType.create(res.getQueries().get("type"))));
                                }
                            }
                            catch (IOException e) {
                                U.log(e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        U.log(e);
                    }
                }
            }
        });
        th.setDaemon(true);
        th.start();
    }

    private SSLContext createSSLContext() throws Exception {
        char[] ksPass = "test123123".toCharArray();
        char[] ctPass = "test123123".toCharArray();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(TLauncher.class.getResource("/play_game_server").openStream(), ksPass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(ks, ctPass);
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(kmf.getKeyManagers(), null, null);
        return sc;
    }

    private void runGameWithServer(ServerCommandEntity res) {
        SiteServer siteServer = new Gson().fromJson(res.getBody(), SiteServer.class);
        this.tLauncher.getFrame().setAlwaysOnTop(true);
        this.tLauncher.getFrame().setAlwaysOnTop(false);
        this.tLauncher.getFrame().mp.defaultScene.loginForm.startLauncher(siteServer);
    }
}

