/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.accounts;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.tlauncher.tlauncher.minecraft.auth.Account;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.ui.accounts.UsernameField;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.Blockable;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.listener.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableRadioButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.scenes.AccountEditorScene;
import org.tlauncher.tlauncher.ui.swing.CheckBoxListener;
import org.tlauncher.tlauncher.ui.swing.FlexibleEditorPanel;
import org.tlauncher.tlauncher.ui.text.ExtendedPasswordField;
import org.tlauncher.util.SwingUtil;

public class AccountEditor
extends BlockablePanel
implements AuthenticatorListener {
    private static final String passlock = "passlock";
    private final AccountEditorScene scene;
    public final UsernameField username;
    public final BlockablePasswordField password;
    public final ButtonGroup authGroup;
    public final ButtonGroup skinGroup;
    public final UpdaterButton save;
    public final LinkedHashMap<Account.AccountType, AuthTypeRadio> radioMap;
    public final AuthTypeRadio mojangAuth;
    public final AuthTypeRadio tlauncherAuth;
    public final AuthTypeRadio microsoftAuth;
    public final AuthTypeRadio freeAuth;
    public static final Color FIELD_COLOR = new Color(149, 149, 149);
    public final LocalizableRadioButton tlSkin;
    public final LocalizableRadioButton offSkin;
    private final FlexibleEditorPanel flex;
    private final JProgressBar bar = new JProgressBar();
    private String saveString = "save";
    private String barString = "bar";
    private CardLayout cl;
    private JPanel cPanel;

    public AccountEditor(final AccountEditorScene sc, FlexibleEditorPanel flex) {
        this.setDoubleBuffered(false);
        this.setLayout(new BoxLayout(this, 1));
        this.bar.setIndeterminate(true);
        this.skinGroup = new ButtonGroup();
        LocalizableLabel titleSkinLabel = new LocalizableLabel("account.current");
        titleSkinLabel.setForeground(Color.BLACK);
        this.tlSkin = new LocalizableRadioButton("skins.tlauncher");
        this.tlSkin.setForeground(Color.BLACK);
        this.offSkin = new LocalizableRadioButton("skins.official");
        this.offSkin.setForeground(Color.BLACK);
        this.tlSkin.setSelected(true);
        this.skinGroup.add(this.tlSkin);
        this.skinGroup.add(this.offSkin);
        SwingUtil.setFontSize(this.tlSkin, 14.0f, 1);
        SwingUtil.setFontSize(this.offSkin, 14.0f, 1);
        this.scene = sc;
        this.flex = flex;
        this.username = new UsernameField(new CenterPanel(), UsernameField.UsernameState.EMAIL);
        EmptyBorder empty = new EmptyBorder(0, 9, 0, 0);
        CompoundBorder border = new CompoundBorder(BorderFactory.createLineBorder(FIELD_COLOR, 1), empty);
        this.username.setBorder(border);
        this.username.setForeground(FIELD_COLOR);
        SwingUtil.setFontSize(this.username, 14.0f);
        this.password = new BlockablePasswordField();
        this.password.setBorder(border);
        this.password.setEnabled(false);
        this.password.setForeground(FIELD_COLOR);
        SwingUtil.setFontSize(this.password, 14.0f);
        this.authGroup = new ButtonGroup();
        this.radioMap = new LinkedHashMap();
        this.mojangAuth = new AuthTypeRadio(Account.AccountType.MOJANG);
        this.tlauncherAuth = new AuthTypeRadio(Account.AccountType.TLAUNCHER);
        this.microsoftAuth = new AuthTypeRadio(Account.AccountType.MICROSOFT);
        this.freeAuth = new AuthTypeRadio(Account.AccountType.FREE);
        SwingUtil.setFontSize(this.mojangAuth, 14.0f, 1);
        SwingUtil.setFontSize(this.tlauncherAuth, 14.0f, 1);
        SwingUtil.setFontSize(this.microsoftAuth, 14.0f, 1);
        SwingUtil.setFontSize(this.freeAuth, 14.0f, 1);
        SwingUtil.setFontSize(titleSkinLabel, 14.0f, 1);
        this.save = new UpdaterButton(UpdaterButton.GREEN_COLOR, UpdaterButton.DARK_GREEN_COLOR, "account.save");
        this.save.setFont(this.save.getFont().deriveFont(1, 16.0f));
        this.save.setForeground(Color.WHITE);
        this.save.addActionListener(e -> {
            Account acc = this.get();
            if (acc.getUsername() == null && !acc.getType().equals((Object)Account.AccountType.MICROSOFT)) {
                Alert.showLocError("auth.error.email.account");
                return;
            }
            if (acc.getAccessToken() == null && acc.getPassword() == null && !acc.getType().equals((Object)Account.AccountType.FREE)) {
                Alert.showLocError("auth.error.nopass");
                return;
            }
            Authenticator.authenticate(acc, this);
        });
        this.microsoftAuth.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && AccountEditor.this.microsoftAuth.isEnabled()) {
                    sc.getMainPane().setScene(sc.getMainPane().microsoftAuthScene);
                }
            }
        });
        this.add((Component)this.username);
        this.username.setForeground(Color.BLACK);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.tlauncherAuth);
        this.tlauncherAuth.setForeground(Color.BLACK);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.microsoftAuth);
        this.microsoftAuth.setForeground(Color.BLACK);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.freeAuth);
        this.freeAuth.setForeground(Color.BLACK);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.mojangAuth);
        this.mojangAuth.setForeground(Color.BLACK);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.password);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)titleSkinLabel);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.tlSkin);
        this.add(Box.createVerticalStrut(5));
        this.add((Component)this.offSkin);
        this.add(Box.createVerticalStrut(5));
        this.cl = new CardLayout(0, 0);
        this.cPanel = new JPanel(this.cl);
        this.cPanel.add((Component)this.save, this.saveString);
        this.cPanel.add((Component)this.bar, this.barString);
        this.cPanel.setBackground(Color.white);
        this.setBackground(Color.white);
        this.add((Component)this.cPanel);
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof Box.Filler) {
            return super.add(comp);
        }
        JPanel p = new JPanel(new GridLayout());
        p.add(comp);
        p.setBackground(Color.white);
        return super.add((Component)p);
    }

    public void setSelectedAccountType(Account.AccountType type) {
        AuthTypeRadio selectable = this.radioMap.get((Object)type);
        if (selectable != null) {
            selectable.setSelected(true);
        }
    }

    public void clear() {
        this.setSelectedAccountType(Account.AccountType.TLAUNCHER);
        this.username.setText(null);
        this.password.setText(null);
        this.scene.list.setTempAccountType(Account.AccountType.TLAUNCHER);
        this.tlSkin.setSelected(true);
    }

    public Account get() {
        Account account = this.scene.list.getAccountFromSelected();
        account.setUsername(this.username.getValue());
        if (this.tlSkin.isSelected()) {
            account.setSkinType(Account.AccountType.TLAUNCHER);
        } else {
            account.setSkinType(Account.AccountType.MOJANG);
        }
        switch (account.getType()) {
            case TLAUNCHER: 
            case MOJANG: {
                if (!this.password.hasPassword()) break;
                account.setPassword(new String(this.password.getPassword()));
                break;
            }
        }
        return account;
    }

    public void fillFormBySelectedAccount(Account selectedValue) {
        this.username.setText(selectedValue.getDisplayName());
        this.authGroup.setSelected(this.radioMap.get((Object)selectedValue.getType()).getModel(), true);
        if (Account.AccountType.MOJANG.equals((Object)selectedValue.getSkinType())) {
            this.offSkin.setSelected(true);
        } else {
            this.tlSkin.setSelected(true);
        }
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        this.cl.show(this.cPanel, this.barString);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Exception e) {
        this.cl.show(this.cPanel, this.saveString);
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        this.cl.show(this.cPanel, this.saveString);
    }

    public class AuthTypeRadio
    extends LocalizableRadioButton {
        private final Account.AccountType type;

        private AuthTypeRadio(final Account.AccountType type) {
            super("account.auth." + type.toString().toLowerCase(Locale.ROOT));
            AccountEditor.this.radioMap.put(type, this);
            AccountEditor.this.authGroup.add(this);
            this.type = type;
            this.setFocusable(false);
            this.addItemListener(new CheckBoxListener(){

                @Override
                public void itemStateChanged(boolean newstate) {
                    if (newstate) {
                        ((AccountEditor)AccountEditor.this).scene.list.setTempAccountType(type);
                    }
                    if (newstate && !AccountEditor.this.password.hasPassword()) {
                        AccountEditor.this.password.setText(null);
                    }
                    if (newstate) {
                        ((AccountEditor)AccountEditor.this).scene.tip.setAccountType(type);
                        AccountEditor.this.flex.setText(Localizable.get("auth.tip." + type.name().toLowerCase(Locale.ROOT)));
                    }
                    if (Account.AccountType.FREE == type && newstate) {
                        Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, true);
                    } else {
                        Blocker.setBlocked(AccountEditor.this.password, AccountEditor.passlock, false);
                    }
                    AccountEditor.this.username.setState(newstate ? UsernameField.UsernameState.USERNAME : UsernameField.UsernameState.EMAIL_LOGIN);
                    if (AccountEditor.this.mojangAuth.isSelected()) {
                        AccountEditor.this.username.setState(UsernameField.UsernameState.EMAIL);
                    }
                }
            });
        }

        public Account.AccountType getAccountType() {
            return this.type;
        }
    }

    class BlockablePasswordField
    extends ExtendedPasswordField
    implements Blockable {
        BlockablePasswordField() {
        }

        @Override
        public void block(Object reason) {
            this.setEnabled(false);
        }

        @Override
        public void unblock(Object reason) {
            this.setEnabled(true);
        }
    }
}

