/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.loc.modpack;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.modpack.TableActButton;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;

public class ModpackTableVersionButton
extends TableActButton {
    private VersionDTO versionDTO;

    public ModpackTableVersionButton(final GameEntityDTO entity, final GameType type, final ModpackComboBox localmodpacks, final VersionDTO versionDTO, BaseModpackFilter<VersionDTO> filter) {
        super(entity, type, localmodpacks);
        this.versionDTO = versionDTO;
        this.filter = filter;
        this.initButton();
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModpackTableVersionButton.this.manager.installEntity(entity, versionDTO, type, true);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModpackTableVersionButton.this.manager.removeEntity(entity, versionDTO, type, false);
            }
        });
        this.deniedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Alert.showQuestion(Localizable.get("launcher.warning.title"), Localizable.get("modpack.filter.version.denied", ((CompleteVersion)localmodpacks.getSelectedValue()).getID()))) {
                    ModpackTableVersionButton.this.manager.installEntity(entity, versionDTO, type, true);
                }
            }
        });
    }

    @Override
    public void initButton() {
        if (this.findLocal() != null) {
            this.setTypeButton("REMOVE");
            if (this.type == GameType.MOD && !this.filter.isProper(this.versionDTO)) {
                this.firstDeniedState = true;
            }
            return;
        }
        if (this.type == GameType.MODPACK) {
            this.setTypeButton("INSTALL");
            return;
        }
        if (this.filter.isProper(this.versionDTO)) {
            this.setTypeButton("INSTALL");
        } else {
            this.setTypeButton("DENIED");
            this.firstDeniedState = true;
        }
    }

    private GameEntityDTO findLocal() {
        for (GameEntityDTO gameEntityDTO : this.getSelectedModpackData()) {
            if (!this.entity.getId().equals(gameEntityDTO.getId()) || !gameEntityDTO.getVersion().getId().equals(this.versionDTO.getId())) continue;
            return gameEntityDTO;
        }
        return null;
    }
}

