/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.login;

import by.gdev.util.excepiton.NotAllowWriteFileOperation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import net.minecraft.launcher.updater.VersionSyncInfo;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.DownloaderListener;
import org.tlauncher.tlauncher.entity.server.RemoteServer;
import org.tlauncher.tlauncher.entity.server.SiteServer;
import org.tlauncher.tlauncher.listeners.auth.LoginProcessListener;
import org.tlauncher.tlauncher.listeners.auth.ValidateAccountToken;
import org.tlauncher.tlauncher.managers.VersionManager;
import org.tlauncher.tlauncher.managers.VersionManagerListener;
import org.tlauncher.tlauncher.managers.popup.menu.HotServerManager;
import org.tlauncher.tlauncher.minecraft.auth.Authenticator;
import org.tlauncher.tlauncher.minecraft.crash.Crash;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftException;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftListener;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.block.BlockablePanel;
import org.tlauncher.tlauncher.ui.block.Blocker;
import org.tlauncher.tlauncher.ui.center.CenterPanel;
import org.tlauncher.tlauncher.ui.listener.auth.AuthenticatorListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.login.AccountComboBox;
import org.tlauncher.tlauncher.ui.login.AccountPanel;
import org.tlauncher.tlauncher.ui.login.LoginException;
import org.tlauncher.tlauncher.ui.login.VersionComboBox;
import org.tlauncher.tlauncher.ui.login.VersionPanel;
import org.tlauncher.tlauncher.ui.login.buttons.ButtonPanel;
import org.tlauncher.tlauncher.ui.login.buttons.PlayButton;
import org.tlauncher.tlauncher.ui.scenes.DefaultScene;
import org.tlauncher.tlauncher.ui.settings.SettingsPanel;
import org.tlauncher.util.U;
import org.tlauncher.util.async.LoopedThread;

public class LoginForm
extends CenterPanel
implements MinecraftListener,
AuthenticatorListener,
VersionManagerListener,
DownloaderListener {
    public static final Dimension LOGIN_SIZE = new Dimension(1050, 70);
    public static final String LOGIN_BLOCK = "login";
    public static final String REFRESH_BLOCK = "refresh";
    public static final String LAUNCH_BLOCK = "launch";
    public static final String AUTH_BLOCK = "auth";
    public static final String UPDATER_BLOCK = "update";
    public static final String DOWNLOADER_BLOCK = "download";
    public final DefaultScene scene;
    public final MainPane pane;
    public final VersionComboBox versions;
    public final PlayButton play;
    public final BlockablePanel playPanel;
    public final ButtonPanel buttons;
    public final AccountComboBox accountComboBox;
    public final VersionPanel versionPanel;
    public final AccountPanel accountPanel;
    private final List<LoginStateListener> stateListeners = Collections.synchronizedList(new ArrayList());
    private final List<LoginProcessListener> processListeners = Collections.synchronizedList(new ArrayList());
    private final SettingsPanel settings;
    private final StartThread startThread;
    private final StopThread stopThread;
    private LoginState state = LoginState.STOPPED;
    private RemoteServer server;

    public LoginForm(DefaultScene scene) {
        super(noInsets);
        this.setSize(LOGIN_SIZE);
        this.setMaximumSize(LOGIN_SIZE);
        this.setOpaque(true);
        this.setBackground(new Color(113, 169, 76));
        this.scene = scene;
        this.pane = scene.getMainPane();
        this.settings = scene.settingsForm;
        this.startThread = new StartThread();
        this.stopThread = new StopThread();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(Box.createHorizontalStrut(19));
        this.play = new PlayButton(this);
        this.accountPanel = new AccountPanel(this, this.global.getBoolean("chooser.type.account"));
        this.buttons = new ButtonPanel(this);
        this.playPanel = new BlockablePanel();
        this.versionPanel = new VersionPanel(this);
        this.accountPanel.setPreferredSize(new Dimension(246, 70));
        this.add((Component)this.accountPanel);
        this.add(Box.createHorizontalStrut(20));
        this.versionPanel.setPreferredSize(new Dimension(246, 70));
        this.add((Component)this.versionPanel);
        this.add(Box.createHorizontalStrut(20));
        this.playPanel.setLayout(new BorderLayout(0, 0));
        this.playPanel.setPreferredSize(new Dimension(240, 70));
        this.playPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 8, 0));
        this.playPanel.add((Component)this.play);
        this.add((Component)this.playPanel);
        this.add(Box.createHorizontalStrut(19));
        this.buttons.setPreferredSize(new Dimension(240, 70));
        this.add((Component)this.buttons);
        this.versions = this.versionPanel.version;
        this.accountComboBox = this.accountPanel.accountComboBox;
        this.processListeners.add(this.settings);
        this.processListeners.add(this.versionPanel);
        this.processListeners.add(this.versions);
        this.processListeners.add(new ValidateAccountToken());
        this.stateListeners.add(this.play);
        this.tlauncher.getVersionManager().addListener(this);
        this.tlauncher.getDownloader().addListener(this);
        this.accountPanel.accountComboBox.addItemListener(this.versions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runProcess() {
        LoginException error = null;
        boolean success = true;
        List<LoginProcessListener> list = this.processListeners;
        synchronized (list) {
            this.processListeners.forEach(e -> e.preValidate());
        }
        list = this.processListeners;
        synchronized (list) {
            for (LoginProcessListener listener : this.processListeners) {
                try {
                    listener.validatePreGameLaunch();
                }
                catch (LoginException loginError) {
                    this.log("Catched an error on a listener");
                    error = loginError;
                }
                if (error == null) continue;
                this.log(error);
                success = false;
                break;
            }
            if (success) {
                for (LoginProcessListener listener : this.processListeners) {
                    listener.loginSucceed();
                }
            } else {
                ((HotServerManager)TLauncher.getInjector().getInstance(HotServerManager.class)).enablePopup();
                for (LoginProcessListener listener : this.processListeners) {
                    listener.loginFailed();
                }
            }
        }
        if (error != null) {
            this.log("Login process has ended with an error.");
            return;
        }
        this.global.store();
        this.log("Login was OK. Trying to launch now.");
        boolean force = this.versionPanel.forceupdate.isSelected();
        this.changeState(LoginState.LAUNCHING);
        this.tlauncher.launch(this, this.server, force);
        this.server = null;
        this.versionPanel.forceupdate.setSelected(false);
    }

    private void stopProcess() {
        while (!this.tlauncher.isLauncherWorking()) {
            this.log("waiting for launcher");
            U.sleepFor(500L);
        }
        this.changeState(LoginState.STOPPING);
        this.tlauncher.getLauncher().stop();
    }

    public void startLauncher() {
        if (Blocker.isBlocked(this)) {
            return;
        }
        this.startThread.iterate();
    }

    public void startLauncher(RemoteServer server) {
        this.server = server;
        this.startLauncher();
    }

    public void startLauncher(SiteServer server) {
        if (server == null) {
            this.log("version is null");
            return;
        }
        boolean find = false;
        for (int i = 0; i < this.versions.getModel().getSize(); ++i) {
            if (!((VersionSyncInfo)this.versions.getModel().getElementAt(i)).getID().equals(server.getVersion())) continue;
            this.versions.setSelectedValue(this.versions.getModel().getElementAt(i));
            find = true;
            break;
        }
        if (!find) {
            Alert.showLocMessage("version.do.not.find");
            return;
        }
        this.server = server;
        this.startLauncher();
    }

    public void stopLauncher() {
        this.stopThread.iterate();
    }

    private void changeState(LoginState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        if (this.state == state) {
            return;
        }
        this.state = state;
        for (LoginStateListener listener : this.stateListeners) {
            listener.loginStateChanged(state);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.block(reason, this.settings, this.play, this.versionPanel, this.accountPanel);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblock(reason, this.settings, this.play, this.versionPanel, this.accountPanel);
    }

    @Override
    public void onDownloaderStart(Downloader d, int files) {
        Blocker.block(this, DOWNLOADER_BLOCK);
        if (this.play.getState() == PlayButton.PlayButtonState.CANCEL) {
            this.play.unblock("downloading finished");
        }
    }

    @Override
    public void onDownloaderAbort(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onDownloaderProgress(Downloader d, double progress, double speed, double alreadyDownloaded) {
    }

    @Override
    public void onDownloaderFileComplete(Downloader d, Downloadable file) {
    }

    @Override
    public void onDownloaderComplete(Downloader d) {
        Blocker.unblock(this, DOWNLOADER_BLOCK);
    }

    @Override
    public void onVersionsRefreshing(VersionManager manager) {
        Blocker.block(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshingFailed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onVersionsRefreshed(VersionManager manager) {
        Blocker.unblock(this, REFRESH_BLOCK);
    }

    @Override
    public void onAuthPassing(Authenticator auth) {
        Blocker.block(this, AUTH_BLOCK);
    }

    @Override
    public void onAuthPassingError(Authenticator auth, Exception e) {
        Blocker.unblock(this, AUTH_BLOCK);
        Throwable cause = e.getCause();
        if (cause != null && e.getCause() instanceof IOException) {
            return;
        }
        throw new LoginException("Cannot auth!");
    }

    @Override
    public void onAuthPassed(Authenticator auth) {
        Blocker.unblock(this, AUTH_BLOCK);
    }

    @Override
    public void onMinecraftPrepare() {
        Blocker.block(this, LAUNCH_BLOCK);
    }

    @Override
    public void onMinecraftAbort() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftLaunch() {
        this.changeState(LoginState.LAUNCHED);
    }

    @Override
    public void onMinecraftClose() {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
        this.tlauncher.getVersionManager().startRefresh(true);
    }

    @Override
    public void onMinecraftError(Throwable e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftKnownError(MinecraftException e) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    @Override
    public void onMinecraftCrash(Crash crash) {
        Blocker.unblock(this, LAUNCH_BLOCK);
        this.changeState(LoginState.STOPPED);
    }

    public void removeLoginProcessListener(LoginProcessListener listener) {
        this.processListeners.remove(listener);
    }

    public void addLoginProcessListener(LoginProcessListener listener) {
        this.processListeners.add(listener);
    }

    public void addLoginProcessListener(LoginProcessListener listener, int position) {
        this.processListeners.add(position, listener);
    }

    class StopThread
    extends LoopedThread {
        StopThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.stopProcess();
            }
            catch (Throwable t) {
                Alert.showError(t);
            }
        }
    }

    class StartThread
    extends LoopedThread {
        StartThread() {
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            try {
                LoginForm.this.runProcess();
            }
            catch (Throwable t) {
                if (t instanceof NotAllowWriteFileOperation) {
                    Alert.showErrorHtml("auth.error.title", Localizable.get("auth.error.can.not.write", t.getMessage()));
                }
                Alert.showError(t);
            }
        }
    }

    public static interface LoginStateListener {
        public void loginStateChanged(LoginState var1);
    }

    public static enum LoginState {
        LAUNCHING,
        STOPPING,
        STOPPED,
        LAUNCHED;

    }
}

