/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import by.gdev.util.DesktopUtil;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.GameVersionDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.MinecraftVersionDTO;
import org.tlauncher.modpack.domain.client.share.NameIdDTO;
import org.tlauncher.modpack.domain.client.share.VersionMaturity;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.tlauncher.configuration.Configuration;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.LocalizableTextField;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.modpack.SliderModpackPanel;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationMinecraftTypeComboboxRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationModpackForgeComboboxRenderer;
import org.tlauncher.tlauncher.ui.swing.renderer.CreationModpackGameVersionComboboxRenderer;
import org.tlauncher.tlauncher.ui.ui.CreationMinecraftTypeComboboxUI;
import org.tlauncher.tlauncher.ui.ui.CreationModpackForgeComboboxUI;
import org.tlauncher.tlauncher.ui.ui.CreationModpackGameVersionComboboxUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackCreation
extends TemlateModpackFrame {
    private final LocalizableTextField versionName;
    private final JComboBox<GameVersionDTO> gameVersions;
    private final JComboBox<MinecraftVersionDTO> versionNameValue;
    private JComboBox<NameIdDTO> minecraftVersionTypes;
    private JButton create;
    private JCheckBox box;
    private JButton cancel;
    private EditorCheckBox tlskinCapeModBox;
    private static final Dimension maxSize = new Dimension(572, 479);
    private static final Dimension minSize = new Dimension(572, 374);
    private JLabel question;
    private Configuration c;
    private ModpackManager modpackManager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
    volatile boolean tlSkinsAvailable = true;

    public ModpackCreation(JFrame parent) {
        super(parent, "modpack.creation.modpack", new Dimension(572, 479));
        this.question = new JLabel(ImageCache.getNativeIcon((String)"qestion-option-panel.png"));
        this.c = TLauncher.getInstance().getConfiguration();
        this.question.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModpackCreation.this.setVisible(false);
                Alert.showLocMessage(ModpackCreation.this.c.get("memory.problem.message"));
                ModpackCreation.this.setVisible(true);
            }
        });
        SpringLayout spring = new SpringLayout();
        JPanel panel = new JPanel(spring);
        panel.setBorder(new EmptyBorder(0, 0, 33, 0));
        this.addCenter(panel);
        panel.setBackground(Color.WHITE);
        JLabel nameLabel = new JLabel(Localizable.get("modpack.creation.name"));
        nameLabel.setForeground(ColorUtil.COLOR_149);
        LocalizableLabel selectedMemory = new LocalizableLabel("settings.java.memory.label");
        JLabel type = new JLabel(Localizable.get("version.manager.editor.field.type"));
        LocalizableLabel memorySettings = new LocalizableLabel("modpack.config.memory.title");
        LocalizableLabel tlskinCapeModLabel = new LocalizableLabel("modpack.config.system.label");
        this.box = new EditorCheckBox("modpack.config.memory.box");
        this.box.setIconTextGap(14);
        this.tlskinCapeModBox = new EditorCheckBox("modpack.config.skin.use");
        this.tlskinCapeModBox.setIconTextGap(14);
        this.tlskinCapeModBox.setSelected(true);
        JLabel versionGameLabel = new JLabel(Localizable.get("modpack.table.pack.element.version") + ":");
        JLabel versionLabel = new JLabel(Localizable.get("version.name.v1") + ":");
        this.create = new UpdaterFullButton(COLOR_0_174_239, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.create.button", "modpack-creation.button.png");
        this.create.setEnabled(false);
        this.create.setBorder(new EmptyBorder(0, 29, 0, 0));
        this.create.setIconTextGap(42);
        this.cancel = new UpdaterFullButton(new Color(208, 43, 43), new Color(180, 39, 39), "loginform.enter.cancel", "modpack-cancel-button.png");
        this.cancel.setBorder(new EmptyBorder(0, 29, 0, 0));
        this.cancel.setIconTextGap(42);
        this.gameVersions = new JComboBox();
        this.gameVersions.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.gameVersions.setRenderer(new CreationModpackGameVersionComboboxRenderer());
        this.gameVersions.setUI(new CreationModpackGameVersionComboboxUI());
        this.minecraftVersionTypes = new JComboBox();
        this.minecraftVersionTypes.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.minecraftVersionTypes.setRenderer(new CreationMinecraftTypeComboboxRenderer());
        this.minecraftVersionTypes.setUI(new CreationMinecraftTypeComboboxUI());
        this.versionNameValue = new JComboBox();
        this.versionNameValue.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, ColorUtil.COLOR_149));
        this.versionNameValue.setRenderer(new CreationModpackForgeComboboxRenderer());
        this.versionNameValue.setUI(new CreationModpackForgeComboboxUI());
        this.versionName = new LocalizableTextField("modpack.creation.input.name"){

            @Override
            protected void onFocusLost() {
                super.onFocusLost();
                if (super.getValue() == null) {
                    ModpackCreation.this.versionName.setForeground(ColorUtil.COLOR_202);
                }
            }

            @Override
            protected void onFocusGained() {
                super.onFocusGained();
                ModpackCreation.this.versionName.setForeground(ColorUtil.COLOR_25);
            }
        };
        this.versionName.setHorizontalAlignment(0);
        this.versionName.setBorder(BorderFactory.createLineBorder(ColorUtil.COLOR_149, 1));
        SliderModpackPanel slider = new SliderModpackPanel(new Dimension(534, 80));
        SwingUtil.changeFontFamily(type, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(nameLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(versionLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(versionGameLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_149);
        SwingUtil.changeFontFamily(memorySettings, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(selectedMemory, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(tlskinCapeModLabel, FontTL.ROBOTO_BOLD, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.tlskinCapeModBox, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.create, FontTL.ROBOTO_BOLD, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.box, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.minecraftVersionTypes, FontTL.ROBOTO_REGULAR, 14, Color.BLACK);
        SwingUtil.changeFontFamily(this.gameVersions, FontTL.ROBOTO_BOLD, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(this.versionNameValue, FontTL.ROBOTO_BOLD, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(this.cancel, FontTL.ROBOTO_BOLD, 12, Color.WHITE);
        SwingUtil.changeFontFamily(this.versionName, FontTL.ROBOTO_BOLD, 18, ColorUtil.COLOR_202);
        int height = 18;
        spring.putConstraint("West", (Component)nameLabel, 253, "West", (Component)panel);
        spring.putConstraint("East", (Component)nameLabel, 353, "West", (Component)panel);
        spring.putConstraint("North", (Component)nameLabel, 23, "North", (Component)panel);
        spring.putConstraint("South", (Component)nameLabel, 23 + height, "North", (Component)panel);
        panel.add(nameLabel);
        spring.putConstraint("West", (Component)this.versionName, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.versionName, -27, "East", (Component)panel);
        spring.putConstraint("North", (Component)this.versionName, 2, "South", (Component)nameLabel);
        spring.putConstraint("South", (Component)this.versionName, 46, "South", (Component)nameLabel);
        panel.add(this.versionName);
        spring.putConstraint("West", (Component)type, 32, "West", (Component)panel);
        spring.putConstraint("East", (Component)type, 139, "West", (Component)panel);
        spring.putConstraint("North", (Component)type, 18, "South", (Component)this.versionName);
        spring.putConstraint("South", (Component)type, 18 + height, "South", (Component)this.versionName);
        panel.add(type);
        spring.putConstraint("West", (Component)versionGameLabel, 162, "West", (Component)panel);
        spring.putConstraint("East", (Component)versionGameLabel, 289, "West", (Component)panel);
        spring.putConstraint("North", (Component)versionGameLabel, 18, "South", (Component)this.versionName);
        spring.putConstraint("South", (Component)versionGameLabel, 18 + height, "South", (Component)this.versionName);
        panel.add(versionGameLabel);
        spring.putConstraint("West", (Component)versionLabel, 332, "West", (Component)panel);
        spring.putConstraint("East", (Component)versionLabel, 545, "West", (Component)panel);
        spring.putConstraint("North", (Component)versionLabel, 18, "South", (Component)this.versionName);
        spring.putConstraint("South", (Component)versionLabel, 18 + height, "South", (Component)this.versionName);
        panel.add(versionLabel);
        spring.putConstraint("West", this.minecraftVersionTypes, 29, "West", (Component)panel);
        spring.putConstraint("East", this.minecraftVersionTypes, 139, "West", (Component)panel);
        spring.putConstraint("North", this.minecraftVersionTypes, 5, "South", (Component)versionLabel);
        spring.putConstraint("South", this.minecraftVersionTypes, 49, "South", (Component)versionLabel);
        panel.add(this.minecraftVersionTypes);
        spring.putConstraint("West", this.gameVersions, 159, "West", (Component)panel);
        spring.putConstraint("East", this.gameVersions, 309, "West", (Component)panel);
        spring.putConstraint("North", this.gameVersions, 5, "South", (Component)versionLabel);
        spring.putConstraint("South", this.gameVersions, 49, "South", (Component)versionLabel);
        panel.add(this.gameVersions);
        spring.putConstraint("West", this.versionNameValue, 329, "West", (Component)panel);
        spring.putConstraint("East", this.versionNameValue, 545, "West", (Component)panel);
        spring.putConstraint("North", this.versionNameValue, 5, "South", (Component)versionLabel);
        spring.putConstraint("South", this.versionNameValue, 49, "South", (Component)versionLabel);
        panel.add(this.versionNameValue);
        spring.putConstraint("West", (Component)memorySettings, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)memorySettings, 229, "West", (Component)panel);
        spring.putConstraint("North", (Component)memorySettings, 15, "South", this.versionNameValue);
        spring.putConstraint("South", (Component)memorySettings, 32, "South", this.versionNameValue);
        panel.add(memorySettings);
        spring.putConstraint("West", (Component)this.box, 179, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.box, 529, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.box, 15, "South", this.versionNameValue);
        spring.putConstraint("South", (Component)this.box, 32, "South", this.versionNameValue);
        panel.add(this.box);
        spring.putConstraint("West", (Component)tlskinCapeModLabel, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)tlskinCapeModLabel, 229, "West", this.versionNameValue);
        spring.putConstraint("North", (Component)tlskinCapeModLabel, 10, "South", (Component)memorySettings);
        spring.putConstraint("South", (Component)tlskinCapeModLabel, 27, "South", (Component)memorySettings);
        panel.add(tlskinCapeModLabel);
        spring.putConstraint("West", (Component)this.tlskinCapeModBox, 179, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.tlskinCapeModBox, 529, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.tlskinCapeModBox, 10, "South", (Component)memorySettings);
        spring.putConstraint("South", (Component)this.tlskinCapeModBox, 27, "South", (Component)memorySettings);
        panel.add(this.tlskinCapeModBox);
        spring.putConstraint("West", (Component)this.create, 29, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.create, 267, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.create, -43, "South", (Component)panel);
        spring.putConstraint("South", (Component)this.create, 0, "South", (Component)panel);
        panel.add(this.create);
        spring.putConstraint("West", (Component)this.cancel, 307, "West", (Component)panel);
        spring.putConstraint("East", (Component)this.cancel, 545, "West", (Component)panel);
        spring.putConstraint("North", (Component)this.cancel, -43, "South", (Component)panel);
        spring.putConstraint("South", (Component)this.cancel, 0, "South", (Component)panel);
        panel.add(this.cancel);
        this.create.addActionListener(e -> {
            String name = this.versionName.getValue();
            try {
                Paths.get(name, new String[0]);
            }
            catch (NullPointerException | InvalidPathException ex) {
                this.versionName.setBorder(BorderFactory.createLineBorder(new Color(255, 62, 62), 1));
                return;
            }
            if (!this.modpackManager.checkNameVersion(Lists.newArrayList((Object[])new String[]{name}))) {
                this.setVisible(false);
                Alert.showLocWarning("modpack.config.memory.message");
                this.setVisible(true);
                return;
            }
            ModpackDTO modpackDTO = new ModpackDTO();
            modpackDTO.setId(-U.n());
            ModpackVersionDTO v = new ModpackVersionDTO();
            v.setId(-U.n() - 1L);
            modpackDTO.setName(name);
            GameVersionDTO g = (GameVersionDTO)this.gameVersions.getSelectedItem();
            v.setGameVersionDTO(g);
            v.setName("1.0");
            v.setMinecraftVersionTypes(Lists.newArrayList((Object[])new NameIdDTO[]{(NameIdDTO)this.minecraftVersionTypes.getSelectedItem()}));
            v.setMinecraftVersionName(((MinecraftVersionDTO)this.versionNameValue.getSelectedItem()).createFromCurrent());
            modpackDTO.setVersion(v);
            if (!this.box.isSelected()) {
                modpackDTO.setModpackMemory(true);
                modpackDTO.setMemory(slider.getValue());
            }
            this.modpackManager.createModpack(name, modpackDTO, this.tlskinCapeModBox.isSelected());
            this.setVisible(false);
        });
        this.box.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.setCenter(maxSize);
                spring.putConstraint("West", (Component)slider, 12, "West", (Component)panel);
                spring.putConstraint("East", (Component)slider, -13, "East", (Component)panel);
                spring.putConstraint("North", (Component)slider, 259, "North", (Component)panel);
                spring.putConstraint("South", (Component)slider, 339, "South", (Component)panel);
                panel.add(slider);
                spring.putConstraint("West", (Component)selectedMemory, 29, "West", (Component)panel);
                spring.putConstraint("East", (Component)selectedMemory, 29 + SwingUtil.getWidthText(selectedMemory, selectedMemory.getText()) + 5, "West", (Component)panel);
                spring.putConstraint("North", (Component)selectedMemory, 245, "North", (Component)panel);
                spring.putConstraint("South", (Component)selectedMemory, 263, "North", (Component)panel);
                panel.add(selectedMemory);
                spring.putConstraint("West", (Component)this.question, 2, "East", (Component)selectedMemory);
                spring.putConstraint("East", (Component)this.question, 25, "East", (Component)selectedMemory);
                spring.putConstraint("North", (Component)this.question, -153, "South", (Component)panel);
                spring.putConstraint("South", (Component)this.question, -133, "South", (Component)panel);
                panel.add(this.question);
                this.setCenter(maxSize);
                if (!this.c.isExist("memory.problem.message")) {
                    this.question.setVisible(false);
                }
            } else {
                panel.remove(selectedMemory);
                panel.remove(slider);
                panel.remove(this.question);
                this.setCenter(minSize);
            }
        });
        this.tlskinCapeModBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ModpackCreation.this.tlskinCapeModBox.isSelected() && !ModpackCreation.this.tlSkinsAvailable) {
                    Alert.showWarning(Localizable.get("skins.not.found.title"), Localizable.get("skins.not.found"));
                    ModpackCreation.this.tlskinCapeModBox.setSelected(false);
                }
            }
        });
        this.cancel.addActionListener(e -> this.setVisible(false));
        this.box.setSelected(true);
        this.minecraftVersionTypes.addItemListener(item -> {
            if (item.getStateChange() == 1) {
                this.getGameVersionsFields((NameIdDTO)item.getItem());
            }
        });
        this.gameVersions.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                    GameVersionDTO g = (GameVersionDTO)e.getItem();
                    this.updateVersions(g);
                    this.updateSkinBoxButton(g);
                    return null;
                })).exceptionally(ex -> {
                    U.log(ex);
                    return null;
                });
            }
        });
        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
            this.modpackManager.fillVersionTypesAndGameVersion();
            NameIdDTO[] d = this.modpackManager.getMinecraftVersionTypes().toArray(new NameIdDTO[0]);
            SwingUtilities.invokeLater(() -> {
                this.minecraftVersionTypes.setModel(new DefaultComboBoxModel<NameIdDTO>(d));
                this.minecraftVersionTypes.revalidate();
                this.minecraftVersionTypes.repaint();
                this.getGameVersionsFields((NameIdDTO)this.minecraftVersionTypes.getSelectedItem());
            });
            return null;
        })).exceptionally(ex -> {
            U.log(ex);
            return null;
        });
    }

    private void getGameVersionsFields(NameIdDTO nameIdDTO) {
        this.create.setEnabled(false);
        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
            List<GameVersionDTO> gameVersins = this.modpackManager.getGameVersionsRemote(nameIdDTO);
            SwingUtilities.invokeLater(() -> this.gameVersions.setModel(new DefaultComboBoxModel<GameVersionDTO>(gameVersins.toArray(new GameVersionDTO[0]))));
            this.updateVersions(gameVersins.get(0));
            this.updateSkinBoxButton(gameVersins.get(0));
            return null;
        })).exceptionally(e -> {
            U.log(e);
            return null;
        });
    }

    private void updateVersions(GameVersionDTO gameVersionDTO) throws IOException {
        NameIdDTO minecraftVersionType = (NameIdDTO)this.minecraftVersionTypes.getSelectedItem();
        List<MinecraftVersionDTO> list = this.modpackManager.getVersionsByGameVersionAndMinecraftVersionType(gameVersionDTO.getId(), minecraftVersionType);
        SwingUtilities.invokeLater(() -> {
            this.versionNameValue.setModel(new DefaultComboBoxModel<MinecraftVersionDTO>(list.toArray(new MinecraftVersionDTO[0])));
            list.stream().filter(f -> VersionMaturity.PROMO_RECOMMEDED.equals((Object)f.getMaturity())).findFirst().ifPresent(vv -> this.versionNameValue.setSelectedItem(vv));
            this.create.setEnabled(true);
        });
    }

    private void updateSkinBoxButton(GameVersionDTO gameVersionDTO) {
        GameEntityDTO g = new GameEntityDTO();
        g.setId(ModDTO.TL_SKIN_CAPE_ID);
        NameIdDTO minecraftVersionType = (NameIdDTO)this.minecraftVersionTypes.getSelectedItem();
        try {
            this.modpackManager.getInstallingGameEntity(GameType.MOD, g, null, gameVersionDTO, (NameIdDTO)this.minecraftVersionTypes.getSelectedItem());
            this.tlSkinsAvailable = true;
            this.setStatusTlSkinCapeModBox(true);
        }
        catch (IOException e) {
            U.log("not found tl skin cape for", gameVersionDTO.getName(), minecraftVersionType.getName());
            this.setStatusTlSkinCapeModBox(false);
            this.tlSkinsAvailable = false;
        }
    }

    private void setStatusTlSkinCapeModBox(boolean flag) {
        SwingUtilities.invokeLater(() -> this.tlskinCapeModBox.setSelected(flag));
    }
}

