/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack.form;

import com.google.common.eventbus.EventBus;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tlauncher.modpack.domain.client.CommentDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.share.TopicType;
import org.tlauncher.tlauncher.controller.CommentModpackController;
import org.tlauncher.tlauncher.exceptions.RequiredTLAccountException;
import org.tlauncher.tlauncher.exceptions.SelectedAnyOneTLAccountException;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.model.GameEntityComment;
import org.tlauncher.tlauncher.ui.model.InsertCommentDTO;
import org.tlauncher.tlauncher.ui.modpack.DiscussionPanel;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.swing.FontTL;

public class CommentCreationForm
extends ExtendedPanel {
    private static final Logger log = LoggerFactory.getLogger(CommentCreationForm.class);
    @Inject
    private CommentModpackController controller;
    @Inject
    private EventBus eventBus;
    @Inject
    private Gson gson;
    private volatile CommentDTO changedComment;
    private JTextArea textArea = new JTextArea();
    private JButton boldButton = new UpdaterButton(Color.gray, "B");
    private JButton inclineButton = new UpdaterButton(Color.gray, "I");
    private JButton underscoreButton = new UpdaterButton(Color.gray, "U");
    private JButton leaveComment = new UpdaterFullButton(new Color(54, 153, 208), ColorUtil.BACKGROUND_COMBO_BOX_POPUP_SELECTED, "modpack.comment.leave", "create-modpack.png");
    private JButton close = new ImageUdaterButton(ColorUtil.BLUE_COLOR, "close-modpack.png");
    private static final Dimension SIZE = new Dimension(500, 300);
    private GameType type;
    private Long topicPage;
    private Long topicId;
    private DiscussionPanel.Comment parent;
    private TopicType topicType;

    public CommentCreationForm() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setVisible(false);
        JPanel pp = new JPanel(new FlowLayout(1, 0, 140));
        LocalizableLabel title = new LocalizableLabel("modpack.comment.creation");
        pp.setBackground(new Color(1, 1, 1, 100));
        pp.setOpaque(true);
        pp.setPreferredSize(ModpackScene.SIZE);
        this.setSize(ModpackScene.SIZE);
        this.add((Component)pp);
        JPanel panel = new JPanel();
        JPanel upPanel = new JPanel(new FlowLayout(1, 0, 0));
        ExtendedPanel upPanel1 = new ExtendedPanel(new BorderLayout(0, 0));
        upPanel.setBackground(ColorUtil.BLUE_COLOR);
        upPanel1.setPreferredSize(new Dimension(500, 45));
        upPanel.setPreferredSize(new Dimension(500, 45));
        this.close.setPreferredSize(new Dimension(41, 45));
        title.setPreferredSize(new Dimension(200, 45));
        title.setHorizontalAlignment(0);
        panel.setBackground(ColorUtil.BLUE_COLOR);
        BoxLayout l = new BoxLayout(panel, 1);
        panel.setOpaque(true);
        panel.setBackground(new Color(213, 213, 213));
        panel.setLayout(l);
        JPanel buttons = new JPanel(new FlowLayout(0));
        buttons.setOpaque(false);
        buttons.add(this.boldButton);
        buttons.add(this.inclineButton);
        buttons.add(this.underscoreButton);
        upPanel1.add((Component)title, "Center");
        upPanel1.add((Component)this.close, "East");
        upPanel.add(upPanel1);
        panel.add(upPanel);
        panel.add(buttons);
        panel.add(ModpackScene.createScrollWrapper(this.textArea));
        this.close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CommentCreationForm.this.close.setBackground(new Color(60, 145, 193));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CommentCreationForm.this.close.setBackground(ColorUtil.BLUE_COLOR_UNDER);
            }
        });
        this.close.addActionListener(e -> this.setVisible(false));
        JPanel p1 = new JPanel();
        p1.setOpaque(false);
        p1.add(this.leaveComment);
        panel.add(p1);
        this.leaveComment.setPreferredSize(new Dimension(200, 50));
        panel.setPreferredSize(SIZE);
        pp.add(panel);
        this.boldButton.addActionListener(e -> this.wrapText("b"));
        this.inclineButton.addActionListener(e -> this.wrapText("em"));
        this.underscoreButton.addActionListener(e -> this.wrapText("u"));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        SwingUtil.changeFontFamily(this.leaveComment, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(this.boldButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(this.inclineButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(this.underscoreButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        SwingUtil.changeFontFamily(title, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
        this.leaveComment.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!Pattern.matches("^(?!<em></em>|<i></i>|<u></u>|<b></b>)([\\w\\s\u0430-\u044f\u0410-\u042f\u0451\u0401\\.\\-\u2013:;\u00a0\u00ab\u00bb\u00b7,*!+\u2026'?%@)(/]|<b>|</b>|<i>|</i>|<u>|</u>|<em>|</em>)+(?<!<em></em>|<i></i>|<u></u>|<b></b>){1,2000}$", CommentCreationForm.this.textArea.getText())) {
                    CommentCreationForm.this.textArea.setBorder(BorderFactory.createLineBorder(Color.red, 1));
                    return;
                }
                CommentCreationForm.this.leaveComment.setEnabled(false);
                CompletableFuture.runAsync(() -> {
                    try {
                        if (Objects.isNull(CommentCreationForm.this.changedComment)) {
                            String res = CommentCreationForm.this.controller.saveComment(CommentCreationForm.this.textArea.getText(), CommentCreationForm.this.topicType, TLauncher.getInstance().getLang().isUSSRLocale() ? "ru" : "en", CommentCreationForm.this.type, CommentCreationForm.this.topicPage, CommentCreationForm.this.topicId);
                            SwingUtilities.invokeLater(() -> {
                                InsertCommentDTO ic = CommentCreationForm.this.gson.fromJson(res, InsertCommentDTO.class);
                                ic.setParent(CommentCreationForm.this.parent);
                                CommentCreationForm.this.eventBus.post((Object)ic);
                            });
                        } else {
                            GameEntityComment gec = new GameEntityComment();
                            gec.setDescription(CommentCreationForm.this.textArea.getText());
                            CommentDTO uc = CommentCreationForm.this.controller.update(CommentCreationForm.this.changedComment.getId(), gec);
                            CommentCreationForm.this.eventBus.post((Object)uc);
                        }
                    }
                    catch (RequiredTLAccountException ex) {
                        Alert.showLocError("modpack.right.panel.required.tl.account.title", Localizable.get("modpack.right.panel.required.tl.account", Localizable.get("loginform.button.settings.account")), null);
                    }
                    catch (SelectedAnyOneTLAccountException ex) {
                        Alert.showLocError("modpack.right.panel.required.tl.account.title", "modpack.right.panel.select.account.tl", null);
                    }
                    catch (Throwable ex) {
                        log.warn("error", ex);
                        Alert.showLocMessage("modpack.remote.not.found", "modpack.try.later", null);
                    }
                    SwingUtilities.invokeLater(() -> {
                        CommentCreationForm.this.leaveComment.setEnabled(true);
                        CommentCreationForm.this.setVisible(false);
                    });
                });
            }
        });
        pp.addMouseMotionListener(new MouseMotionAdapter(){});
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CommentCreationForm.this.textArea.setBorder(BorderFactory.createEmptyBorder());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CommentCreationForm.this.textArea.setBorder(BorderFactory.createEmptyBorder());
            }
        });
    }

    private void wrapText(String tag) {
        String value = "<%s>%s</%s>";
        if (this.textArea.getSelectionStart() == this.textArea.getSelectionEnd()) {
            int index = this.textArea.getCaretPosition();
            this.textArea.insert(String.format(value, tag, "", tag), index);
        } else {
            this.textArea.insert(String.format("<%s>", tag), this.textArea.getSelectionStart());
            this.textArea.insert(String.format("</%s>", tag), this.textArea.getSelectionEnd());
        }
    }

    public void preparedForNewComment() {
        this.parent = null;
        this.textArea.setText("");
        if (Objects.nonNull(this.changedComment)) {
            this.textArea.setText(this.changedComment.getDescription());
        }
    }

    public void setChangedComment(CommentDTO changedComment) {
        this.changedComment = changedComment;
    }

    public CommentDTO getChangedComment() {
        return this.changedComment;
    }

    public void setType(GameType type) {
        this.type = type;
    }

    public void setTopicPage(Long topicPage) {
        this.topicPage = topicPage;
    }

    public void setTopicId(Long topicId) {
        this.topicId = topicId;
    }

    public void setParent(DiscussionPanel.Comment parent) {
        this.parent = parent;
    }

    public void setTopicType(TopicType topicType) {
        this.topicType = topicType;
    }
}

