/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import by.gdev.util.DesktopUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackTableInstallButton;
import org.tlauncher.tlauncher.ui.modpack.GroupPanel;
import org.tlauncher.tlauncher.ui.scenes.CompleteSubEntityScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.GameRadioButton;
import org.tlauncher.tlauncher.ui.swing.ScrollPane;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackEnitityScene
extends CompleteSubEntityScene {
    private static final String EMPTY = "EMPTY";
    private static final String ROWS = "ROWS";

    public ModpackEnitityScene(MainPane main) {
        super(main);
    }

    public void showModpackEntity(GameEntityDTO completeGameEntity) {
        this.showFullGameEntity(completeGameEntity, GameType.MODPACK);
        GameRadioButton modReview = new GameRadioButton("modpack.complete.review.mod");
        modReview.setActionCommand(GameType.MOD.toString());
        GameRadioButton resourceReview = new GameRadioButton("modpack.complete.review.resource");
        resourceReview.setActionCommand(GameType.RESOURCEPACK.toString());
        GameRadioButton mapReview = new GameRadioButton("modpack.complete.review.map");
        mapReview.setActionCommand(GameType.MAP.toString());
        GameRadioButton shaderpackReview = new GameRadioButton("modpack.button.shaderpack");
        shaderpackReview.setActionCommand(GameType.SHADERPACK.toString());
        SwingUtil.changeFontFamily(mapReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(shaderpackReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(modReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(resourceReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        GroupPanel centerButtons = this.fullGameEntity.getCenterButtons();
        centerButtons.addInGroup(modReview, 3);
        centerButtons.addInGroup(resourceReview, 4);
        centerButtons.addInGroup(mapReview, 5);
        centerButtons.addInGroup(shaderpackReview, 6);
        final JPanel centerView = this.fullGameEntity.getCenterView();
        GameType.getSubEntities().forEach(t -> {
            final GameEntityTable table = new GameEntityTable(completeGameEntity, (GameType)((Object)t));
            ScrollPane scroll = ModpackScene.createScrollWrapper(table);
            JPanel panel = new JPanel();
            CardLayout c = new CardLayout();
            panel.setLayout(c);
            LocalizableLabel emptyLabel = new LocalizableLabel("modpack.table.empty." + t.toLowerCase());
            emptyLabel.setHorizontalAlignment(0);
            emptyLabel.setAlignmentX(0.0f);
            SwingUtil.changeFontFamily(emptyLabel, FontTL.ROBOTO_BOLD, 18, ColorUtil.COLOR_16);
            panel.add((Component)scroll, ROWS);
            panel.add((Component)emptyLabel, EMPTY);
            emptyLabel.setBounds(0, 160, MainPane.SIZE.width, 22);
            panel.setBounds(0, 0, MainPane.SIZE.width, 321);
            centerView.add((Component)panel, t.toLowerCase());
            panel.addComponentListener(new ComponentAdapter((GameType)((Object)t), completeGameEntity, panel){
                final /* synthetic */ GameType val$t;
                final /* synthetic */ GameEntityDTO val$completeGameEntity;
                final /* synthetic */ JPanel val$panel;
                {
                    this.val$t = gameType;
                    this.val$completeGameEntity = gameEntityDTO;
                    this.val$panel = jPanel;
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    if (table.getModel().getRowCount() > 0) {
                        return;
                    }
                    CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                        List<GameEntityDTO> list = ModpackEnitityScene.this.manager.getModpackVersionSubElements(this.val$t, this.val$completeGameEntity.getId());
                        SwingUtilities.invokeLater(() -> {
                            if (list.isEmpty()) {
                                ((CardLayout)this.val$panel.getLayout()).show(this.val$panel, ModpackEnitityScene.EMPTY);
                            } else {
                                table.addElements(list);
                                table.revalidate();
                                table.repaint();
                            }
                        });
                        return null;
                    })).exceptionally(ex -> {
                        U.log(ex);
                        return null;
                    });
                }
            });
        });
        centerView.revalidate();
        centerView.repaint();
        modReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.MOD.toLowerCase());
            }
        });
        resourceReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.RESOURCEPACK.toLowerCase());
            }
        });
        mapReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.MAP.toLowerCase());
            }
        });
        shaderpackReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.SHADERPACK.toLowerCase());
            }
        });
        ((CardLayout)centerView.getLayout()).show(centerView, "REVIEW");
    }

    private abstract class BaseSubtypeModel<T extends CompleteSubEntityScene.BaseModelElement>
    extends CompleteSubEntityScene.GameEntityTableModel {
        protected List<T> list = new ArrayList<T>();

        private BaseSubtypeModel() {
        }

        public abstract GameEntityDTO getRowObject(int var1);

        public T find(GameEntityDTO entity) {
            for (CompleteSubEntityScene.BaseModelElement el : this.list) {
                if (!entity.getId().equals(el.getEntity().getId())) continue;
                return (T)el;
            }
            return null;
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("PROCESSING");
            }
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().reset();
            }
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("REMOVE");
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("INSTALL");
            }
        }
    }

    private class GameEntityTable
    extends CompleteSubEntityScene.ModpackTable {
        GameEntityTable(final GameEntityDTO parent, final GameType type) {
            super(new RemoteEntityModel(type));
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (GameEntityTable.this.getSelectedRow() == -1) {
                        return;
                    }
                    int column = GameEntityTable.this.getSelectedColumn();
                    if (column != 5) {
                        GameEntityDTO gameEntity = ((BaseSubtypeModel)GameEntityTable.this.getModel()).getRowObject(GameEntityTable.this.getSelectedRow());
                        U.log("test12");
                        CompletableFuture.runAsync(() -> DesktopUtil.uncheckCall(() -> {
                            ModpackEnitityScene.this.manager.showSubModpackElement(gameEntity, parent, type);
                            return null;
                        })).exceptionally(ex -> {
                            Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
                            TlauncherUtil.sendLog(ex);
                            return null;
                        });
                    }
                    GameEntityTable.this.getSelectionModel().clearSelection();
                }
            });
            ModpackEnitityScene.this.manager.addGameListener(type, (GameEntityListener)((Object)this.getModel()));
        }

        public void addElements(List<GameEntityDTO> list) {
            RemoteEntityModel rm = (RemoteEntityModel)this.getModel();
            rm.addElements(list);
        }
    }

    private class RemoteEntityModel
    extends BaseSubtypeModel<CompleteSubEntityScene.BaseModelElement> {
        private SimpleDateFormat format = new SimpleDateFormat("dd MMMM YYYY", Localizable.get().getSelected());
        private GameType type;

        RemoteEntityModel(GameType type) {
            this.type = type;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.format.format(((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getUpdateDate());
                }
                case 1: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getName();
                }
                case 2: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getAuthor();
                }
                case 3: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getName();
                }
                case 4: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getType();
                }
                case 5: {
                    ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getModpackActButton().initButton();
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getModpackActButton();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            String line = "";
            switch (column) {
                case 0: {
                    line = Localizable.get("version.manager.editor.field.time");
                    return line.substring(0, line.length() - 1);
                }
                case 1: {
                    return Localizable.get("modpack.table.pack.element.name");
                }
                case 2: {
                    return Localizable.get("modpack.table.pack.element.author");
                }
                case 3: {
                    return Localizable.get("version.release");
                }
                case 4: {
                    line = Localizable.get("version.manager.editor.field.type");
                    return line.substring(0, line.length() - 1);
                }
                case 5: {
                    return Localizable.get("modpack.table.pack.element.operation");
                }
            }
            return "";
        }

        @Override
        public GameEntityDTO getRowObject(int rowIndex) {
            return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return CompleteSubEntityScene.BaseModelElement.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }

        public void addElements(List<GameEntityDTO> list) {
            ModpackComboBox modpackComboBox = TLauncher.getInstance().getFrame().mp.modpackScene.localmodpacks;
            for (GameEntityDTO entity : list) {
                this.list.add(new CompleteSubEntityScene.BaseModelElement(new ModpackTableInstallButton(entity, this.type, modpackComboBox), entity));
            }
        }
    }
}

