/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.settings;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.versions.ReleaseType;
import org.tlauncher.tlauncher.controller.JavaMinecraftController;
import org.tlauncher.tlauncher.entity.minecraft.MinecraftJava;
import org.tlauncher.tlauncher.managers.VersionLists;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.converter.MinecraftJavaConverter;
import org.tlauncher.tlauncher.ui.editor.EditorCheckBox;
import org.tlauncher.tlauncher.ui.editor.EditorComboBox;
import org.tlauncher.tlauncher.ui.editor.EditorFieldChangeListener;
import org.tlauncher.tlauncher.ui.editor.EditorFileField;
import org.tlauncher.tlauncher.ui.editor.EditorResolutionField;
import org.tlauncher.tlauncher.ui.editor.EditorTextField;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.modpack.ConfigurationJavaFrame;
import org.tlauncher.tlauncher.ui.settings.HandlerSettings;
import org.tlauncher.tlauncher.ui.settings.PageSettings;
import org.tlauncher.tlauncher.ui.settings.SettingElement;
import org.tlauncher.tlauncher.ui.settings.SettingsMemorySlider;
import org.tlauncher.tlauncher.ui.swing.extended.BorderPanel;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.ui.CreationModpackComboBoxUI;
import org.tlauncher.util.FileUtil;

public class MinecraftSettings
extends PageSettings {
    public static final String MINECRAFT_SETTING_RAM = "minecraft.memory.ram2";
    SettingsMemorySlider slider;
    @Inject
    private JavaMinecraftController controller;
    private EditorComboBox<MinecraftJava.CompleteMinecraftJava> javaComboBox;
    public static final MinecraftJava.CompleteMinecraftJava defaultJava = MinecraftJava.CompleteMinecraftJava.create(0L, "settings.default", "", new ArrayList<String>());
    @Inject
    private MinecraftJavaConverter converter;

    public MinecraftSettings() {
        this.setOpaque(false);
    }

    private ExtendedPanel doublePanel(JComponent com1, int gap, JComponent comp2) {
        ExtendedPanel extendedPanel = new ExtendedPanel(new FlowLayout(0, 0, 0));
        extendedPanel.add((Component)com1);
        extendedPanel.add(Box.createHorizontalStrut(gap));
        extendedPanel.add((Component)comp2);
        return extendedPanel;
    }

    private ExtendedPanel createBoxes(List<EditorCheckBox> list) {
        ExtendedPanel extendedPanel = new ExtendedPanel();
        extendedPanel.setLayout(new BoxLayout(extendedPanel, 1));
        for (EditorCheckBox box : list) {
            extendedPanel.add((Component)box);
        }
        return extendedPanel;
    }

    @Inject
    public void initGuice() {
        SpringLayout springLayout = new SpringLayout();
        FileChooser fileChooser = (FileChooser)TLauncher.getInjector().getInstance(FileChooser.class);
        fileChooser.setFileSelectionMode(1);
        EditorFileField editorFileField = new EditorFileField("settings.client.gamedir.prompt", fileChooser){

            @Override
            public boolean isValueValid() {
                try {
                    File f = new File(this.getSettingsValue(), "testChooserFolder");
                    FileUtil.createFolder(f);
                    FileUtil.deleteDirectory(f);
                }
                catch (IOException e) {
                    Alert.showLocError("settings.client.gamedir.noaccess", e);
                    return false;
                }
                return super.isValueValid();
            }
        };
        EditorResolutionField editorResolutionField = new EditorResolutionField("settings.client.resolution.width", "settings.client.resolution.height", this.global.getDefaultClientWindowSize(), false);
        EditorCheckBox box = new EditorCheckBox("settings.client.resolution.fullscreen");
        ArrayList<EditorCheckBox> versions = new ArrayList<EditorCheckBox>();
        ArrayList<HandlerSettings> settings = new ArrayList<HandlerSettings>();
        EditorTextField jvmArguments = new EditorTextField("settings.java.args.jvm", true);
        EditorTextField minecraftArguments = new EditorTextField("settings.java.args.minecraft", true);
        ExtendedPanel argPanel1 = new ExtendedPanel();
        argPanel1.setLayout(new BoxLayout(argPanel1, 1));
        UpdaterButton changeJava = new UpdaterButton(UpdaterButton.GRAY_COLOR, new Color(146, 147, 143), "settings.change");
        this.javaComboBox = new EditorComboBox<MinecraftJava.CompleteMinecraftJava>(this.converter, null);
        this.javaComboBox.setUI(new CreationModpackComboBoxUI(){

            @Override
            public String getText(Object value) {
                return MinecraftSettings.this.converter.toString((MinecraftJava.CompleteMinecraftJava)value);
            }
        });
        this.slider = new SettingsMemorySlider();
        EditorFieldChangeListener changeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                TLauncher.getInstance().getVersionManager().updateVersionList();
            }
        };
        BorderPanel b = new BorderPanel(10, 0);
        b.add(this.javaComboBox, "Center");
        b.add((Component)changeJava, "East");
        b.setPreferredSize(new Dimension(0, 21));
        argPanel1.add((Component)b);
        for (ReleaseType releaseType : ReleaseType.getDefinable()) {
            EditorCheckBox editorCheckBox = new EditorCheckBox("settings.versions." + (Object)((Object)releaseType));
            HandlerSettings handlerSettings = new HandlerSettings("minecraft.versions." + (Object)((Object)releaseType), editorCheckBox, changeListener);
            this.addHandler(handlerSettings);
            settings.add(handlerSettings);
            editorCheckBox.setForeground(Color.BLACK);
            versions.add(editorCheckBox);
        }
        EditorCheckBox oldRelease = new EditorCheckBox("settings.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE));
        HandlerSettings handlerSettings = new HandlerSettings("minecraft.versions.sub." + (Object)((Object)ReleaseType.SubType.OLD_RELEASE), oldRelease, changeListener);
        this.addHandler(handlerSettings);
        settings.add(handlerSettings);
        oldRelease.setForeground(Color.BLACK);
        versions.add(2, oldRelease);
        SettingElement directorySettings = new SettingElement("settings.client.gamedir.label", editorFileField, 31);
        SettingElement resolution = new SettingElement("settings.client.resolution.label", this.doublePanel(editorResolutionField, 16, box), 21);
        SettingElement versionList = new SettingElement("settings.versions.label", this.createBoxes(versions), 121);
        SettingElement javaPath = new SettingElement("settings.java.path.label", argPanel1, 0);
        SettingElement memory = new SettingElement("settings.java.memory.label", (JComponent)this.slider, 84, 10, 1);
        ExtendedPanel argPanel = new ExtendedPanel();
        argPanel.setLayout(new BoxLayout(argPanel, 1));
        argPanel.add(Box.createVerticalStrut(9));
        argPanel.add((Component)minecraftArguments);
        SettingElement arguments = new SettingElement("version.manager.editor.field.minecraftArguments", argPanel, 0);
        this.setLayout(springLayout);
        springLayout.putConstraint("North", (Component)directorySettings, 0, "North", (Component)this);
        springLayout.putConstraint("West", (Component)directorySettings, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)directorySettings, 27, "North", (Component)this);
        springLayout.putConstraint("East", (Component)directorySettings, 0, "East", (Component)this);
        this.add((Component)directorySettings);
        springLayout.putConstraint("North", (Component)resolution, 17, "South", (Component)directorySettings);
        springLayout.putConstraint("West", (Component)resolution, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)resolution, 43, "South", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)resolution, 0, "East", (Component)directorySettings);
        this.add((Component)resolution);
        springLayout.putConstraint("North", (Component)versionList, 6, "South", (Component)resolution);
        springLayout.putConstraint("West", (Component)versionList, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)versionList, 138, "South", (Component)resolution);
        springLayout.putConstraint("East", (Component)versionList, 0, "East", (Component)directorySettings);
        this.add((Component)versionList);
        springLayout.putConstraint("North", (Component)arguments, 2, "South", (Component)versionList);
        springLayout.putConstraint("West", (Component)arguments, 0, "West", (Component)this);
        springLayout.putConstraint("South", (Component)arguments, 32, "North", (Component)arguments);
        springLayout.putConstraint("East", (Component)arguments, 0, "East", (Component)directorySettings);
        this.add((Component)arguments);
        springLayout.putConstraint("West", (Component)javaPath, 0, "West", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)javaPath, 0, "East", (Component)directorySettings);
        springLayout.putConstraint("North", (Component)javaPath, 12, "South", (Component)arguments);
        springLayout.putConstraint("South", (Component)javaPath, 23, "North", (Component)javaPath);
        this.add((Component)javaPath);
        springLayout.putConstraint("North", (Component)memory, 18, "South", (Component)javaPath);
        springLayout.putConstraint("South", (Component)memory, 100, "North", (Component)memory);
        springLayout.putConstraint("West", (Component)memory, 0, "West", (Component)directorySettings);
        springLayout.putConstraint("East", (Component)memory, 0, "East", (Component)directorySettings);
        this.add((Component)memory);
        EditorFieldChangeListener editorFieldChangeListener = new EditorFieldChangeListener(){

            @Override
            public void onChange(String oldValue, String newValue) {
                if (!MinecraftSettings.this.tlauncher.isReady()) {
                    return;
                }
                try {
                    MinecraftSettings.this.tlauncher.getManager().getComponent(VersionLists.class).updateLocal();
                }
                catch (IOException e) {
                    Alert.showLocError("settings.client.gamedir.noaccess", e);
                    return;
                }
                MinecraftSettings.this.tlauncher.getVersionManager().asyncRefresh();
                MinecraftSettings.this.tlauncher.getProfileManager().asyncRefresh();
            }
        };
        changeJava.addActionListener(e -> {
            ConfigurationJavaFrame frame = (ConfigurationJavaFrame)TLauncher.getInjector().getInstance(ConfigurationJavaFrame.class);
            frame.setVisible(true);
        });
        this.addHandler(new HandlerSettings("minecraft.gamedir", editorFileField, editorFieldChangeListener));
        this.addHandler(new HandlerSettings("minecraft.size", editorResolutionField));
        this.addHandler(new HandlerSettings("minecraft.fullscreen", box));
        this.addHandler(new HandlerSettings("minecraft.javaargs", jvmArguments));
        this.addHandler(new HandlerSettings("minecraft.args", minecraftArguments));
        this.addHandler(new HandlerSettings(MINECRAFT_SETTING_RAM, this.slider));
        this.addHandler(new HandlerSettings("minecraft.args", minecraftArguments));
        this.addHandler(new HandlerSettings("minecraft.java.selected", this.javaComboBox));
    }

    @Override
    public void init() {
        this.controller.notifyListeners();
        this.slider.initMemoryQuestion();
        super.init();
    }

    @Subscribe
    public void applicationEvent(MinecraftJava event) {
        SwingUtilities.invokeLater(() -> {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.javaComboBox.getModel();
            MinecraftJava.CompleteMinecraftJava c = this.controller.getCurrent();
            model.removeAllElements();
            model.addElement(defaultJava);
            event.getJvm().values().forEach(model::addElement);
            if (Objects.nonNull(c)) {
                this.javaComboBox.setSelectedValue(c);
            } else {
                this.javaComboBox.setSelectedValue(defaultJava);
            }
        });
    }
}

