/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.updater.bootstrapper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.tlauncher.modpack.domain.client.version.MetadataDTO;
import org.tlauncher.tlauncher.downloader.Downloadable;
import org.tlauncher.tlauncher.downloader.DownloadableContainer;
import org.tlauncher.tlauncher.downloader.DownloadableContainerHandlerAdapter;
import org.tlauncher.tlauncher.downloader.Downloader;
import org.tlauncher.tlauncher.downloader.RetryDownloadException;
import org.tlauncher.tlauncher.repository.Repo;
import org.tlauncher.tlauncher.rmo.Bootstrapper;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.updater.bootstrapper.PreparedEnvironmentComponent;
import org.tlauncher.tlauncher.updater.bootstrapper.model.DownloadedBootInfo;
import org.tlauncher.tlauncher.updater.bootstrapper.model.DownloadedElement;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaConfig;
import org.tlauncher.tlauncher.updater.bootstrapper.model.JavaDownloadedElement;
import org.tlauncher.tlauncher.updater.bootstrapper.model.LibraryConfig;
import org.tlauncher.util.FileUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;

public class PreparedEnvironmentComponentImpl
implements PreparedEnvironmentComponent {
    private final LibraryConfig config;
    private final JavaConfig javaConfig;
    private final File workFolder;
    private final File jvmsFolder;
    private Downloader downloader;

    @Override
    public List<String> getLibrariesForRunning() {
        List<DownloadedElement> list = this.config.getLibraries();
        ArrayList<String> result = new ArrayList<String>();
        for (DownloadedElement downloadedElement : list) {
            File f = new File(this.workFolder, downloadedElement.getStoragePath());
            result.add(f.getPath());
        }
        return result;
    }

    @Override
    public DownloadedBootInfo validateLibraryAndJava() {
        ArrayList<DownloadedElement> result = new ArrayList<DownloadedElement>();
        List<DownloadedElement> list = this.config.getLibraries();
        for (DownloadedElement downloadedElement : list) {
            if (!downloadedElement.notExistOrValid(this.workFolder)) continue;
            result.add(downloadedElement);
        }
        DownloadedBootInfo el = new DownloadedBootInfo();
        el.setLibraries(result);
        JavaDownloadedElement javaDownloadedElement = TlauncherUtil.getProperJavaElement(this.javaConfig);
        if (!javaDownloadedElement.existFolder(this.jvmsFolder)) {
            el.setElement(javaDownloadedElement);
            return el;
        }
        return el;
    }

    @Override
    public void preparedLibrariesAndJava(DownloadedBootInfo info) {
        if (info.getLibraries().isEmpty() && Objects.isNull(info.getElement())) {
            return;
        }
        if (Objects.nonNull(info.getElement())) {
            MetadataDTO metadataDTO = new MetadataDTO();
            metadataDTO.setUrl("");
            metadataDTO.setPath(info.getElement().getStoragePath());
            metadataDTO.setSha1(info.getElement().getShaCode());
            metadataDTO.setSize(info.getElement().getSize());
            metadataDTO.setLocalDestination(new File(this.jvmsFolder, info.getElement().getStoragePath()));
            DownloadableContainer javaDownloadableContainer = new DownloadableContainer();
            DownloadableDownloadElement downloadedJava = new DownloadableDownloadElement(info.getElement(), metadataDTO);
            javaDownloadableContainer.add(downloadedJava);
            javaDownloadableContainer.addHandler(new DownloadableHandler(this.jvmsFolder){

                @Override
                public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
                    DownloadableDownloadElement el = (DownloadableDownloadElement)d;
                    super.onComplete(c, d);
                    JavaDownloadedElement original = (JavaDownloadedElement)el.getElement();
                    File javaFolder = new File(PreparedEnvironmentComponentImpl.this.jvmsFolder, original.getJavaFolder());
                    boolean originalJVM = original.isOriginalJVM();
                    File tempJVM = new File(javaFolder + "_temp");
                    try {
                        if (javaFolder.exists()) {
                            FileUtil.deleteDirectory(javaFolder);
                        }
                        if (tempJVM.exists()) {
                            FileUtil.deleteDirectory(tempJVM);
                        }
                        PreparedEnvironmentComponentImpl.this.unpack(d, originalJVM, tempJVM);
                        File javaTempFolder = originalJVM ? new File(tempJVM, original.getJavaFolder()) : tempJVM;
                        File java = new File(OS.appendBootstrapperJvm(javaTempFolder.getPath()));
                        if (OS.is(OS.LINUX)) {
                            Files.setPosixFilePermissions(java.toPath(), FileUtil.PERMISSIONS);
                        }
                        if (!javaTempFolder.renameTo(javaFolder)) {
                            FileUtils.copyDirectory(javaTempFolder, javaFolder);
                        }
                        if (tempJVM.exists()) {
                            FileUtil.deleteFile(tempJVM);
                        }
                        FileUtil.deleteFile(d.getMetadataDTO().getLocalDestination());
                    }
                    catch (IOException t) {
                        U.log(t);
                        if (javaFolder.exists()) {
                            FileUtil.deleteDirectory(javaFolder);
                        }
                        throw new RetryDownloadException("cannot unpack archive", t);
                    }
                }
            });
            this.downloader.add(javaDownloadableContainer);
        }
        if (!info.getLibraries().isEmpty()) {
            DownloadableContainer container = new DownloadableContainer();
            for (DownloadedElement e : info.getLibraries()) {
                MetadataDTO metadataDTO = new MetadataDTO();
                metadataDTO.setUrl("");
                metadataDTO.setPath(e.getStoragePath());
                metadataDTO.setSha1(e.getShaCode());
                metadataDTO.setSize(e.getSize());
                metadataDTO.setLocalDestination(new File(this.workFolder, e.getStoragePath()));
                container.add(new DownloadableDownloadElement(e, metadataDTO));
            }
            container.addHandler(new DownloadableHandler(this.workFolder));
            this.downloader.add(container);
        }
        this.downloader.startDownloadAndWait();
    }

    private void unpack(Downloadable d, Boolean originalJVM, File tempJVM) throws IOException {
        if (OS.is(OS.OSX)) {
            try {
                String[] commands = new String[]{"tar", "-xf", d.getMetadataDTO().getLocalDestination().getPath()};
                ProcessBuilder p = new ProcessBuilder(commands);
                p.directory(this.jvmsFolder);
                Process process = p.start();
                try {
                    process.waitFor(90L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable e) {
                TlauncherUtil.showCriticalProblem(e);
            }
        } else if (originalJVM.booleanValue()) {
            FileUtil.unTarGz(d.getMetadataDTO().getLocalDestination(), tempJVM, false, false);
        } else {
            FileUtil.unZip(d.getMetadataDTO().getLocalDestination(), this.jvmsFolder, false, false);
        }
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public PreparedEnvironmentComponentImpl(LibraryConfig config, JavaConfig javaConfig, File workFolder, File jvmsFolder, Downloader downloader) {
        this.config = config;
        this.javaConfig = javaConfig;
        this.workFolder = workFolder;
        this.jvmsFolder = jvmsFolder;
        this.downloader = downloader;
    }

    private static class DownloadableHandler
    extends DownloadableContainerHandlerAdapter {
        private File downloadFolder;

        @Override
        public void onComplete(DownloadableContainer c, Downloadable d) throws RetryDownloadException {
            DownloadableDownloadElement el = (DownloadableDownloadElement)d;
            if (el.getElement().notExistOrValid(this.downloadFolder)) {
                throw new RetryDownloadException("illegal library hash. " + el.getElement());
            }
        }

        @Override
        public void onError(DownloadableContainer c, Downloadable d, Throwable e) {
            U.log(e);
            TlauncherUtil.showCriticalProblem(Bootstrapper.langConfiguration.get("updater.download.fail", ""));
            TLauncher.kill();
        }

        public File getDownloadFolder() {
            return this.downloadFolder;
        }

        public void setDownloadFolder(File downloadFolder) {
            this.downloadFolder = downloadFolder;
        }

        public String toString() {
            return "PreparedEnvironmentComponentImpl.DownloadableHandler(downloadFolder=" + this.getDownloadFolder() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadableHandler)) {
                return false;
            }
            DownloadableHandler other = (DownloadableHandler)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            File this$downloadFolder = this.getDownloadFolder();
            File other$downloadFolder = other.getDownloadFolder();
            return !(this$downloadFolder == null ? other$downloadFolder != null : !((Object)this$downloadFolder).equals(other$downloadFolder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DownloadableHandler;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            File $downloadFolder = this.getDownloadFolder();
            result = result * 59 + ($downloadFolder == null ? 43 : ((Object)$downloadFolder).hashCode());
            return result;
        }

        public DownloadableHandler(File downloadFolder) {
            this.downloadFolder = downloadFolder;
        }
    }

    public static class DownloadableDownloadElement
    extends Downloadable {
        private DownloadedElement element;

        DownloadableDownloadElement(DownloadedElement element, MetadataDTO metadataDTO) {
            super(new Repo(element.getUrl().toArray(new String[0]), "BOOTSTRAP"), metadataDTO);
            this.element = element;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadableDownloadElement)) {
                return false;
            }
            DownloadableDownloadElement other = (DownloadableDownloadElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownloadedElement this$element = this.getElement();
            DownloadedElement other$element = other.getElement();
            return !(this$element == null ? other$element != null : !((Object)this$element).equals(other$element));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DownloadableDownloadElement;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            DownloadedElement $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : ((Object)$element).hashCode());
            return result;
        }

        public DownloadedElement getElement() {
            return this.element;
        }

        public void setElement(DownloadedElement element) {
            this.element = element;
        }

        @Override
        public String toString() {
            return "PreparedEnvironmentComponentImpl.DownloadableDownloadElement(element=" + this.getElement() + ")";
        }
    }
}

