- I think we should note some useful information that we have learned from this project. For example, how to use the API, database, website, helper tools, etc... Or something simple like which command to use in order to run the program.

![The First Minigame - introduction](./minecraft/assets/images/thefirstminigame_introduction.gif)

# Minecraft Server
## How to run the PaperMC server
- Requirements: Java (17 or later), [PaperMC 1.20.4-342](https://papermc.io/downloads) (or later)
```bash
# Mine (lesongvi) has 16GB of RAM, but I only allocate 4GB of RAM to the server, so that I can run other programs on my computer.
java -Xms4G -Xmx4G -jar paper.jar --nogui
```

<small>You can change the amount of memory allocated to the server by changing the -Xms and -Xmx parameters, where -Xms is the minimum amount of memory and -Xmx is the maximum amount of memory. You should allocate it based on the amount of memory (RAM) you have on your computer.</small>

## Install plugins
### ServerTap
- ServerTap is a minecraft plugin that allows us to run commands on the server from the website. Some kind of REST API.
- Check repository: [ServerTap](https://github.com/servertap-io/servertap)

### WorldEdit mod
- WorldEdit is a minecraft mod that allows us to edit the world in-game.

### skRayFall
- This is plugin of Skript that allows us to have more features in Skript. Currently, we use this plugin to create screen text. For more information, check [here](https://skripthub.net/docs/?addon=skRayFall)

### GhastTheKiller (internal plugin)
- This is an internal plugin to help us with some tasks. For example, spawn bosses, move it and attack players, change the weather, handle event when player hit by a minecart, etc... Mainly, this plugin is used to handle the boss event since skript is not powerful enough to handle it.

## Map and Texture
- Read more [here](./minecraft/MapAndTextures/README.md)
### Active Invisible Texture Packs 
```bash
Mutilplayer -> Add Server -> Enter Server Name & Server Address -> Server Resource Packs : Enabled -> Done
```

## Code convention
- Read more [here](./docs/CODE_CONVENTION.md)

## Documentation reference
- [PaperMC's documentation](https://docs.papermc.io/)
- [Official SkriptLang's documentation](https://docs.skriptlang.org/docs.html)
- [Unofficial SkriptLang's documentation - seems to be more detailed](https://docs.skunity.com/syntax/search/addon:Skript)
- [skRayFall's documentation](https://skripthub.net/docs/?addon=skRayFall) or [here](https://docs.skunity.com/syntax/search/addon:skrayfall)

## Common errors
### Failed to verify username
- Solve: set online-mode to false in server.properties

## Note
- Ensure that you run proper version of paper server and minecraft client. Otherwise, you will not be able to connect to the server.
- Sometimes, the script in scripts folder may obsolete. You should run the helper script "syncscript" in helper folder to update the script in scripts folder.