# Hope this script helps us to hide our skript code from the skript kiddies
import random
import string
import glob
import os
import re
import yaml

mapping_old_new_function_name = dict()
mapping_old_new_global_variable_name = dict()
mapping_old_new_global_object_name = dict()

def obfuscate_skript(skript_code):
    lines = skript_code.split('\n')
    obfuscated_lines = []
    variable_mapping = {}
    for line in lines:
        obfuscated_line = ''
        words = line.split(' ')
        for word in words:
            regex = r"{_([a-zA-Z0-9]+)}"
            if re.findall(regex, word, re.MULTILINE):
                variable_name = re.findall(regex, word, re.MULTILINE)[0]
                if variable_name not in variable_mapping:
                    obfuscated_name = obfuscate_word(variable_name)
                    variable_mapping[variable_name] = obfuscated_name
                obfuscated_line += word.replace('{_' + variable_name + '}', '{_' + variable_mapping[variable_name] + '}') + ' '
            else:
                obfuscated_line += word + ' '

        obfuscated_lines.append(obfuscated_line)

    obfuscate_skript_obfuscated_code = '\n'.join(obfuscated_lines)
    return obfuscate_skript_obfuscated_code

def obfuscate_skript2(skript_code):
    lines = skript_code.split('\n')
    obfuscated_lines = []
    for line in lines:
        obfuscated_line = ''
        if random.random() < 0.5:
            obfuscated_line += generate_useless_comment() + '\n'
        obfuscated_line += line
        obfuscated_lines.append(obfuscated_line)
    obfuscate_skript2_obfuscated_code = '\n'.join(obfuscated_lines)
    return obfuscate_skript2_obfuscated_code

def remove_skript_comments(skript_code):
    lines = skript_code.split('\n')
    obfuscated_lines = []
    for line in lines:
        if not line.strip().startswith('#'):
            obfuscated_lines.append(line)
    obfuscated_code = '\n'.join(obfuscated_lines)
    return obfuscated_code

def extract_option(skript_code, option):
    lines = skript_code.split('\n')
    regex = r"^options:\s*^([\s\S]*?)(?=^\S|\Z)"
    matches = re.findall(regex, skript_code, re.MULTILINE)

    if matches:
        lines = matches[0].split('\n')
        counter = 0
        for line in lines:
            counter+=1
            if not line.startswith('#') and ':' in line:
                option_name = line.split(':')[0].strip()
                option_value = line.split(':')[1].strip()
                if option_name not in option:
                    option[option_name] = option_value
                else:
                    option_name = option_name + random.choice('abcdefghijklmnopqrstuvwxyz') + str(counter)
                    option[option_name] = option_value
                    skript_code = skript_code.replace('{@' + line.split(':')[0].strip() + '}', '{@' + option_name + '}')
        skript_code = skript_code.replace("options:\n" + matches[0], '')
    return skript_code, option

def generate_useless_comment():
    comment = '# ' + ''.join(random.choices(string.ascii_lowercase, k=random.randint(5, 10)))
    return comment

def obfuscate_word(word):
    obfuscated_word = ''
    if len(word) < 12:
        word += ''.join(random.choices(string.ascii_lowercase, k=12-len(word)))
    for char in word:
        if char.isalpha():
            obfuscated_word += random.choice('abcdefghijklmnopqrstuvwxyz')
        else:
            obfuscated_word += char
    return obfuscated_word

def merged_all_files_into_one(new_file_content, obfuscated_skript):
    new_file_content += obfuscated_skript + '\n'
    return new_file_content

def obfuscate_function_name(skript_code):
    obfuscated_code = skript_code
    regex = r"^function\s*([\s\S]*?)\((.*?)\)\s*(.*?)$[\S\r\n]*^([\s\S]*?)(?=^\S|\Z)"
    matchesList = re.findall(regex, skript_code, re.MULTILINE)
    for match in matchesList:
        if match:
            function_name = match[0].strip()
            parameters = match[1].strip()
            return_value = match[2].strip()
            function_body = match[3]
        if function_name is None:
            return None
        if parameters is not None:
            parameters_txt = parameters.strip()
            parameters_txt = parameters_txt.split(',')
            new_parameters_txt = ""
            for parameter in parameters_txt:
                parameter = parameter.split(":")
                if len(parameter) < 2:
                    continue
                parameter_name = parameter[0].strip()
                parameter_type = parameter[1].strip()
                obfuscated_parameter_name = obfuscate_word(parameter_name)
                if new_parameters_txt == "":
                    new_parameters_txt = obfuscated_parameter_name + ": " + parameter_type
                else:
                    new_parameters_txt += ", " + obfuscated_parameter_name + ": " + parameter_type
                regex = r"{_" + parameter_name + "(?:::(?:.*)?})"
                regex2 = r"{_" + parameter_name + "}"
                if re.findall(regex, function_body, re.MULTILINE) and re.findall(regex2, function_body, re.MULTILINE):
                    print("Error: You can't have the same name for normal type variable and object type variable in function " + function_name)
                    return None
                elif re.findall(regex, function_body, re.MULTILINE):
                    function_body = function_body.replace('{_' + parameter_name + '::', '{222_flag_to_change' + obfuscated_parameter_name + '::')
                elif re.findall(regex2, function_body, re.MULTILINE):
                    function_body = function_body.replace('{_' + parameter_name + '}', '{222_flag_to_change' + obfuscated_parameter_name + '}')
        obfuscated_function_name = obfuscate_word(function_name)
        mapping_old_new_function_name[function_name] = obfuscated_function_name
        return_value = return_value.strip()
        if "::" in return_value:
            return_value = " " + return_value
        obfuscated_code = re.sub(r"^function\s*" + function_name + "\s*\((.*?)\)\s*(.*?)$[\S\r\n]*^([\s\S]*?)(?=^\S|\Z)", "function " + obfuscated_function_name + "(" + new_parameters_txt + ")" + return_value + "\n" + function_body, obfuscated_code, flags=re.MULTILINE)
    return obfuscated_code

def replace_old_new_function_name(all_code):
    for old_function_name, new_function_name in mapping_old_new_function_name.items():
        all_code = re.sub(r"(?<!\S)" + old_function_name + "\s*?\(", new_function_name + "(", all_code, flags=re.MULTILINE)
    return all_code

def obfuscate_global_variable_name(skript_code):
    obfuscated_code = skript_code
    regex = r"{([a-zA-Z0-9]+)?(::(?:.*)?}|})"
    matchesList = re.findall(regex, skript_code, re.MULTILINE)
    for match in matchesList:
        is_object = False
        if match:
            global_variable_name = match[0].strip()
            check_for_object = match[1].strip()
            if "::" in check_for_object:
                is_object = True
                global_variable_name = global_variable_name.split("::")[0]
            obfuscated_global_variable_name = obfuscate_word(global_variable_name)
            if is_object:
                if global_variable_name in mapping_old_new_global_object_name:
                    continue
                else:
                    mapping_old_new_global_object_name[global_variable_name] = obfuscated_global_variable_name
            else:
                if global_variable_name in mapping_old_new_global_variable_name:
                    continue
                else:
                    mapping_old_new_global_variable_name[global_variable_name] = obfuscated_global_variable_name
    return obfuscated_code

def replace_old_new_global_variable_name(all_code):
    for old_global_variable_name, new_global_variable_name in mapping_old_new_global_variable_name.items():
        all_code = all_code.replace('{' + old_global_variable_name + '}', '{' + new_global_variable_name + '}')
    for old_global_object_name, new_global_object_name in mapping_old_new_global_object_name.items():
        all_code = all_code.replace('{' + old_global_object_name + '::', '{' + new_global_object_name + '::')
    return all_code

def replace_old_new_option_name(all_code, option):
    newOptionText = 'options:\n'
    for option_name, option_value in option.items():
        new_option_name = obfuscate_word(option_name)
        new_option_name = new_option_name.strip()
        all_code = all_code.replace('{@' + option_name + '}', '{@' + new_option_name + '}')
        newOptionText += '	' + new_option_name + ': ' + option_value + '\n'

    all_code = newOptionText + all_code
    return all_code

absolute_folder_path = os.path.dirname(
  os.path.abspath(__file__))
skript_path = absolute_folder_path + "/../server/plugins/Skript/scripts/je_v1/"
sk_files = glob.glob(skript_path + "/*.sk")
new_path = absolute_folder_path + "/obfuscated_skripts/"
version_file_path = skript_path + "version.yml"
if not os.path.exists(new_path):
  os.makedirs(new_path)
elif os.listdir(new_path):
  for file in os.listdir(new_path):
    os.remove(new_path + file)

new_file_content = ''

option = dict()
for sk_file in sk_files:
    with open(sk_file, 'r', encoding='utf-8') as f:
        skript_code = f.read()
    skript_code, option = extract_option(skript_code, option)
    if option == None:
        exit()
    removed_comments_code = remove_skript_comments(skript_code)
    removed_comments_code = obfuscate_function_name(removed_comments_code)
    if removed_comments_code == None:
        exit()
    removed_comments_code = obfuscate_global_variable_name(removed_comments_code)
    obfuscated_code = obfuscate_skript(removed_comments_code)
    obfuscated_skript = obfuscate_skript2(obfuscated_code)
    new_file_content = merged_all_files_into_one(new_file_content, obfuscated_skript)

version_line = ''

with open(version_file_path, "r", encoding='utf-8') as stream:
    try:
        version_content = yaml.safe_load(stream)

        skript_version = version_content['Version']

        je_ycv = "# Your current version is " + skript_version

        je_cpat = "#    ____  __ __  ___ ___  ____   ___  _____   __   ____  ____   ___ \n"
        je_cpat += "#   |    ||  |  ||   |   ||    \ /  _]/ ___/  /  ] /    ||    \ /  _]\n"
        je_cpat += "#   |__  ||  |  || _   _ ||  o  )  [_(   \_  /  / |  o  ||  o  )  [_ \n"
        je_cpat += "#   __|  ||  |  ||  \_/  ||   _/    _]\__  |/  /  |     ||   _/    _]\n"
        je_cpat += "#  /  |  ||  :  ||   |   ||  | |   [_ /  \ /   \_ |  _  ||  | |   [_ \n"
        je_cpat += "#  \  `  ||     ||   |   ||  | |     |\    \     ||  |  ||  | |     |\n"
        je_cpat += "#   \____j \__,_||___|___||__| |_____| \___|\____||__|__||__| |_____|"

        box_edge = "# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #"

        version_line = box_edge + '\n' + '#\n' + je_cpat + '\n#\n' + je_ycv + '\n# Please always check the latest version at https://versionmanager.vi2k.com/skripts/jump_escape/' + skript_version + '/version.json\n' + '#\n' + box_edge

        option['versionCheck'] = skript_version
    except yaml.YAMLError as e:
        print(e)

done_code = replace_old_new_function_name(new_file_content)
done_code = replace_old_new_global_variable_name(done_code)
done_code = replace_old_new_option_name(done_code, option)
done_code = done_code.replace('222_flag_to_change', '_')
done_code = version_line + '\n\n\n' + done_code

with open(new_path + "je_v1.sk", 'w', encoding='utf-8') as f:
    f.write(done_code)

input("Press enter to exit..")
